// WEBGL BUILT-IN TYPES
// 1) Exports all WebGL constants as {GL}
// 2) Enables app to "import" WebGL types
//    - Importing these types makes them known to eslint etc.
//    - Provides dummy types for WebGL2 when not available to streamline
//      library code.
//    - Exports types from headless gl when running under Node.js

/* eslint-disable quotes, no-console */

/* global console */
import { global } from '../utils/globals';
import isBrowser from '../utils/is-browser'; // Load headless gl dynamically, if available

export let headlessTypes = null;

if (!isBrowser) {
  try {
    headlessTypes = module.require('gl/wrap');
  } catch (error) {
    console.error(`${error.message}`);
  }

  console.warn(headlessTypes && headlessTypes.WebGLRenderingContext);
}

class DummyType {}

const _ref = headlessTypes || global,
      _ref$WebGLRenderingCo = _ref.WebGLRenderingContext,
      WebGLRenderingContext = _ref$WebGLRenderingCo === void 0 ? DummyType : _ref$WebGLRenderingCo,
      _ref$WebGLProgram = _ref.WebGLProgram,
      WebGLProgram = _ref$WebGLProgram === void 0 ? DummyType : _ref$WebGLProgram,
      _ref$WebGLShader = _ref.WebGLShader,
      WebGLShader = _ref$WebGLShader === void 0 ? DummyType : _ref$WebGLShader,
      _ref$WebGLBuffer = _ref.WebGLBuffer,
      WebGLBuffer = _ref$WebGLBuffer === void 0 ? DummyType : _ref$WebGLBuffer,
      _ref$WebGLFramebuffer = _ref.WebGLFramebuffer,
      WebGLFramebuffer = _ref$WebGLFramebuffer === void 0 ? DummyType : _ref$WebGLFramebuffer,
      _ref$WebGLRenderbuffe = _ref.WebGLRenderbuffer,
      WebGLRenderbuffer = _ref$WebGLRenderbuffe === void 0 ? DummyType : _ref$WebGLRenderbuffe,
      _ref$WebGLTexture = _ref.WebGLTexture,
      WebGLTexture = _ref$WebGLTexture === void 0 ? DummyType : _ref$WebGLTexture,
      _ref$WebGLUniformLoca = _ref.WebGLUniformLocation,
      WebGLUniformLocation = _ref$WebGLUniformLoca === void 0 ? DummyType : _ref$WebGLUniformLoca,
      _ref$WebGLActiveInfo = _ref.WebGLActiveInfo,
      WebGLActiveInfo = _ref$WebGLActiveInfo === void 0 ? DummyType : _ref$WebGLActiveInfo,
      _ref$WebGLShaderPreci = _ref.WebGLShaderPrecisionFormat,
      WebGLShaderPrecisionFormat = _ref$WebGLShaderPreci === void 0 ? DummyType : _ref$WebGLShaderPreci;

export const webGLTypesAvailable = WebGLRenderingContext !== DummyType && WebGLProgram !== DummyType && WebGLShader !== DummyType && WebGLBuffer !== DummyType && WebGLFramebuffer !== DummyType && WebGLRenderbuffer !== DummyType && WebGLTexture !== DummyType && WebGLUniformLocation !== DummyType && WebGLActiveInfo !== DummyType && WebGLShaderPrecisionFormat !== DummyType; // Ensures that WebGL2RenderingContext is defined in non-WebGL2 environments
// so that apps can test their gl contexts with instanceof
// E.g. if (gl instanceof WebGL2RenderingContext) { }

function getWebGL2RenderingContext() {
  class WebGL2RenderingContextNotSupported {}

  return global.WebGL2RenderingContext || WebGL2RenderingContextNotSupported;
} // Ensure that Image is defined under Node.js


function getImage() {
  class ImageNotSupported {}

  return global.Image || ImageNotSupported;
}

const WebGL2RenderingContext = getWebGL2RenderingContext();
const Image = getImage(); // Export the standard WebGL types

export { Image, WebGLRenderingContext, WebGLProgram, WebGLShader, WebGLBuffer, WebGLFramebuffer, WebGLRenderbuffer, WebGLTexture, WebGLUniformLocation, WebGLActiveInfo, WebGLShaderPrecisionFormat, WebGL2RenderingContext };
//# sourceMappingURL=webgl-types.js.map