function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import Object3D from './object-3d';
import { Matrix4 } from 'math.gl';
import assert from '../utils/assert';

var Group =
/*#__PURE__*/
function (_Object3D) {
  _inherits(Group, _Object3D);

  function Group() {
    var _this;

    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Group);

    var _opts$children = opts.children,
        children = _opts$children === void 0 ? [] : _opts$children;
    children.every(function (child) {
      return assert(_instanceof(child, Object3D));
    });
    _this = _possibleConstructorReturn(this, (Group.__proto__ || Object.getPrototypeOf(Group)).call(this, opts));
    _this.children = children;
    return _this;
  } // Unpacks arrays and nested arrays of children


  _createClass(Group, [{
    key: "add",
    value: function add() {
      for (var _len = arguments.length, children = new Array(_len), _key = 0; _key < _len; _key++) {
        children[_key] = arguments[_key];
      }

      for (var _i = 0; _i < children.length; _i++) {
        var child = children[_i];

        if (Array.isArray(child)) {
          this.add.apply(this, _toConsumableArray(child));
        } else {
          this.children.push(child);
        }
      }

      return this;
    }
  }, {
    key: "remove",
    value: function remove(child) {
      var children = this.children;
      var indexOf = children.indexOf(child);

      if (indexOf > -1) {
        children.splice(indexOf, 1);
      }

      return this;
    }
  }, {
    key: "removeAll",
    value: function removeAll() {
      this.children = [];
      return this;
    } // If visitor returns a truthy value, traversal will be aborted and that value
    // will be returned from `traverse`. Otherwise `traverse` will return null.

  }, {
    key: "traverse",
    value: function traverse(visitor) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref$modelMatrix = _ref.modelMatrix,
          modelMatrix = _ref$modelMatrix === void 0 ? new Matrix4() : _ref$modelMatrix;

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this.children[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var child = _step.value;
          var matrix = child.matrix;
          modelMatrix = modelMatrix.multiplyRight(matrix);
          var result = void 0;

          if (_instanceof(child, Group)) {
            result = child.traverse(visitor, {
              modelMatrix: modelMatrix
            });
          } else {
            // child.setUniforms({modelMatrix});
            result = visitor(child, {});
          } // Abort if a result was returned


          if (result) {
            return result;
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return null;
    } // If visitor returns a truthy value, traversal will be aborted and that value
    // will be returned from `traverseReverse`. Otherwise `traverseReverse` will return null.

  }, {
    key: "traverseReverse",
    value: function traverseReverse(visitor) {
      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref2$modelMatrix = _ref2.modelMatrix,
          modelMatrix = _ref2$modelMatrix === void 0 ? new Matrix4() : _ref2$modelMatrix;

      for (var i = this.children.length - 1; i >= 0; --i) {
        var child = this.children[i];
        var matrix = child.matrix;
        modelMatrix = modelMatrix.multiplyRight(matrix);
        var result = void 0;

        if (_instanceof(child, Group)) {
          result = child.traverseReverse(visitor, {
            modelMatrix: modelMatrix
          });
        } else {
          // child.setUniforms({modelMatrix});
          result = visitor(child, {});
        } // Abort if a result was returned


        if (result) {
          return result;
        }
      }

      return null;
    }
  }]);

  return Group;
}(Object3D);

export { Group as default };
//# sourceMappingURL=group.js.map