function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Supports loading (requesting) assets with XHR (XmlHttpRequest)

/* eslint-disable guard-for-in, complexity, no-try-catch */

/* global XMLHttpRequest */
function noop() {}

var XHR_STATES = {
  UNINITIALIZED: 0,
  LOADING: 1,
  LOADED: 2,
  INTERACTIVE: 3,
  COMPLETED: 4
};

var XHR =
/*#__PURE__*/
function () {
  function XHR(_ref) {
    var url = _ref.url,
        _ref$path = _ref.path,
        path = _ref$path === void 0 ? null : _ref$path,
        _ref$method = _ref.method,
        method = _ref$method === void 0 ? 'GET' : _ref$method,
        _ref$asynchronous = _ref.asynchronous,
        asynchronous = _ref$asynchronous === void 0 ? true : _ref$asynchronous,
        _ref$noCache = _ref.noCache,
        noCache = _ref$noCache === void 0 ? false : _ref$noCache,
        _ref$sendAsBinary = _ref.sendAsBinary,
        sendAsBinary = _ref$sendAsBinary === void 0 ? false : _ref$sendAsBinary,
        _ref$responseType = _ref.responseType,
        responseType = _ref$responseType === void 0 ? false : _ref$responseType,
        _ref$onProgress = _ref.onProgress,
        onProgress = _ref$onProgress === void 0 ? noop : _ref$onProgress,
        _ref$onError = _ref.onError,
        onError = _ref$onError === void 0 ? noop : _ref$onError,
        _ref$onAbort = _ref.onAbort,
        onAbort = _ref$onAbort === void 0 ? noop : _ref$onAbort,
        _ref$onComplete = _ref.onComplete,
        onComplete = _ref$onComplete === void 0 ? noop : _ref$onComplete;

    _classCallCheck(this, XHR);

    this.url = path ? path.join(path, url) : url;
    this.method = method;
    this.async = asynchronous;
    this.noCache = noCache;
    this.sendAsBinary = sendAsBinary;
    this.responseType = responseType;
    this.req = new XMLHttpRequest();

    this.req.onload = function (e) {
      return onComplete(e);
    };

    this.req.onerror = function (e) {
      return onError(e);
    };

    this.req.onabort = function (e) {
      return onAbort(e);
    };

    this.req.onprogress = function (e) {
      if (e.lengthComputable) {
        onProgress(e, Math.round(e.loaded / e.total * 100));
      } else {
        onProgress(e, -1);
      }
    };
  }

  _createClass(XHR, [{
    key: "setRequestHeader",
    value: function setRequestHeader(header, value) {
      this.req.setRequestHeader(header, value);
      return this;
    } // /* eslint-disable max-statements */

  }, {
    key: "sendAsync",
    value: function sendAsync() {
      var _this = this;

      var body = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.body || null;
      return new Promise(function (resolve, reject) {
        try {
          var req = _this.req,
              method = _this.method,
              noCache = _this.noCache,
              sendAsBinary = _this.sendAsBinary,
              responseType = _this.responseType;
          var url = noCache ? _this.url + (_this.url.indexOf('?') >= 0 ? '&' : '?') + Date.now() : _this.url;
          req.open(method, url, _this.async);

          if (responseType) {
            req.responseType = responseType;
          }

          if (_this.async) {
            req.onreadystatechange = function (e) {
              if (req.readyState === XHR_STATES.COMPLETED) {
                if (req.status === 200) {
                  resolve(req.responseType ? req.response : req.responseText);
                } else {
                  reject(new Error("".concat(req.status, ": ").concat(url)));
                }
              }
            };
          }

          if (sendAsBinary) {
            req.sendAsBinary(body);
          } else {
            req.send(body);
          }

          if (!_this.async) {
            if (req.status === 200) {
              resolve(req.responseType ? req.response : req.responseText);
            } else {
              reject(new Error("".concat(req.status, ": ").concat(url)));
            }
          }
        } catch (error) {
          reject(error);
        }
      });
    }
    /* eslint-enable max-statements */

  }]);

  return XHR;
}();

export function requestFile(opts) {
  var xhr = new XHR(opts);
  return xhr.sendAsync();
}
//# sourceMappingURL=browser-request-file.js.map