function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

// Image loading/saving for browser

/* global document, HTMLCanvasElement, Image */

/* global process, Buffer */
import assert from 'assert';
import through from 'through';
/*
 * Returns data bytes representing a compressed image in PNG or JPG format,
 * This data can be saved using file system (f) methods or
 * used in a request.
 * @param {Image}  image - Image or Canvas
 * @param {String} opt.type='png' - png, jpg or image/png, image/jpg are valid
 * @param {String} opt.dataURI= - Whether to include a data URI header
 */

export function compressImage(image, type) {
  if (_instanceof(image, HTMLCanvasElement)) {
    var _canvas = image;
    return _canvas.toDataURL(type);
  }

  assert(_instanceof(image, Image), 'getImageData accepts image or canvas');
  var canvas = document.createElement('canvas');
  canvas.width = image.width;
  canvas.height = image.height;
  canvas.getContext('2d').drawImage(image, 0, 0); // Get raw image data

  var data = canvas.toDataURL(type || 'png').replace(/^data:image\/(png|jpg);base64,/, ''); // Dump data into stream and return

  var result = through();
  process.nextTick(function () {
    return result.end(new Buffer(data, 'base64'));
  });
  return result;
}
//# sourceMappingURL=browser-compress-image.js.map