function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { VertexShader, FragmentShader } from '../../webgl/shader';
import Program from '../../webgl/program';
import assert from '../../utils/assert';

var ShaderCache =
/*#__PURE__*/
function () {
  /**
   * A cache of compiled shaders, keyed by shader source strings.
   * Compilation of long shaders can be time consuming.
   * By using this class, the application can ensure that each shader
   * is only compiled once.
   */
  function ShaderCache() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        gl = _ref.gl,
        _ref$_cachePrograms = _ref._cachePrograms,
        _cachePrograms = _ref$_cachePrograms === void 0 ? false : _ref$_cachePrograms;

    _classCallCheck(this, ShaderCache);

    assert(gl);
    this.gl = gl;
    this.vertexShaders = {};
    this.fragmentShaders = {};
    this.programs = {};
    this._cachePrograms = _cachePrograms;
  }
  /**
   * Deletes shader references
   * @return {ShaderCache} - returns this for chaining
   */


  _createClass(ShaderCache, [{
    key: "delete",
    value: function _delete() {
      // TODO - requires reference counting to avoid deleting shaders in use
      return this;
    }
    /**
     * Returns a compiled `VertexShader` object corresponding to the supplied
     * GLSL source code string, if possible from cache.
     *
     * @param {WebGLRenderingContext} gl - gl context
     * @param {String} source - Source code for shader
     * @return {VertexShader} - a compiled vertex shader
     */

  }, {
    key: "getVertexShader",
    value: function getVertexShader(gl, source) {
      assert(typeof source === 'string');
      assert(this._compareContexts(gl, this.gl));
      var shader = this.vertexShaders[source];

      if (!shader) {
        shader = new VertexShader(gl, source);
        this.vertexShaders[source] = shader;
      }

      return shader;
    }
    /**
     * Returns a compiled `VertexShader` object corresponding to the supplied
     * GLSL source code string, if possible from cache.
     * @param {WebGLRenderingContext} gl - gl context
     * @param {String} source - Source code for shader
     * @return {FragmentShader} - a compiled fragment shader, possibly from chache
     */

  }, {
    key: "getFragmentShader",
    value: function getFragmentShader(gl, source) {
      assert(typeof source === 'string');
      assert(this._compareContexts(gl, this.gl));
      var shader = this.fragmentShaders[source];

      if (!shader) {
        shader = new FragmentShader(gl, source);
        this.fragmentShaders[source] = shader;
      }

      return shader;
    } // Retrive Shaders from cache if exists, otherwise create new instance.

  }, {
    key: "getProgram",
    value: function getProgram(gl, opts) {
      assert(this._compareContexts(gl, this.gl));
      assert(typeof opts.vs === 'string');
      assert(typeof opts.fs === 'string');
      assert(typeof opts.id === 'string');

      var cacheKey = this._getProgramKey(opts);

      var program = this.programs[cacheKey];

      if (program) {
        this._resetProgram(program);

        return program;
      }

      program = this._createNewProgram(gl, opts); // Check if program can be cached
      // Program caching is experimental and expects
      // each Model to have a unique-id (wich is used in key generation)

      if (this._cachePrograms && this._checkProgramProp(program)) {
        program._isCached = true;
        this.programs[cacheKey] = program;
      }

      return program;
    }
  }, {
    key: "_getProgramKey",
    value: function _getProgramKey(opts) {
      return "".concat(opts.id, "-").concat(opts.vs, "-").concat(opts.fs);
    }
  }, {
    key: "_checkProgramProp",
    value: function _checkProgramProp(program) {
      // Check for transform feedback props (varyings, etc), we can't key such programs for now
      return !program.varyings;
    }
  }, {
    key: "_createNewProgram",
    value: function _createNewProgram(gl, opts) {
      var vs = opts.vs,
          fs = opts.fs;
      var vertexShader = this.getVertexShader(gl, vs);
      var fragmentShader = this.getFragmentShader(gl, fs);
      return new Program(this.gl, Object.assign({}, opts, {
        vs: vertexShader,
        fs: fragmentShader
      }));
    }
  }, {
    key: "_resetProgram",
    value: function _resetProgram(program, opts) {
      program.reset();
    } // Handle debug contexts

  }, {
    key: "_compareContexts",
    value: function _compareContexts(gl1, gl2) {
      return (gl1.gl || gl1) === (gl2.gl || gl2);
    }
  }]);

  return ShaderCache;
}();

export { ShaderCache as default };
//# sourceMappingURL=shader-cache.js.map