export default "#define SHADER_NAME luma-default-vs\n\n#define LIGHT_MAX 4\n\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec4 color;\nattribute vec2 texCoord1;\n\nuniform mat4 worldMatrix;\nuniform mat4 viewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 worldInverseTransposeMatrix;\n\nuniform bool enableLights;\nuniform vec3 ambientColor;\nuniform vec3 directionalColor;\nuniform vec3 lightingDirection;\n\nuniform vec3 pointLocation[LIGHT_MAX];\nuniform vec3 pointColor[LIGHT_MAX];\nuniform int numberPoints;\n\nvarying vec4 vColor;\nvarying vec2 vTexCoord;\nvarying vec3 lightWeighting;\n\nvoid main(void) {\n  vec4 mvPosition = worldMatrix * vec4(position, 1.0);\n\n  if(!enableLights) {\n    lightWeighting = vec3(1.0, 1.0, 1.0);\n  } else {\n    vec3 plightDirection;\n    vec3 pointWeight = vec3(0.0, 0.0, 0.0);\n    vec4 transformedNormal = worldInverseTransposeMatrix * vec4(normal, 1.0);\n    float directionalLightWeighting = max(dot(transformedNormal.xyz, lightingDirection), 0.0);\n    for (int i = 0; i < LIGHT_MAX; i++) {\n      if (i < numberPoints) {\n        plightDirection =\n          normalize((viewMatrix * vec4(pointLocation[i], 1.0)).xyz - mvPosition.xyz);\n        pointWeight += max(dot(transformedNormal.xyz, plightDirection), 0.0) * pointColor[i];\n      } else {\n        break;\n      }\n    }\n\n    lightWeighting = ambientColor + (directionalColor * directionalLightWeighting) + pointWeight;\n  }\n\n  vColor = color;\n  vTexCoord = texCoord1;\n  gl_Position = projectionMatrix * worldMatrix * vec4(position, 1.0);\n}\n";
//# sourceMappingURL=default-vertex.glsl.js.map