import assert from './assert';
var uidCounters = {};
/**
 * Returns a UID.
 * @param {String} id= - Identifier base name
 * @return {number} uid
 **/

export function uid() {
  var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'id';
  uidCounters[id] = uidCounters[id] || 1;
  var count = uidCounters[id]++;
  return "".concat(id, "-").concat(count);
}
/**
 * Verifies if a given number is power of two or not.
 * @param {object} n - The number to check.
 * @return {Array} Returns true if the given number is power of 2, false otherwise.
 **/

export function isPowerOfTwo(n) {
  assert(typeof n === 'number', 'Input must be a number');
  return n && (n & n - 1) === 0;
} // Returns true if given object is empty, false otherwise.

export function isObjectEmpty(obj) {
  var isEmpty = true;
  /* eslint-disable no-unused-vars  */

  for (var key in obj) {
    isEmpty = false;
    break;
  }
  /* eslint-enable no-unused-vars  */


  return isEmpty;
}
//# sourceMappingURL=utils.js.map