function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Depends on Khronos Debug support module being imported via "luma.gl/debug"
import { global } from '../utils/globals';
import { log } from '../utils'; // Helper to get shared context data

function getContextData(gl) {
  gl.luma = gl.luma || {};
  return gl.luma;
} // Enable or disable debug checks in debug contexts
// Non-debug contexts do not have checks (to ensure performance)
// Turning off debug for debug contexts removes most of the performance penalty


export function enableDebug(debug) {
  log.debug = debug;
} // Returns (a potentially new) context with debug instrumentation turned off or on.
// Note that this actually returns a new context

export function makeDebugContext(gl) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$debug = _ref.debug,
      debug = _ref$debug === void 0 ? true : _ref$debug;

  if (gl === null) {
    // Return to ensure we don't create a context in this case.
    return null;
  }

  return debug ? getDebugContext(gl) : getRealContext(gl);
} // Returns the real context from either of the real/debug contexts

export function getRealContext(gl) {
  if (gl === null) {
    // Return to ensure we don't create a context in this case.
    return null;
  }

  var data = getContextData(gl); // If the context has a realContext member, it is a debug context so return the realContext

  return data.realContext ? data.realContext : gl;
} // Returns the debug context from either of the real/debug contexts

export function getDebugContext(gl) {
  if (gl === null) {
    // Return to ensure we don't create a context in this case.
    return null;
  }

  if (!global.WebGLDebug) {
    log.warn('WebGL debug mode activation failed. import "luma.gl/debug" to enable.')();
    return gl;
  }

  var data = getContextData(gl); // If this *is* a debug context, return itself

  if (data.realContext) {
    return gl;
  } // If this already has a debug context, return it.


  if (data.debugContext) {
    return data.debugContext;
  } // Create a new debug context


  var WebGLDebugContext = function WebGLDebugContext() {
    _classCallCheck(this, WebGLDebugContext);
  };

  var debugContext = global.WebGLDebug.makeDebugContext(gl, onGLError, onValidateGLFunc);
  Object.assign(WebGLDebugContext.prototype, debugContext); // Store the debug context

  data.debugContext = debugContext;
  debugContext.debug = true;
  debugContext.gl = gl;
  log.info('debug context actived.'); // Return it

  return debugContext;
} // DEBUG TRACING

function getFunctionString(functionName, functionArgs) {
  var args = global.WebGLDebug.glFunctionArgsToString(functionName, functionArgs);
  args = "".concat(args.slice(0, 100)).concat(args.length > 100 ? '...' : '');
  return "gl.".concat(functionName, "(").concat(args, ")");
}

function onGLError(err, functionName, args) {
  var errorMessage = global.WebGLDebug.glEnumToString(err);
  var functionArgs = global.WebGLDebug.glFunctionArgsToString(functionName, args);
  var message = "".concat(errorMessage, " in gl.").concat(functionName, "(").concat(functionArgs, ")");

  if (log.throw) {
    throw new Error(message);
  } else {
    log.error(message)();
    debugger; // eslint-disable-line
  }
} // Don't generate function string until it is needed


function onValidateGLFunc(functionName, functionArgs) {
  var functionString;

  if (log.priority >= 4) {
    functionString = getFunctionString(functionName, functionArgs);
    log.info(4, functionString)();
  }

  if (log.break) {
    functionString = functionString || getFunctionString(functionName, functionArgs);
    var isBreakpoint = log.break && log.break.every(function (breakOn) {
      return functionString.indexOf(breakOn) !== -1;
    });

    if (isBreakpoint) {
      debugger; // eslint-disable-line
    }
  }

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = functionArgs[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var arg = _step.value;

      if (arg === undefined) {
        functionString = functionString || getFunctionString(functionName, functionArgs);

        if (log.throw) {
          throw new Error("Undefined argument: ".concat(functionString));
        } else {
          log.error("Undefined argument: ".concat(functionString));
          debugger; // eslint-disable-line
        }
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }
}
//# sourceMappingURL=debug-context.js.map