function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/* eslint-disable complexity */
import assert from '../utils/assert';
import { Buffer } from '../webgl';
import GL from '../constants';

var Attribute =
/*#__PURE__*/
function () {
  function Attribute(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Attribute);

    var _opts$id = opts.id,
        id = _opts$id === void 0 ? 'unnamed-attribute' : _opts$id,
        type = opts.type,
        _opts$isIndexed = opts.isIndexed,
        isIndexed = _opts$isIndexed === void 0 ? false : _opts$isIndexed; // Options that cannot be changed later

    this.gl = gl;
    this.id = id;
    this.isIndexed = isIndexed;
    this.target = isIndexed ? GL.ELEMENT_ARRAY_BUFFER : GL.ARRAY_BUFFER;
    this.type = type; // Initialize the attribute descriptor, with WebGL and metadata fields

    this.value = null;
    this.externalBuffer = null;
    this.buffer = null;
    this.userData = {}; // Reserved for application

    this.update(opts); // Sanity - no app fields on our attributes. Use userData instead.

    Object.seal(this); // Check all fields and generate helpful error messages

    this._validateAttributeDefinition();
  }

  _createClass(Attribute, [{
    key: "delete",
    value: function _delete() {
      if (this.buffer) {
        this.buffer.delete();
        this.buffer = null;
      }
    }
  }, {
    key: "update",
    value: function update(_ref) {
      var value = _ref.value,
          buffer = _ref.buffer,
          _ref$size = _ref.size,
          size = _ref$size === void 0 ? this.size : _ref$size,
          _ref$offset = _ref.offset,
          offset = _ref$offset === void 0 ? this.offset || 0 : _ref$offset,
          _ref$stride = _ref.stride,
          stride = _ref$stride === void 0 ? this.stride || 0 : _ref$stride,
          _ref$normalized = _ref.normalized,
          normalized = _ref$normalized === void 0 ? this.normalized || false : _ref$normalized,
          _ref$integer = _ref.integer,
          integer = _ref$integer === void 0 ? this.integer || false : _ref$integer,
          _ref$instanced = _ref.instanced,
          instanced = _ref$instanced === void 0 ? this.instanced || 0 : _ref$instanced,
          _ref$isGeneric = _ref.isGeneric,
          isGeneric = _ref$isGeneric === void 0 ? this.isGeneric || false : _ref$isGeneric,
          isInstanced = _ref.isInstanced;
      this.size = size;
      this.offset = offset;
      this.stride = stride;
      this.normalized = normalized;
      this.integer = integer;
      this.isGeneric = isGeneric;

      if (isInstanced !== undefined) {
        this.instanced = isInstanced ? 1 : 0;
      } else {
        this.instanced = instanced;
      }

      if (buffer) {
        this.externalBuffer = buffer;
        this.type = buffer.type;
      } else if (value) {
        this.externalBuffer = null;
        this.value = value;

        if (!isGeneric) {
          // Create buffer if needed
          this.buffer = this.buffer || new Buffer(this.gl, {
            target: this.target,
            type: this.type
          });
          this.buffer.setData({
            data: value
          });
          this.type = this.buffer.type;
        }
      }
    }
  }, {
    key: "getBuffer",
    value: function getBuffer() {
      if (this.isGeneric) {
        return null;
      }

      return this.externalBuffer || this.buffer;
    }
  }, {
    key: "_validateAttributeDefinition",
    value: function _validateAttributeDefinition() {
      assert(this.size >= 1 && this.size <= 4, "Attribute definition for ".concat(this.id, " invalid size"));
    }
  }]);

  return Attribute;
}();

export { Attribute as default };
//# sourceMappingURL=attribute.js.map