/* eslint-disable */
// TODO - generic draw call
// One of the good things about GL is that there are so many ways to draw things
import GL from '../constants';
import { assertWebGLContext, assertWebGL2Context, getKeyValue } from '../webgl-utils';
import assert from '../utils/assert'; // A good thing about webGL is that there are so many ways to draw things,
// e.g. depending on whether data is indexed and/or isInstanced.
// This function unifies those into a single call with simple parameters
// that have sane defaults.

export function draw(gl, _ref) {
  var _ref$drawMode = _ref.drawMode,
      drawMode = _ref$drawMode === void 0 ? GL.TRIANGLES : _ref$drawMode,
      vertexCount = _ref.vertexCount,
      _ref$offset = _ref.offset,
      offset = _ref$offset === void 0 ? 0 : _ref$offset,
      _ref$isIndexed = _ref.isIndexed,
      isIndexed = _ref$isIndexed === void 0 ? false : _ref$isIndexed,
      _ref$indexType = _ref.indexType,
      indexType = _ref$indexType === void 0 ? GL.UNSIGNED_SHORT : _ref$indexType,
      _ref$isInstanced = _ref.isInstanced,
      isInstanced = _ref$isInstanced === void 0 ? false : _ref$isInstanced,
      _ref$instanceCount = _ref.instanceCount,
      instanceCount = _ref$instanceCount === void 0 ? 0 : _ref$instanceCount;
  assertWebGLContext(gl);
  var extension = gl.getExtension('ANGLE_instanced_arrays'); // TODO - Use polyfilled WebGL2RenderingContext instead of ANGLE extension

  if (isInstanced) {
    var webgl2 = isWebGL2(gl);

    var _extension = gl.getExtension('ANGLE_instanced_arrays');

    var context = webgl2 ? gl : _extension;
    var suffix = webgl2 ? '' : 'ANGLE';
    var drawElements = 'drawElementsInstanced' + suffix;
    var drawArrays = 'drawArraysInstanced' + suffix;

    if (isIndexed) {
      context[drawElements](drawMode, vertexCount, indexType, offset, instanceCount);
    } else {
      context[drawArrays](drawMode, offset, vertexCount, instanceCount);
    }
  } else if (isIndexed) {
    gl.drawElements(drawMode, vertexCount, indexType, offset);
  } else {
    gl.drawArrays(drawMode, offset, vertexCount);
  }
}
//# sourceMappingURL=draw.js.map