function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/* eslint-disable */
// TODO - generic draw call
// One of the good things about GL is that there are so many ways to draw things
import GL from '../constants';
import { withParameters } from '../webgl-context';
import { assertWebGLContext, assertWebGL2Context, getKey } from '../webgl-utils';
import assert from '../utils/assert';
/**
 * Read pixels from a target
 *
 * Will read from the currently bound framebuffer, or the currently bound
 *  drawing buffer - if context has been created with
 *  preserveDrawingBuffers
 *
 * @param {WebGLRenderingContext} gl
 * @param {Object} opts
 * @param {Number} opts.x - leftmost coord to be read
 * @param {Number} opts.y - bottommost (or topmost if sourceHeight supplied)
 * @param {Number} opts.width=1 - width of area to be read
 * @param {Number} opts.height=1 - height of area to be read
 * @param {Number} opts.sourceHeight= - target height, implies top left coords
 * @param {Number} opts.dataOffset=0 - WebGL2 only - offset into data array
 * @param {Number} opts.format=GL.RBGA - Can be set to GL.RGB or GL.ALPHA
 *
 * @return {ArrayView} - types array, either passed in or autoallocated
 */

export function readPixels(gl, _ref) {
  var x = _ref.x,
      y = _ref.y,
      _ref$width = _ref.width,
      width = _ref$width === void 0 ? 1 : _ref$width,
      _ref$height = _ref.height,
      height = _ref$height === void 0 ? 1 : _ref$height,
      data = _ref.data,
      _ref$dataOffset = _ref.dataOffset,
      dataOffset = _ref$dataOffset === void 0 ? 0 : _ref$dataOffset,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? GL.UNSIGNED_BYTE : _ref$type,
      sourceHeight = _ref.sourceHeight,
      _ref$format = _ref.format,
      format = _ref$format === void 0 ? GL.RGBA : _ref$format;
  // Read color in the central pixel, to be mapped with picking colors
  data = data || new Uint8Array(4 * width * height); // If source height is specified, a top left coordinate system is used

  y = sourceHeight ? sourceHeight - y : y;

  if (dataOffset) {
    assertWebGL2Context(gl);
    gl.readPixels(x, y, width, height, format, type, data, dataOffset);
  } else {
    gl.readPixels(x, y, width, height, format, type, data);
  }

  return data;
}
/**
 * Read pixels directly into webgl buffer
 * NOTE: WebGL2 only
 *
 * @param {WebGLRenderingContext} gl
 * @param {Object} options
 * @return {WebGLBuffer} the passed in buffer
 */

export function readPixelsToBuffer(gl, _ref2) {
  var x = _ref2.x,
      y = _ref2.y,
      _ref2$width = _ref2.width,
      width = _ref2$width === void 0 ? 1 : _ref2$width,
      _ref2$height = _ref2.height,
      height = _ref2$height === void 0 ? 1 : _ref2$height,
      buffer = _ref2.buffer,
      _ref2$dataOffset = _ref2.dataOffset,
      dataOffset = _ref2$dataOffset === void 0 ? 0 : _ref2$dataOffset,
      _ref2$type = _ref2.type,
      type = _ref2$type === void 0 ? GL.UNSIGNED_BYTE : _ref2$type,
      sourceHeight = _ref2.sourceHeight,
      _ref2$format = _ref2.format,
      format = _ref2$format === void 0 ? GL.RGBA : _ref2$format;
  assertWebGL2Context(gl); // If source height is specified, a top left coordinate system is used

  y = sourceHeight ? sourceHeight - y : y;
  gl.bindBuffer(GL.PIXEL_PACK_BUFFER, buffer.handle);
  gl.readPixels(x, y, width, height, format, type, dataOffset);
  gl.bindBuffer(GL.PIXEL_PACK_BUFFER, null);
  return buffer;
}
/*
* @param {} opt.filter
 */

export function blitFramebuffer(gl, _ref3) {
  var _ref3$source = _slicedToArray(_ref3.source, 4),
      sourceX = _ref3$source[0],
      sourceY = _ref3$source[1],
      sourceWidth = _ref3$source[2],
      sourceHeight = _ref3$source[3],
      _ref3$dest = _slicedToArray(_ref3.dest, 4),
      destX = _ref3$dest[0],
      destY = _ref3$dest[1],
      destWidth = _ref3$dest[2],
      destHeight = _ref3$dest[3],
      _ref3$mask = _ref3.mask,
      mask = _ref3$mask === void 0 ? GL.COLOR_BUFFER_BIT | GL.DEPTH_BUFFER_BIT | GL.STENCIL_BUFFER_BIT : _ref3$mask,
      _ref3$filter = _ref3.filter,
      filter = _ref3$filter === void 0 ? GL.LINEAR : _ref3$filter;
}
//# sourceMappingURL=functions.js.map