function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

// WebGL2 Query (also handles disjoint timer extensions)
import Resource from './resource';
import { FEATURES, hasFeatures } from '../webgl-context/context-features';
import { polyfillContext } from '../webgl-context';
import { isWebGL2 } from '../webgl-utils';
import queryManager from '../webgl-utils/query-manager';

var noop = function noop(x) {
  return x;
};

var ERR_GPU_DISJOINT = 'Disjoint GPU operation invalidated timer queries';
var ERR_TIMER_QUERY_NOT_SUPPORTED = 'Timer queries require "EXT_disjoint_timer_query" extension';
var GL_QUERY_COUNTER_BITS_EXT = 0x8864; // # bits in query result for the given target.

var GL_QUERY_RESULT = 0x8866; // Returns a GLuint containing the query result.

var GL_QUERY_RESULT_AVAILABLE = 0x8867; // whether query result is available.

var GL_TIME_ELAPSED_EXT = 0x88BF; // Elapsed time (in nanoseconds).

var GL_TIMESTAMP_EXT = 0x8E28; // The current time.

var GL_GPU_DISJOINT_EXT = 0x8FBB; // Whether GPU performed any disjoint operation.

var GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8C88; // #primitives written to feedback buffers

var GL_ANY_SAMPLES_PASSED = 0x8C2F; // Occlusion query (if drawing passed depth test)

var GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8D6A; // Occlusion query less accurate/faster version

var Query =
/*#__PURE__*/
function (_Resource) {
  _inherits(Query, _Resource);

  _createClass(Query, null, [{
    key: "isSupported",
    // Returns true if Query is supported by the WebGL implementation
    // Can also check whether timestamp queries are available.
    value: function isSupported(gl) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref$queries = _ref.queries,
          queries = _ref$queries === void 0 ? false : _ref$queries,
          _ref$timers = _ref.timers,
          timers = _ref$timers === void 0 ? false : _ref$timers,
          _ref$timestamps = _ref.timestamps,
          timestamps = _ref$timestamps === void 0 ? false : _ref$timestamps;

      var webgl2 = isWebGL2(gl);
      var hasTimerQueries = hasFeatures(gl, FEATURES.TIMER_QUERY);
      var supported = webgl2 || hasTimerQueries;

      if (queries) {
        supported = supported && webgl2;
      }

      if (timers) {
        supported = supported && hasTimerQueries;
      }

      if (timestamps) {
        polyfillContext(gl);
        var queryCounterBits = gl.getQuery(GL_TIMESTAMP_EXT, GL_QUERY_COUNTER_BITS_EXT);
        supported = supported && queryCounterBits > 0;
      }

      return supported;
    } // Create a query class

  }]);

  function Query(gl) {
    var _this;

    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Query);

    _this = _possibleConstructorReturn(this, (Query.__proto__ || Object.getPrototypeOf(Query)).call(this, gl, opts));
    var _opts$onComplete = opts.onComplete,
        onComplete = _opts$onComplete === void 0 ? noop : _opts$onComplete,
        _opts$onError = opts.onError,
        onError = _opts$onError === void 0 ? noop : _opts$onError;
    _this.target = null;
    _this.onComplete = onComplete;
    _this.onError = onError; // query manager needs a promise field

    _this.promise = null;
    Object.seal(_assertThisInitialized(_this));
    return _this;
  } // Shortcut for timer query (dependent on extension in both WebGL1 and 2)
  // Measures GPU time delta between this call and a matching `end` call in the
  // GPU instruction stream.


  _createClass(Query, [{
    key: "beginTimeElapsedQuery",
    value: function beginTimeElapsedQuery() {
      return this.begin(GL_TIME_ELAPSED_EXT);
    } // Shortcut for occlusion queries

  }, {
    key: "beginOcclusionQuery",
    value: function beginOcclusionQuery() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref2$conservative = _ref2.conservative,
          conservative = _ref2$conservative === void 0 ? false : _ref2$conservative;

      return this.begin(conservative ? GL_ANY_SAMPLES_PASSED_CONSERVATIVE : GL_ANY_SAMPLES_PASSED);
    } // Shortcut for transformFeedbackQuery

  }, {
    key: "beginTransformFeedbackQuery",
    value: function beginTransformFeedbackQuery() {
      return this.begin(GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN);
    } // Generates a GPU time stamp when the GPU instruction stream reaches this instruction.
    // To measure time deltas, two timestamp queries are needed.
    // Note: timestamp() queries may not be available even when the timer query extension is.

  }, {
    key: "getTimestamp",
    value: function getTimestamp() {
      queryManager.beginQuery(this, this.onComplete, this.onError);

      try {
        this.gl.queryCounter(this.handle, GL_TIMESTAMP_EXT);
      } catch (error) {
        queryManager.rejectQuery(this, ERR_TIMER_QUERY_NOT_SUPPORTED);
      }

      return this;
    } // Due to OpenGL API limitations, after calling `begin()` on one Query
    // instance, `end()` must be called on that same instance before
    // calling `begin()` on another query. While there can be multiple
    // outstanding queries representing disjoint `begin()`/`end()` intervals.
    // It is not possible to interleave or overlap `begin` and `end` calls.

  }, {
    key: "begin",
    value: function begin(target) {
      // - Triggering a new query when a Query is already tracking an
      //   unresolved query causes that query to be cancelled.
      queryManager.beginQuery(this, this.onComplete, this.onError);
      this.target = target;

      try {
        this.gl.beginQuery(this.target, this.handle);
      } catch (error) {
        queryManager.rejectQuery(this, 'Query not supported');
      }

      return this;
    } // ends the current query

  }, {
    key: "end",
    value: function end() {
      // Note: calling end does not affect the pending promise
      if (this.target) {
        this.ext.endQuery(this.target);
        this.target = null;
      }

      return this;
    } // Cancels a pending query

  }, {
    key: "cancel",
    value: function cancel() {
      this.end();
      queryManager.cancelQuery(this);
      return this;
    } // Returns true if the query result is available

  }, {
    key: "isResultAvailable",
    value: function isResultAvailable() {
      return this.gl.getQueryParameter(this.handle, GL_QUERY_RESULT_AVAILABLE);
    } // Returns the query result, converted to milliseconds to match JavaScript conventions.
    // TODO - what about non-timer queries

  }, {
    key: "getResult",
    value: function getResult() {
      var result = this.gl.getQueryParameter(this.handle, GL_QUERY_RESULT);
      return Number.isFinite(result) ? result / 1e6 : 0;
    }
  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return Query.isSupported(this.gl) ? this.gl.createQuery() : null;
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      queryManager.deleteQuery(this);
      this.gl.deleteQuery(this.handle);
    }
  }], [{
    key: "poll",
    value: function poll(gl) {
      queryManager.poll(gl);
    }
  }]);

  return Query;
}(Resource); // NOTE: This call lets the queryManager know how to detect disjoint GPU state
// It will check dsjoint state on polls and before adding a new query
// and reject any outstanding TimerQueries with our supplied error message.


export { Query as default };
queryManager.setInvalidator({
  queryType: Query,
  errorMessage: ERR_GPU_DISJOINT,
  // Note: Querying the disjoint state resets it
  checkInvalid: function checkInvalid(gl) {
    return gl.getParameter(GL_GPU_DISJOINT_EXT);
  }
});
//# sourceMappingURL=query.js.map