function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

// WebGL2 VertexArray Objects Helper
import Resource from './resource';
import { isWebGL2, getKey } from '../webgl-utils';
import { log, assert } from '../utils';
/* eslint-disable camelcase */

var OES_vertex_array_object = 'OES_vertex_array_object';
var GL_ELEMENT_ARRAY_BUFFER = 0x8893; // const GL_CURRENT_VERTEX_ATTRIB = 0x8626;

var GL_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622;
var GL_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623;
var GL_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624;
var GL_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625;
var GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 0x886A;
var GL_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645;
var GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F;
var GL_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD;
var GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE;
var PARAMETERS = [GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_POINTER, GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_INTEGER, GL_VERTEX_ATTRIB_ARRAY_DIVISOR];
var ERR_ELEMENTS = 'elements must be GL.ELEMENT_ARRAY_BUFFER';

var VertexArray =
/*#__PURE__*/
function (_Resource) {
  _inherits(VertexArray, _Resource);

  _createClass(VertexArray, [{
    key: "MAX_ATTRIBUTES",
    get: function get() {
      return this.gl.getParameter(this.gl.MAX_VERTEX_ATTRIBS);
    } // Create a VertexArray

  }], [{
    key: "isSupported",
    value: function isSupported(gl) {
      return isWebGL2(gl) || gl.getExtension(OES_vertex_array_object);
    }
  }, {
    key: "getDefaultArray",
    value: function getDefaultArray(gl) {
      gl.luma = gl.luma || {};

      if (!gl.luma.defaultVertexArray) {
        gl.luma.defaultVertexArray = new VertexArray(gl, {
          handle: null
        });
      }

      return gl.luma.defaultVertexArray;
    }
  }, {
    key: "getMaxAttributes",
    value: function getMaxAttributes(gl) {
      return gl.getParameter(gl.MAX_VERTEX_ATTRIBS);
    }
  }]);

  function VertexArray(gl) {
    var _this;

    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, VertexArray);

    _this = _possibleConstructorReturn(this, (VertexArray.__proto__ || Object.getPrototypeOf(VertexArray)).call(this, gl, opts));
    _this.elements = null;
    _this.buffers = {}; // new Array(this.MAX_VERTEX_ATTRIBS).fill(null);

    _this.locations = {};
    _this.names = {};
    _this.drawParameters = {};
    _this._bound = false;
    _this._filledLocations = {};
    Object.seal(_assertThisInitialized(_this));

    _this.initialize(opts);

    return _this;
  }

  _createClass(VertexArray, [{
    key: "initialize",
    value: function initialize() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$buffers = _ref.buffers,
          buffers = _ref$buffers === void 0 ? {} : _ref$buffers,
          _ref$elements = _ref.elements,
          elements = _ref$elements === void 0 ? null : _ref$elements,
          _ref$locations = _ref.locations,
          locations = _ref$locations === void 0 ? {} : _ref$locations;

      this.setLocations(locations);
      this.setBuffers(buffers, {
        clear: true
      });
      this.setElements(elements);
    }
  }, {
    key: "setBuffer",
    // Set a location in vertex attributes array to a buffer
    value: function setBuffer() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          location = _ref2.location,
          buffer = _ref2.buffer,
          target = _ref2.target,
          layout = _ref2.layout;

      var gl = this.gl; // Copy main data characteristics from buffer

      target = target !== undefined ? target : buffer.target;
      layout = layout !== undefined ? layout : buffer.layout;
      assert(target, 'setBuffer needs target');
      assert(layout, 'setBuffer called on uninitialized buffer');
      this._filledLocations[location] = true;
      this.bind(function () {
        // a non-zero named buffer object must be bound to the GL_ARRAY_BUFFER target
        buffer.bind({
          target: gl.ARRAY_BUFFER
        });
        var _layout = layout,
            size = _layout.size,
            type = _layout.type,
            normalized = _layout.normalized,
            stride = _layout.stride,
            offset = _layout.offset; // Attach _bound ARRAY_BUFFER with specified buffer format to location

        if (!layout.integer) {
          gl.vertexAttribPointer(location, size, type, normalized, stride, offset);
        } else {
          // specifies *integer* data formats and locations of vertex attributes
          assert(isWebGL2(gl));
          gl.vertexAttribIPointer(location, size, type, stride, offset);
        }
      });
    } // Set (bind) an array or map of vertex array buffers, either in numbered or
    // named locations. (named locations requires `locations` to have been provided).
    // For names that are not present in `location`, the supplied buffers will be ignored.
    // if a single buffer of type GL.ELEMENT_ARRAY_BUFFER is present, it will be set as elements
    // @param {Object} buffers - An object map with attribute names being keys
    //   and values are expected to be instances of Buffer.

  }, {
    key: "setBuffers",
    value: function setBuffers(buffers) {
      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref3$clear = _ref3.clear,
          clear = _ref3$clear === void 0 ? true : _ref3$clear;

      if (clear) {
        this.clearBindings();
      }

      var _getLocations2 = this._getLocations(buffers),
          locations = _getLocations2.locations,
          elements = _getLocations2.elements;

      this.ext.bindVertexArray(this.handle); // Process locations in order

      for (var location in locations) {
        var bufferData = locations[location];

        if (bufferData) {
          var _getBufferAndLayout2 = this._getBufferAndLayout(bufferData),
              buffer = _getBufferAndLayout2.buffer,
              layout = _getBufferAndLayout2.layout;

          this.setBuffer({
            location: location,
            buffer: buffer,
            layout: layout
          });
          this.setDivisor(location, layout.instanced ? 1 : 0);
          this.enable(location);
        } else {
          // DISABLE MISSING ATTRIBUTE
          this.disable(location);
        }
      }

      this.buffers = buffers;
      this.ext.bindVertexArray(null);

      if (elements) {
        this.setElements(elements);
      }
    } // Register an optional buffer name to location mapping

  }, {
    key: "setLocations",
    value: function setLocations(locations) {
      this.locations = locations;
      this.names = {};
    } // Set (bind) an elements buffer, for indexed rendering. Must be GL.ELEMENT_ARRAY_BUFFER

  }, {
    key: "setElements",
    value: function setElements(elements) {
      assert(!elements || elements.target === GL_ELEMENT_ARRAY_BUFFER, ERR_ELEMENTS);
      this.ext.bindVertexArray(this.handle);
      this.gl.bindBuffer(GL_ELEMENT_ARRAY_BUFFER, elements && elements.handle);
      this.ext.bindVertexArray(null);
      this.elements = elements;
      return this;
    }
  }, {
    key: "clearBindings",
    value: function clearBindings() {
      var _this2 = this;

      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref4$disableZero = _ref4.disableZero,
          disableZero = _ref4$disableZero === void 0 ? false : _ref4$disableZero;

      this.bind(function () {
        for (var location in _this2._filledLocations) {
          if (_this2._filledLocations[location] && (location > 0 || disableZero)) {
            _this2.gl.disableVertexAttribArray(location);
          }
        }

        _this2._filledLocations = {};
      });
    } // Enable an attribute

  }, {
    key: "enable",
    value: function enable(location) {
      var _this3 = this;

      this.bind(function () {
        _this3.gl.enableVertexAttribArray(location);
      });
    } // Disable an attribute
    // Perf penalty when disabling attribute 0:
    // https://stackoverflow.com/questions/20305231/webgl-warning-attribute-0-is-disabled-
    // this-has-significant-performance-penalt

  }, {
    key: "disable",
    value: function disable(location) {
      var _this4 = this;

      var disableZero = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      if (location > 0 || disableZero) {
        this.bind(function () {
          _this4.gl.disableVertexAttribArray(location);
        });
      }
    } // Set the frequency divisor used for instanced rendering.

  }, {
    key: "setDivisor",
    value: function setDivisor(location, divisor) {
      var _this5 = this;

      this.bind(function () {
        _this5.ext.vertexAttribDivisor(location, divisor);
      });
    } // Specify values for generic vertex attributes

  }, {
    key: "setGeneric",
    value: function setGeneric(_ref5) {
      var location = _ref5.location,
          array = _ref5.array;
      this._filledLocations[location] = true;

      switch (array.constructor) {
        case Float32Array:
          this._setGenericFloatArray(location, array);

          break;

        case Int32Array:
          this._setGenericIntArray(location, array);

          break;

        case Uint32Array:
          this._setGenericUintArray(location, array);

          break;

        default:
          this.setGenericValues.apply(this, [location].concat(_toConsumableArray(array)));
      }
    } // Specify values for generic vertex attributes

  }, {
    key: "setGenericValues",
    value: function setGenericValues(location, v0, v1, v2, v3) {
      var gl = this.gl;

      switch (arguments.length - 1) {
        case 1:
          gl.vertexAttrib1f(location, v0);
          break;

        case 2:
          gl.vertexAttrib2f(location, v0, v1);
          break;

        case 3:
          gl.vertexAttrib3f(location, v0, v1, v2);
          break;

        case 4:
          gl.vertexAttrib4f(location, v0, v1, v2, v3);
          break;

        default:
          assert(false);
      } // assert(gl instanceof WebGL2RenderingContext, 'WebGL2 required');
      // Looks like these will check how many arguments were supplied?
      // gl.vertexAttribI4i(location, v0, v1, v2, v3);
      // gl.vertexAttribI4ui(location, v0, v1, v2, v3);

    }
  }, {
    key: "bind",
    value: function bind() {
      var funcOrHandle = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.handle;

      if (typeof funcOrHandle !== 'function') {
        this.bindVertexArray(funcOrHandle);
        return this;
      }

      var value;

      if (!this._bound) {
        this.ext.bindVertexArray(this.handle);
        this._bound = true;
        value = funcOrHandle();
        this.ext.bindVertexArray(null);
        this._bound = false;
      } else {
        value = funcOrHandle();
      }

      return value;
    } // PRIVATE
    // Auto detect draw parameters from the complement of buffers provided

  }, {
    key: "_deduceDrawParameters",
    value: function _deduceDrawParameters() {
      // indexing is autodetected - buffer with target gl.ELEMENT_ARRAY_BUFFER
      // index type is saved for drawElement calls
      var isInstanced = false;
      var isIndexed = false;
      var indexType = null; // Check if we have an elements array buffer

      if (this.elements) {
        isIndexed = true;
        indexType = this.elements.layout.type;
      } // Check if any instanced buffers


      this.buffers.forEach(function (buffer) {
        if (buffer.layout.instanced > 0) {
          isInstanced = true;
        }
      });
      return {
        isInstanced: isInstanced,
        isIndexed: isIndexed,
        indexType: indexType
      };
    } //         this._filledLocations[bufferName] = true;

  }, {
    key: "_getLocations",
    value: function _getLocations(buffers) {
      // Try to extract elements and locations
      var elements = null;
      var locations = {};

      for (var bufferName in buffers) {
        var buffer = buffers[bufferName]; // Check if this is an elements array

        if (buffer && buffer.target === GL_ELEMENT_ARRAY_BUFFER) {
          assert(!elements, 'Duplicate GL.ELEMENT_ARRAY_BUFFER'); // assert(location === undefined, 'GL.ELEMENT_ARRAY_BUFFER assigned to location');

          elements = buffer;
        }

        var location = Number(bufferName); // if key is a number, interpret as the location
        // if key is not a location number, assume it is a named buffer, look it up in supplied map

        if (!Number.isFinite(location)) {
          location = this.locations[bufferName];
        }

        assert(Number.isFinite(location));
        assert(!locations[location], "Duplicate attribute for binding point ".concat(location));
        locations[location] = buffer;
      }

      return {
        locations: locations,
        elements: elements
      };
    }
  }, {
    key: "_sortBuffersByLocation",
    value: function _sortBuffersByLocation(buffers) {
      // Try to extract elements and locations
      var elements = null;
      var locations = new Array(this._attributeCount).fill(null);

      for (var bufferName in buffers) {
        var buffer = buffers[bufferName]; // Check if this is an elements arrau

        if (buffer.target === GL_ELEMENT_ARRAY_BUFFER) {
          assert(!elements, 'Duplicate GL.ELEMENT_ARRAY_BUFFER'); // assert(location === undefined, 'GL.ELEMENT_ARRAY_BUFFER assigned to location');

          elements = buffer;
        } else if (!this._warn[bufferName]) {
          log.warn(2, "".concat(this._print(bufferName), " not used"))();
          this._warn[bufferName] = true;
        }

        var location = Number(bufferName); // if key is a number, interpret as the location
        // if key is not a location number, assume it is a named buffer, look it up in supplied map

        if (!Number.isFinite(location)) {
          location = this.locations[bufferName];
        }

        locations[location] = bufferName;
        assert(locations[location] === null, "Duplicate attribute for binding point ".concat(location));
        locations[location] = location;
      }

      return {
        locations: locations,
        elements: elements
      };
    }
  }, {
    key: "_getBufferAndLayout",
    value: function _getBufferAndLayout(bufferData) {
      // Check if buffer was supplied
      var buffer;
      var layout;

      if (bufferData.handle) {
        buffer = bufferData;
        layout = bufferData.layout;
      } else {
        buffer = bufferData.buffer;
        layout = Object.assign({}, buffer.layout, bufferData.layout || {}, bufferData);
      }

      return {
        buffer: buffer,
        layout: layout
      };
    } // TODO - this doesn't minimize well, choose one of the two API styles?

  }, {
    key: "_setGenericFloatArray",
    value: function _setGenericFloatArray(location, array) {
      var gl = this.gl;

      switch (array.length) {
        case 1:
          gl.vertexAttrib1fv(location, array);
          break;

        case 2:
          gl.vertexAttrib2fv(location, array);
          break;

        case 3:
          gl.vertexAttrib3fv(location, array);
          break;

        case 4:
          gl.vertexAttrib4fv(location, array);
          break;

        default:
          assert(false);
      }
    }
  }, {
    key: "_setGenericIntArray",
    value: function _setGenericIntArray(location, array) {
      var gl = this.gl;
      assert(isWebGL2(gl));

      switch (array.length) {
        case 1:
          gl.vertexAttribI1iv(location, array);
          break;

        case 2:
          gl.vertexAttribI2iv(location, array);
          break;

        case 3:
          gl.vertexAttribI3iv(location, array);
          break;

        case 4:
          gl.vertexAttribI4iv(location, array);
          break;

        default:
          assert(false);
      }
    }
  }, {
    key: "_setGenericUintArray",
    value: function _setGenericUintArray(location, array) {
      var gl = this.gl;
      assert(isWebGL2(gl));

      switch (array.length) {
        case 1:
          gl.vertexAttribI1uiv(location, array);
          break;

        case 2:
          gl.vertexAttribI2uiv(location, array);
          break;

        case 3:
          gl.vertexAttribI3uiv(location, array);
          break;

        case 4:
          gl.vertexAttribI4uiv(location, array);
          break;

        default:
          assert(false);
      }
    } // RESOURCE IMPLEMENTATION

  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return this.ext.createVertexArray();
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle(handle) {
      this.ext.deleteVertexArray(handle);
      return [this.elements]; // return [this.elements, ...this.buffers];
    } // Generic getter for information about a vertex attribute at a given position
    // @param {GLuint} location - index of the vertex attribute.
    // @param {GLenum} pname - specifies the information to query.
    // @returns {*} - requested vertex attribute information (specified by pname)

  }, {
    key: "_getParameter",
    value: function _getParameter(pname, _ref6) {
      var location = _ref6.location;
      assert(Number.isFinite(location));
      this.ext.bindVertexArray(this.handle); // Let the polyfill intercept the query

      var result;

      switch (pname) {
        case GL_VERTEX_ATTRIB_ARRAY_POINTER:
          result = this.gl.getVertexAttribOffset(location, pname);
          break;

        default:
          result = this.ext.getVertexAttrib(location, pname);
      }

      this.ext.bindVertexArray(null);
      return result;
    }
  }, {
    key: "_getData",
    value: function _getData() {
      var _this6 = this;

      return new Array(this.MAX_ATTRIBUTES).fill(0).map(function (_, location) {
        var result = {};
        PARAMETERS.forEach(function (parameter) {
          result[getKey(_this6.gl, parameter)] = _this6.getParameter(parameter, {
            location: location
          });
        });
        return result;
      });
    }
  }, {
    key: "_bind",
    value: function _bind(handle) {
      this.ext.bindVertexArray(handle);
    }
  }, {
    key: "filledLocations",
    get: function get() {
      return this._filledLocations;
    }
  }]);

  return VertexArray;
}(Resource);

export { VertexArray as default };
//# sourceMappingURL=vertex-array.js.map