"use strict";

var _setup = _interopRequireDefault(require("luma.gl/test/setup"));

var _luma = require("luma.gl");

var _fs = _interopRequireDefault(require("fs"));

var _path = _interopRequireDefault(require("path"));

var _mkdirp = _interopRequireDefault(require("mkdirp"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TEST_DIR = _path.default.join(__dirname, '..', 'data');

var TEST_FILE = _path.default.join(TEST_DIR, 'test.png');

var IMAGE = {
  width: 2,
  height: 3,
  data: new Uint8Array([255, 0, 0, 255, 0, 255, 255, 255, 0, 0, 255, 255, 255, 255, 0, 255, 0, 255, 0, 255, 255, 0, 255, 255])
}; // Test that we can write and read an image, and that result is identical

(0, _setup.default)('io#write-read-image', async function (t) {
  await (0, _luma.promisify)(_mkdirp.default)(TEST_DIR);

  var file = _fs.default.createWriteStream(TEST_FILE);

  file.on('close', async function () {
    var result = await (0, _luma.loadImage)(TEST_FILE);
    t.same(result, IMAGE);
    t.end();
  });
  (0, _luma.compressImage)(IMAGE).pipe(file);
});
//# sourceMappingURL=write-read-image.js.map