"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _matrix = _interopRequireDefault(require("./matrix4"));

var _vector = _interopRequireDefault(require("./vector3"));

var _euler = _interopRequireDefault(require("./euler"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Pose =
/*#__PURE__*/
function () {
  /**
   * A pose contains both rotation and rotations.
   * Note that every single pose defines its own coordinate system
   * (with the position of the pose in the origin, and zero rotations).
   * These "pose relative" coordinate will be centered on the defining
   * pose's position and with with the defining pose's orientation
   * aligned with axis.
   */
  function Pose(_ref) {
    var _ref$x = _ref.x,
        x = _ref$x === void 0 ? 0 : _ref$x,
        _ref$y = _ref.y,
        y = _ref$y === void 0 ? 0 : _ref$y,
        _ref$z = _ref.z,
        z = _ref$z === void 0 ? 0 : _ref$z,
        _ref$roll = _ref.roll,
        roll = _ref$roll === void 0 ? 0 : _ref$roll,
        _ref$pitch = _ref.pitch,
        pitch = _ref$pitch === void 0 ? 0 : _ref$pitch,
        _ref$yaw = _ref.yaw,
        yaw = _ref$yaw === void 0 ? 0 : _ref$yaw;

    _classCallCheck(this, Pose);

    this.position = new _vector.default(x, y, z);
    this.orientation = new _euler.default(roll, pitch, yaw, _euler.default.RollPitchYaw);
  }
  /* eslint-disable no-multi-spaces, brace-style, no-return-assign */


  _createClass(Pose, [{
    key: "getPosition",

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */
    value: function getPosition() {
      return this.position;
    }
  }, {
    key: "getOrientation",
    value: function getOrientation() {
      return this.orientation;
    }
    /*
     * Returns a 4x4 matrix that transforms a coordinates (in the same
     * coordinate system as this pose) into the "pose-relative" coordinate
     * system defined by this pose.
     * The pose relative coordinates with have origin in the position of this
     * pose, and axis will be aligned with the rotation of this pose.
     */

  }, {
    key: "getTransformationMatrix",
    value: function getTransformationMatrix() {
      // setup precomputations for the sin/cos of the angles
      var sr = Math.sin(this.roll);
      var sp = Math.sin(this.pitch);
      var sw = Math.sin(this.yaw);
      var cr = Math.cos(this.roll);
      var cp = Math.cos(this.pitch);
      var cw = Math.cos(this.yaw);
      var matrix = new _matrix.default().setRowMajor(cw * cp, // 0,0
      -sw * cr + cw * sp * sr, // 0,1
      sw * sr + cw * sp * cr, // 0,2
      this.x, // 0,3
      sw * cp, // 1,0
      cw * cr + sw * sp * sr, // 1,1
      -cw * sr + sw * sp * cr, // 1,2
      this.y, // 1,3
      -sp, // 2,0
      cp * sr, // 2,1
      cp * cr, // 2,2
      this.z, // 2,3
      0, 0, 0, 1);
      return matrix;
    }
    /*
     * Given a second pose that represent the same object in a second coordinate
     * system, this method returns a 4x4 matrix that transforms coordinates in the
     * second coordinate system into the coordinate system of this pose.
     */

  }, {
    key: "getTransformationMatrixFromPose",
    value: function getTransformationMatrixFromPose(pose) {
      return new _matrix.default().multiplyRight(this.getTransformationMatrix()).multiplyRight(pose.getTransformationMatrix().invert());
    }
    /*
     * Given a second pose that represent the same object in a second coordinate
     * system, this method returns a 4x4 matrix that transforms coordinates in the
     * coordinate system of this pose into the coordinate system of the second pose.
     *
     * Note: This method returns the inverse of that returned by
     * this.getTransformationMatrixFromPose(pose)
     */

  }, {
    key: "getTransformationMatrixToPose",
    value: function getTransformationMatrixToPose(pose) {
      return new _matrix.default().multiplyRight(pose.getTransformationMatrix()).multiplyRight(this.getTransformationMatrix().invert());
    }
  }, {
    key: "x",
    get: function get() {
      return this.position.x;
    },
    set: function set(value) {
      return this.position.x = value;
    }
  }, {
    key: "y",
    get: function get() {
      return this.position.y;
    },
    set: function set(value) {
      return this.position.y = value;
    }
  }, {
    key: "z",
    get: function get() {
      return this.position.z;
    },
    set: function set(value) {
      return this.position.z = value;
    }
  }, {
    key: "roll",
    get: function get() {
      return this.orientation.roll;
    },
    set: function set(value) {
      return this.orientation.roll = value;
    }
  }, {
    key: "pitch",
    get: function get() {
      return this.orientation.pitch;
    },
    set: function set(value) {
      return this.orientation.pitch = value;
    }
  }, {
    key: "yaw",
    get: function get() {
      return this.orientation.yaw;
    },
    set: function set(value) {
      return this.orientation.yaw = value;
    }
  }]);

  return Pose;
}();

exports.default = Pose;
//# sourceMappingURL=pose.js.map