"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateQuaternion = validateQuaternion;
exports.default = void 0;

var _mathArray = _interopRequireDefault(require("./lib/math-array"));

var _common = require("./lib/common");

var _fromMat = _interopRequireDefault(require("gl-quat/fromMat3"));

var _identity = _interopRequireDefault(require("gl-quat/identity"));

var _length = _interopRequireDefault(require("gl-quat/length"));

var _squaredLength = _interopRequireDefault(require("gl-quat/squaredLength"));

var _dot = _interopRequireDefault(require("gl-quat/dot"));

var _rotationTo = _interopRequireDefault(require("gl-quat/rotationTo"));

var _add = _interopRequireDefault(require("gl-quat/add"));

var _calculateW = _interopRequireDefault(require("gl-quat/calculateW"));

var _conjugate = _interopRequireDefault(require("gl-quat/conjugate"));

var _invert = _interopRequireDefault(require("gl-quat/invert"));

var _lerp = _interopRequireDefault(require("gl-quat/lerp"));

var _multiply = _interopRequireDefault(require("gl-quat/multiply"));

var _normalize = _interopRequireDefault(require("gl-quat/normalize"));

var _rotateX = _interopRequireDefault(require("gl-quat/rotateX"));

var _rotateY = _interopRequireDefault(require("gl-quat/rotateY"));

var _rotateZ = _interopRequireDefault(require("gl-quat/rotateZ"));

var _scale = _interopRequireDefault(require("gl-quat/scale"));

var _set = _interopRequireDefault(require("gl-quat/set"));

var _setAxisAngle = _interopRequireDefault(require("gl-quat/setAxisAngle"));

var _slerp = _interopRequireDefault(require("gl-quat/slerp"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var IDENTITY_QUATERNION = [0, 0, 0, 1];

function validateQuaternion(q) {
  return q.length === 4 && Number.isFinite(q[0]) && Number.isFinite(q[1]) && Number.isFinite(q[2]) && Number.isFinite(q[3]);
}

var Quaternion =
/*#__PURE__*/
function (_MathArray) {
  _inherits(Quaternion, _MathArray);

  // Creates a new identity quat
  function Quaternion() {
    var _this;

    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var w = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;

    _classCallCheck(this, Quaternion);

    _this = _possibleConstructorReturn(this, (Quaternion.__proto__ || Object.getPrototypeOf(Quaternion)).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y, z, w);
    }

    return _this;
  } // Creates a quaternion from the given 3x3 rotation matrix.
  // NOTE: The resultant quaternion is not normalized, so you should
  // be sure to renormalize the quaternion yourself where necessary.


  _createClass(Quaternion, [{
    key: "fromMatrix3",
    value: function fromMatrix3(m) {
      (0, _fromMat.default)(this, m);
      return this.check();
    } // Creates a new quat initialized with the given values

  }, {
    key: "fromValues",
    value: function fromValues(x, y, z, w) {
      return this.set(x, y, z, w);
    } // Set a quat to the identity quaternion

  }, {
    key: "identity",
    value: function identity() {
      (0, _identity.default)(this);
      return this.check();
    } // Getters/setters

    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: "length",

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */
    // Calculates the length of a quat
    value: function length() {
      return (0, _length.default)(this);
    } // Calculates the squared length of a quat

  }, {
    key: "squaredLength",
    value: function squaredLength(a) {
      return (0, _squaredLength.default)(this);
    } // Calculates the dot product of two quat's
    // @return {Number}

  }, {
    key: "dot",
    value: function dot(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.dot only takes one argument');
      }

      return (0, _dot.default)(this, a);
    } // Gets the rotation axis and angle for a given quaternion.
    // If a quaternion is created with setAxisAngle, this method will
    // return the same values as providied in the original parameter
    // list OR functionally equivalent values.
    // Example: The quaternion formed by axis [0, 0, 1] and angle -90
    // is the same as the quaternion formed by [0, 0, 1] and 270.
    // This method favors the latter.
    // @return {{[x,y,z], Number}}
    // getAxisAngle() {
    //   const axis = [];
    //   const angle = quat_getAxisAngle(axis, this);
    //   return {axis, angle};
    // }
    // MODIFIERS
    // Sets a quaternion to represent the shortest rotation from one vector
    // to another. Both vectors are assumed to be unit length.

  }, {
    key: "rotationTo",
    value: function rotationTo(vectorA, vectorB) {
      (0, _rotationTo.default)(this, vectorA, vectorB);
      return this.check();
    } // Sets the specified quaternion with values corresponding to the given axes.
    // Each axis is a vec3 and is expected to be unit length and perpendicular
    // to all other specified axes.
    // setAxes() {
    //   Number
    // }
    // Performs a spherical linear interpolation with two control points
    // sqlerp() {
    //   Number;
    // }
    // Adds two quat's

  }, {
    key: "add",
    value: function add(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.add only takes one argument');
      }

      (0, _add.default)(this, a);
      return this.check();
    } // Calculates the W component of a quat from the X, Y, and Z components.
    // Any existing W component will be ignored.

  }, {
    key: "calculateW",
    value: function calculateW() {
      (0, _calculateW.default)(this, this);
      return this.check();
    } // Calculates the conjugate of a quat If the quaternion is normalized,
    // this function is faster than quat_inverse and produces the same result.

  }, {
    key: "conjugate",
    value: function conjugate() {
      (0, _conjugate.default)(this, this);
      return this.check();
    } // Calculates the inverse of a quat

  }, {
    key: "invert",
    value: function invert() {
      (0, _invert.default)(this, this);
      return this.check();
    } // Performs a linear interpolation between two quat's

  }, {
    key: "lerp",
    value: function lerp(a, b, t) {
      (0, _lerp.default)(this, a, b, t);
      return this.check();
    } // Multiplies two quat's

  }, {
    key: "multiply",
    value: function multiply(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.multiply only takes one argument');
      }

      (0, _multiply.default)(this, this, b);
      return this.check();
    } // Normalize a quat

  }, {
    key: "normalize",
    value: function normalize() {
      (0, _normalize.default)(this, this);
      return this.check();
    } // Rotates a quaternion by the given angle about the X axis

  }, {
    key: "rotateX",
    value: function rotateX(rad) {
      (0, _rotateX.default)(this, this, rad);
      return this.check();
    } // Rotates a quaternion by the given angle about the Y axis

  }, {
    key: "rotateY",
    value: function rotateY(rad) {
      (0, _rotateY.default)(this, this, rad);
      return this.check();
    } // Rotates a quaternion by the given angle about the Z axis

  }, {
    key: "rotateZ",
    value: function rotateZ(rad) {
      (0, _rotateZ.default)(this, this, rad);
      return this.check();
    } // Scales a quat by a scalar number

  }, {
    key: "scale",
    value: function scale(b) {
      (0, _scale.default)(this, this, b);
      return this.check();
    } // Set the components of a quat to the given values

  }, {
    key: "set",
    value: function set(i, j, k, l) {
      (0, _set.default)(this, i, j, k, l);
      return this.check();
    } // Sets a quat from the given angle and rotation axis, then returns it.

  }, {
    key: "setAxisAngle",
    value: function setAxisAngle(axis, rad) {
      (0, _setAxisAngle.default)(this, axis, rad);
      return this.check();
    } // Performs a spherical linear interpolation between two quat

  }, {
    key: "slerp",
    value: function slerp(_ref) {
      var _ref$start = _ref.start,
          start = _ref$start === void 0 ? IDENTITY_QUATERNION : _ref$start,
          target = _ref.target,
          ratio = _ref.ratio;
      (0, _slerp.default)(this, start, target, ratio);
      return this.check();
    }
  }, {
    key: "ELEMENTS",
    get: function get() {
      return 4;
    }
  }, {
    key: "x",
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: "y",
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: "z",
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }, {
    key: "w",
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = (0, _common.checkNumber)(value);
    }
  }]);

  return Quaternion;
}(_mathArray.default);

exports.default = Quaternion;
//# sourceMappingURL=quaternion.js.map