'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); // Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Adaptation of THREE.js Spherical class, under MIT license


/* eslint-disable camelcase */


var _common = require('./common');

var _vector = require('./vector3');

var _vector2 = _interopRequireDefault(_vector);

var _length = require('gl-vec3/length');

var _length2 = _interopRequireDefault(_length);

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// TODO - import epsilon
var EPSILON = 0.000001;

var EARTH_RADIUS_METERS = 6.371e6;

// Todo [rho, theta, phi] ?

var SphericalCoordinates = function () {

  /**
   * Ref: https://en.wikipedia.org/wiki/Spherical_coordinate_system
   * The poles (phi) are at the positive and negative y axis.
   * The equator starts at positive z.
   * @class
   * @param {Number} phi=0 - rotation around X (latitude)
   * @param {Number} theta=0 - rotation around Y (longitude)
   * @param {Number} radius=1 - Distance from center
   */
  /* eslint-disable complexity */
  function SphericalCoordinates() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        phi = _ref.phi,
        theta = _ref.theta,
        radius = _ref.radius,
        bearing = _ref.bearing,
        pitch = _ref.pitch,
        altitude = _ref.altitude,
        _ref$radiusScale = _ref.radiusScale,
        radiusScale = _ref$radiusScale === undefined ? EARTH_RADIUS_METERS : _ref$radiusScale;

    _classCallCheck(this, SphericalCoordinates);

    if (arguments.length === 0) {
      this.phi = 0;
      this.theta = 0;
      this.radius = 1;
    } else if (Number.isFinite(phi) || Number.isFinite(theta)) {
      this.phi = phi || 0; // up / down towards top and bottom pole
      this.theta = theta || 0; // around the equator of the sphere
    } else if (Number.isFinite(bearing) || Number.isFinite(pitch)) {
      this.bearing = bearing || 0; // up / down towards top and bottom pole
      this.pitch = pitch || 0; // around the equator of the sphere
    }
    this.radius = radius || 1; // radial distance from center
    this.radiusScale = radiusScale || 1; // Used by lngLatZ
    this.check();
  }
  /* eslint-enable complexity */

  _createClass(SphericalCoordinates, [{
    key: 'toString',
    value: function toString() {
      return this.formatString(_common.config);
    }
  }, {
    key: 'formatString',
    value: function formatString(_ref2) {
      var printTypes = _ref2.printTypes,
          printDegrees = _ref2.printDegrees;

      var f = _common.formatValue;
      return (printTypes ? 'Spherical' : '') + '[rho:' + f(this.radius) + ',theta:' + f(this.theta) + ',phi:' + f(this.phi) + ']';
    }
  }, {
    key: 'equals',
    value: function equals(other) {
      return (0, _common.equals)(this.radius, other.radius) && (0, _common.equals)(this.theta, other.theta) && (0, _common.equals)(this.phi, other.phi);
    }
  }, {
    key: 'exactEquals',
    value: function exactEquals(other) {
      return this.radius === other.radius && this.theta === other.theta && this.phi === other.phi;
    }

    /* eslint-disable brace-style */
    // Cartographic (bearing 0 north, pitch 0 look from above)

  }, {
    key: 'set',

    /* eslint-enable brace-style */

    value: function set(radius, phi, theta) {
      this.radius = radius;
      this.phi = phi;
      this.theta = theta;
      return this.check();
    }
  }, {
    key: 'clone',
    value: function clone() {
      return new this.constructor().copy(this);
    }
  }, {
    key: 'copy',
    value: function copy(other) {
      this.radius = other.radius;
      this.phi = other.phi;
      this.theta = other.theta;
      return this.check();
    }
  }, {
    key: 'fromLngLatZ',
    value: function fromLngLatZ(_ref3) {
      var _ref4 = _slicedToArray(_ref3, 3),
          lng = _ref4[0],
          lat = _ref4[1],
          z = _ref4[2];

      this.radius = 1 + z / this.radiusScale;
      this.phi = (0, _common.radians)(lat);
      this.theta = (0, _common.radians)(lng);
    }
  }, {
    key: 'fromVector3',
    value: function fromVector3(v) {
      this.radius = (0, _length2.default)(v);
      if (this.radius === 0) {
        this.theta = 0;
        this.phi = 0;
      } else {
        this.theta = Math.atan2(v[0], v[1]); // equator angle around y-up axis
        this.phi = Math.acos((0, _common.clamp)(v[2] / this.radius, -1, 1)); // polar angle
      }
      return this.check();
    }
  }, {
    key: 'toVector3',
    value: function toVector3() {
      return new _vector2.default(0, 0, this.radius).rotateX({ radians: this.theta }).rotateZ({ radians: this.phi });
    }

    // restrict phi to be betwee EPS and PI-EPS

  }, {
    key: 'makeSafe',
    value: function makeSafe() {
      this.phi = Math.max(EPSILON, Math.min(Math.PI - EPSILON, this.phi));
    }
  }, {
    key: 'check',
    value: function check() {
      // this.makeSafe();
      (0, _assert2.default)(Number.isFinite(this.phi) && Number.isFinite(this.theta) && this.radius > 0);
      return this;
    }
  }, {
    key: 'bearing',
    get: function get() {
      return 180 - (0, _common.degrees)(this.phi);
    },
    set: function set(v) {
      this.phi = Math.PI - (0, _common.radians)(v);
    }
  }, {
    key: 'pitch',
    get: function get() {
      return (0, _common.degrees)(this.theta);
    },
    set: function set(v) {
      this.theta = (0, _common.radians)(v);
    }
    // get pitch() { return 90 - degrees(this.phi); }
    // set pitch(v) { this.phi = radians(v) + Math.PI / 2; }
    // get altitude() { return this.radius - 1; } // relative altitude

    // lnglatZ coordinates

  }, {
    key: 'longitude',
    get: function get() {
      return (0, _common.degrees)(this.phi);
    }
  }, {
    key: 'latitude',
    get: function get() {
      return (0, _common.degrees)(this.theta);
    }
  }, {
    key: 'lng',
    get: function get() {
      return (0, _common.degrees)(this.phi);
    }
  }, {
    key: 'lat',
    get: function get() {
      return (0, _common.degrees)(this.theta);
    }
  }, {
    key: 'z',
    get: function get() {
      return (this.radius - 1) * this.radiusScale;
    }
  }]);

  return SphericalCoordinates;
}();

exports.default = SphericalCoordinates;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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