'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.validateVector3 = validateVector3;

var _vector = require('./vector');

var _vector2 = _interopRequireDefault(_vector);

var _common = require('./common');

var _set = require('gl-vec3/set');

var _set2 = _interopRequireDefault(_set);

var _angle = require('gl-vec3/angle');

var _angle2 = _interopRequireDefault(_angle);

var _add = require('gl-vec3/add');

var _add2 = _interopRequireDefault(_add);

var _subtract = require('gl-vec3/subtract');

var _subtract2 = _interopRequireDefault(_subtract);

var _multiply = require('gl-vec3/multiply');

var _multiply2 = _interopRequireDefault(_multiply);

var _divide = require('gl-vec3/divide');

var _divide2 = _interopRequireDefault(_divide);

var _scale2 = require('gl-vec3/scale');

var _scale3 = _interopRequireDefault(_scale2);

var _scaleAndAdd = require('gl-vec3/scaleAndAdd');

var _scaleAndAdd2 = _interopRequireDefault(_scaleAndAdd);

var _cross = require('gl-vec3/cross');

var _cross2 = _interopRequireDefault(_cross);

var _rotateX = require('gl-vec3/rotateX');

var _rotateX2 = _interopRequireDefault(_rotateX);

var _rotateY = require('gl-vec3/rotateY');

var _rotateY2 = _interopRequireDefault(_rotateY);

var _rotateZ = require('gl-vec3/rotateZ');

var _rotateZ2 = _interopRequireDefault(_rotateZ);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// gl-matrix is too big. Cherry-pick individual imports from stack.gl version
/* eslint-disable camelcase */


var ORIGIN = [0, 0, 0];

function validateVector3(v) {
  return v.length === 3 && Number.isFinite(v[0]) && Number.isFinite(v[1]) && Number.isFinite(v[2]);
}

var Vector3 = function (_Vector) {
  _inherits(Vector3, _Vector);

  // Creates a new vec3, either empty, or from an array or from values
  function Vector3() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

    _classCallCheck(this, Vector3);

    var _this = _possibleConstructorReturn(this, (Vector3.__proto__ || Object.getPrototypeOf(Vector3)).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y, z);
    }
    return _this;
  }

  _createClass(Vector3, [{
    key: 'set',
    value: function set(x, y, z) {
      (0, _set2.default)(this, x, y, z);
      return this.check();
    }

    // Getters/setters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'angle',

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    value: function angle(vector) {
      return (0, _angle2.default)(this, vector);
    }

    // MODIFIERS

  }, {
    key: 'add',
    value: function add() {
      for (var _len = arguments.length, vectors = Array(_len), _key = 0; _key < _len; _key++) {
        vectors[_key] = arguments[_key];
      }

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = vectors[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var vector = _step.value;

          (0, _add2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return this.check();
    }
  }, {
    key: 'subtract',
    value: function subtract() {
      for (var _len2 = arguments.length, vectors = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        vectors[_key2] = arguments[_key2];
      }

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = vectors[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var vector = _step2.value;

          (0, _subtract2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return this.check();
    }
  }, {
    key: 'multiply',
    value: function multiply() {
      for (var _len3 = arguments.length, vectors = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        vectors[_key3] = arguments[_key3];
      }

      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = vectors[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var vector = _step3.value;

          (0, _multiply2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }

      return this.check();
    }
  }, {
    key: 'scale',
    value: function scale(_scale) {
      if (Number.isFinite(_scale)) {
        (0, _scale3.default)(this, this, _scale);
      } else {
        (0, _multiply2.default)(this, this, _scale);
      }
      return this.check();
    }
  }, {
    key: 'cross',
    value: function cross(vector) {
      (0, _cross2.default)(this, this, vector);
      return this.check();
    }
  }, {
    key: 'rotateX',
    value: function rotateX(_ref) {
      var radians = _ref.radians,
          _ref$origin = _ref.origin,
          origin = _ref$origin === undefined ? ORIGIN : _ref$origin;

      (0, _rotateX2.default)(this, this, origin, radians);
      return this.check();
    }
  }, {
    key: 'rotateY',
    value: function rotateY(_ref2) {
      var radians = _ref2.radians,
          _ref2$origin = _ref2.origin,
          origin = _ref2$origin === undefined ? ORIGIN : _ref2$origin;

      (0, _rotateY2.default)(this, this, origin, radians);
      return this.check();
    }
  }, {
    key: 'rotateZ',
    value: function rotateZ(_ref3) {
      var radians = _ref3.radians,
          _ref3$origin = _ref3.origin,
          origin = _ref3$origin === undefined ? ORIGIN : _ref3$origin;

      (0, _rotateZ2.default)(this, this, origin, radians);
      return this.check();
    }
  }, {
    key: 'operation',
    value: function operation(_operation) {
      for (var _len4 = arguments.length, args = Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
        args[_key4 - 1] = arguments[_key4];
      }

      _operation.apply(undefined, [this, this].concat(args));
      return this.check();
    }

    // TBD - do we really need these?

  }, {
    key: 'divide',
    value: function divide() {
      for (var _len5 = arguments.length, vectors = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
        vectors[_key5] = arguments[_key5];
      }

      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = vectors[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var vector = _step4.value;

          (0, _divide2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }

      return this.check();
    }
  }, {
    key: 'scaleAndAdd',
    value: function scaleAndAdd(vector, scale) {
      (0, _scaleAndAdd2.default)(this, this, vector, scale);
      return this.check();
    }
  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 3;
    }
  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'z',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }]);

  return Vector3;
}(_vector2.default);

exports.default = Vector3;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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