"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _common = require("./lib/common");

var _vector = _interopRequireDefault(require("./vector3"));

var _length = _interopRequireDefault(require("gl-vec3/length"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// import assert from 'assert';
// TODO - import epsilon
var EPSILON = 0.000001;
var EARTH_RADIUS_METERS = 6.371e6; // Todo [rho, theta, phi] ?

var SphericalCoordinates =
/*#__PURE__*/
function () {
  /**
   * Ref: https://en.wikipedia.org/wiki/Spherical_coordinate_system
   * The poles (phi) are at the positive and negative y axis.
   * The equator starts at positive z.
   * @class
   * @param {Number} phi=0 - rotation around X (latitude)
   * @param {Number} theta=0 - rotation around Y (longitude)
   * @param {Number} radius=1 - Distance from center
   */

  /* eslint-disable complexity */
  function SphericalCoordinates() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        phi = _ref.phi,
        theta = _ref.theta,
        radius = _ref.radius,
        bearing = _ref.bearing,
        pitch = _ref.pitch,
        altitude = _ref.altitude,
        _ref$radiusScale = _ref.radiusScale,
        radiusScale = _ref$radiusScale === void 0 ? EARTH_RADIUS_METERS : _ref$radiusScale;

    _classCallCheck(this, SphericalCoordinates);

    if (arguments.length === 0) {
      this.phi = 0;
      this.theta = 0;
      this.radius = 1;
    } else if (Number.isFinite(phi) || Number.isFinite(theta)) {
      this.phi = phi || 0; // up / down towards top and bottom pole

      this.theta = theta || 0; // around the equator of the sphere
    } else if (Number.isFinite(bearing) || Number.isFinite(pitch)) {
      this.bearing = bearing || 0; // up / down towards top and bottom pole

      this.pitch = pitch || 0; // around the equator of the sphere
    }

    this.radius = radius || 1; // radial distance from center

    this.radiusScale = radiusScale || 1; // Used by lngLatZ

    this.check();
  }
  /* eslint-enable complexity */


  _createClass(SphericalCoordinates, [{
    key: "toString",
    value: function toString() {
      return this.formatString(_common.config);
    }
  }, {
    key: "formatString",
    value: function formatString(_ref2) {
      var printTypes = _ref2.printTypes,
          printDegrees = _ref2.printDegrees;
      var f = _common.formatValue;
      return "".concat(printTypes ? 'Spherical' : '', "[rho:").concat(f(this.radius), ",theta:").concat(f(this.theta), ",phi:").concat(f(this.phi), "]");
    }
  }, {
    key: "equals",
    value: function equals(other) {
      return (0, _common.equals)(this.radius, other.radius) && (0, _common.equals)(this.theta, other.theta) && (0, _common.equals)(this.phi, other.phi);
    }
  }, {
    key: "exactEquals",
    value: function exactEquals(other) {
      return this.radius === other.radius && this.theta === other.theta && this.phi === other.phi;
    }
    /* eslint-disable brace-style */
    // Cartographic (bearing 0 north, pitch 0 look from above)

  }, {
    key: "set",

    /* eslint-enable brace-style */
    value: function set(radius, phi, theta) {
      this.radius = radius;
      this.phi = phi;
      this.theta = theta;
      return this.check();
    }
  }, {
    key: "clone",
    value: function clone() {
      return new this.constructor().copy(this);
    }
  }, {
    key: "copy",
    value: function copy(other) {
      this.radius = other.radius;
      this.phi = other.phi;
      this.theta = other.theta;
      return this.check();
    }
  }, {
    key: "fromLngLatZ",
    value: function fromLngLatZ(_ref3) {
      var _ref4 = _slicedToArray(_ref3, 3),
          lng = _ref4[0],
          lat = _ref4[1],
          z = _ref4[2];

      this.radius = 1 + z / this.radiusScale;
      this.phi = (0, _common.radians)(lat);
      this.theta = (0, _common.radians)(lng);
    }
  }, {
    key: "fromVector3",
    value: function fromVector3(v) {
      this.radius = (0, _length.default)(v);

      if (this.radius === 0) {
        this.theta = 0;
        this.phi = 0;
      } else {
        this.theta = Math.atan2(v[0], v[1]); // equator angle around y-up axis

        this.phi = Math.acos((0, _common.clamp)(v[2] / this.radius, -1, 1)); // polar angle
      }

      return this.check();
    }
  }, {
    key: "toVector3",
    value: function toVector3() {
      return new _vector.default(0, 0, this.radius).rotateX({
        radians: this.theta
      }).rotateZ({
        radians: this.phi
      });
    } // restrict phi to be betwee EPS and PI-EPS

  }, {
    key: "makeSafe",
    value: function makeSafe() {
      this.phi = Math.max(EPSILON, Math.min(Math.PI - EPSILON, this.phi));
    }
  }, {
    key: "check",
    value: function check() {
      // this.makeSafe();
      if (!Number.isFinite(this.phi) || !Number.isFinite(this.theta) || !(this.radius > 0)) {
        throw new Error('SphericalCoordinates: some fields set to invalid numbers');
      }

      return this;
    }
  }, {
    key: "bearing",
    get: function get() {
      return 180 - (0, _common.degrees)(this.phi);
    },
    set: function set(v) {
      this.phi = Math.PI - (0, _common.radians)(v);
    }
  }, {
    key: "pitch",
    get: function get() {
      return (0, _common.degrees)(this.theta);
    },
    set: function set(v) {
      this.theta = (0, _common.radians)(v);
    } // get pitch() { return 90 - degrees(this.phi); }
    // set pitch(v) { this.phi = radians(v) + Math.PI / 2; }
    // get altitude() { return this.radius - 1; } // relative altitude
    // lnglatZ coordinates

  }, {
    key: "longitude",
    get: function get() {
      return (0, _common.degrees)(this.phi);
    }
  }, {
    key: "latitude",
    get: function get() {
      return (0, _common.degrees)(this.theta);
    }
  }, {
    key: "lng",
    get: function get() {
      return (0, _common.degrees)(this.phi);
    }
  }, {
    key: "lat",
    get: function get() {
      return (0, _common.degrees)(this.theta);
    }
  }, {
    key: "z",
    get: function get() {
      return (this.radius - 1) * this.radiusScale;
    }
  }]);

  return SphericalCoordinates;
}();

exports.default = SphericalCoordinates;
//# sourceMappingURL=spherical-coordinates.js.map