function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
import MathArray from './lib/math-array';
import { checkNumber } from './lib/common';
import Vector2 from './vector2';
import Vector3 from './vector3';
import Vector4 from './vector4'; // gl-matrix is too big. Cherry-pick individual imports from stack.gl version

/* eslint-disable camelcase */

import mat4_determinant from 'gl-mat4/determinant';
import mat4_fromQuat from 'gl-mat4/fromQuat';
import mat4_frustum from 'gl-mat4/frustum';
import mat4_lookAt from 'gl-mat4/lookAt';
import mat4_ortho from 'gl-mat4/ortho';
import mat4_perspective from 'gl-mat4/perspective';
import mat4_transpose from 'gl-mat4/transpose';
import mat4_invert from 'gl-mat4/invert';
import mat4_multiply from 'gl-mat4/multiply';
import mat4_rotate from 'gl-mat4/rotate';
import mat4_scale from 'gl-mat4/scale';
import mat4_translate from 'gl-mat4/translate';
import vec2_transformMat4 from 'gl-vec2/transformMat4';
import vec3_transformMat4 from 'gl-vec3/transformMat4';
import vec4_transformMat4 from 'gl-vec4/transformMat4';
import mat4_rotateX from 'gl-mat4/rotateX';
import mat4_rotateY from 'gl-mat4/rotateY';
import mat4_rotateZ from 'gl-mat4/rotateZ';
var IDENTITY = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
export function validateMatrix4(m) {
  return m.length === 16 && Number.isFinite(m[0]) && Number.isFinite(m[1]) && Number.isFinite(m[2]) && Number.isFinite(m[3]) && Number.isFinite(m[4]) && Number.isFinite(m[5]) && Number.isFinite(m[6]) && Number.isFinite(m[7]) && Number.isFinite(m[8]) && Number.isFinite(m[9]) && Number.isFinite(m[10]) && Number.isFinite(m[11]) && Number.isFinite(m[12]) && Number.isFinite(m[13]) && Number.isFinite(m[14]) && Number.isFinite(m[15]);
}

function validateVector(v, length) {
  if (v.length !== length) {
    return false;
  }

  return v.every(Number.isFinite);
}

var Matrix4 =
/*#__PURE__*/
function (_MathArray) {
  _inherits(Matrix4, _MathArray);

  function Matrix4() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _classCallCheck(this, Matrix4);

    _this = _possibleConstructorReturn(this, (Matrix4.__proto__ || Object.getPrototypeOf(Matrix4)).call(this));

    if (Array.isArray(args[0]) && arguments.length === 1) {
      _this.copy(args[0]);
    } else {
      _this.identity();
    }

    return _this;
  }

  _createClass(Matrix4, [{
    key: "setRowMajor",

    /* eslint-disable max-params */
    // accepts row major order, stores as column major
    value: function setRowMajor() {
      var m00 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var m01 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var m02 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var m03 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var m10 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
      var m11 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
      var m12 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
      var m13 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
      var m20 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
      var m21 = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : 0;
      var m22 = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 1;
      var m23 = arguments.length > 11 && arguments[11] !== undefined ? arguments[11] : 0;
      var m30 = arguments.length > 12 && arguments[12] !== undefined ? arguments[12] : 0;
      var m31 = arguments.length > 13 && arguments[13] !== undefined ? arguments[13] : 0;
      var m32 = arguments.length > 14 && arguments[14] !== undefined ? arguments[14] : 0;
      var m33 = arguments.length > 15 && arguments[15] !== undefined ? arguments[15] : 1;
      this[0] = m00;
      this[1] = m10;
      this[2] = m20;
      this[3] = m30;
      this[4] = m01;
      this[5] = m11;
      this[6] = m21;
      this[7] = m31;
      this[8] = m02;
      this[9] = m12;
      this[10] = m22;
      this[11] = m32;
      this[12] = m03;
      this[13] = m13;
      this[14] = m23;
      this[15] = m33;
      return this.check();
    } // accepts column major order, stores in column major order

  }, {
    key: "setColumnMajor",
    value: function setColumnMajor() {
      var m00 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var m10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var m20 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var m30 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var m01 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
      var m11 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
      var m21 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
      var m31 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
      var m02 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
      var m12 = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : 0;
      var m22 = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 1;
      var m32 = arguments.length > 11 && arguments[11] !== undefined ? arguments[11] : 0;
      var m03 = arguments.length > 12 && arguments[12] !== undefined ? arguments[12] : 0;
      var m13 = arguments.length > 13 && arguments[13] !== undefined ? arguments[13] : 0;
      var m23 = arguments.length > 14 && arguments[14] !== undefined ? arguments[14] : 0;
      var m33 = arguments.length > 15 && arguments[15] !== undefined ? arguments[15] : 1;
      this[0] = m00;
      this[1] = m10;
      this[2] = m20;
      this[3] = m30;
      this[4] = m01;
      this[5] = m11;
      this[6] = m21;
      this[7] = m31;
      this[8] = m02;
      this[9] = m12;
      this[10] = m22;
      this[11] = m32;
      this[12] = m03;
      this[13] = m13;
      this[14] = m23;
      this[15] = m33;
      return this.check();
    }
    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: "copy",
    value: function copy(array) {
      return this.setColumnMajor.apply(this, _toConsumableArray(array));
    } // Sets exact values (column major)

  }, {
    key: "set",
    value: function set() {
      return this.setColumnMajor.apply(this, arguments);
    } // By default assumes row major indices

  }, {
    key: "getElement",
    value: function getElement(i, j) {
      var columnMajor = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      return columnMajor ? this[i][j] : this[j][i];
    } // By default assumes row major indices

  }, {
    key: "setElement",
    value: function setElement(i, j, value) {
      var columnMajor = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

      if (columnMajor) {
        this[j][i] = checkNumber(value);
      } else {
        this[j][i] = checkNumber(value);
      }

      return this;
    }
    /* eslint-enable max-params */
    // toString() {
    //   if (config.printRowMajor) {
    //     mat4_str(this);
    //   } else {
    //     mat4_str(this);
    //   }
    // }
    // Accessors

  }, {
    key: "determinant",
    value: function determinant() {
      return mat4_determinant(this);
    } // Constructors

  }, {
    key: "identity",
    value: function identity() {
      return this.copy(IDENTITY);
    } // Calculates a 4x4 matrix from the given quaternion
    // q quat  Quaternion to create matrix from

  }, {
    key: "fromQuaternion",
    value: function fromQuaternion(q) {
      mat4_fromQuat(this, q);
      return this.check();
    } // Generates a frustum matrix with the given bounds
    // left  Number  Left bound of the frustum
    // right Number  Right bound of the frustum
    // bottom  Number  Bottom bound of the frustum
    // top Number  Top bound of the frustum
    // near  Number  Near bound of the frustum
    // far Number  Far bound of the frustum

  }, {
    key: "frustum",
    value: function frustum(_ref) {
      var left = _ref.left,
          right = _ref.right,
          bottom = _ref.bottom,
          top = _ref.top,
          near = _ref.near,
          far = _ref.far;
      mat4_frustum(this, left, right, bottom, top, near, far);
      return this.check();
    } // Generates a look-at matrix with the given eye position, focal point,
    // and up axis
    // eye vec3  Position of the viewer
    // center  vec3  Point the viewer is looking at
    // up  vec3  vec3 pointing up

  }, {
    key: "lookAt",
    value: function lookAt(_ref2) {
      var eye = _ref2.eye,
          _ref2$center = _ref2.center,
          center = _ref2$center === void 0 ? [0, 0, 0] : _ref2$center,
          _ref2$up = _ref2.up,
          up = _ref2$up === void 0 ? [0, 1, 0] : _ref2$up;
      mat4_lookAt(this, eye, center, up);
      return this.check();
    } // Generates a orthogonal projection matrix with the given bounds
    // from "traditional" view space parameters
    // left  number  Left bound of the frustum
    // right number  Right bound of the frustum
    // bottom  number  Bottom bound of the frustum
    // top number  Top bound of the frustum
    // near  number  Near bound of the frustum
    // far number  Far bound of the frustum

  }, {
    key: "ortho",
    value: function ortho(_ref3) {
      var left = _ref3.left,
          right = _ref3.right,
          bottom = _ref3.bottom,
          top = _ref3.top,
          _ref3$near = _ref3.near,
          near = _ref3$near === void 0 ? 0.1 : _ref3$near,
          _ref3$far = _ref3.far,
          far = _ref3$far === void 0 ? 500 : _ref3$far;
      mat4_ortho(this, left, right, bottom, top, near, far);
      return this.check();
    } // Generates an orthogonal projection matrix with the same parameters
    // as a perspective matrix (plus focalDistance)
    // fovy  number  Vertical field of view in radians
    // aspect  number  Aspect ratio. typically viewport width/height
    // focalDistance distance in the view frustum used for extent calculations
    // near  number  Near bound of the frustum
    // far number  Far bound of the frustum

  }, {
    key: "orthographic",
    value: function orthographic(_ref4) {
      var _ref4$fovy = _ref4.fovy,
          fovy = _ref4$fovy === void 0 ? 45 * Math.PI / 180 : _ref4$fovy,
          _ref4$aspect = _ref4.aspect,
          aspect = _ref4$aspect === void 0 ? 1 : _ref4$aspect,
          _ref4$focalDistance = _ref4.focalDistance,
          focalDistance = _ref4$focalDistance === void 0 ? 1 : _ref4$focalDistance,
          _ref4$near = _ref4.near,
          near = _ref4$near === void 0 ? 0.1 : _ref4$near,
          _ref4$far = _ref4.far,
          far = _ref4$far === void 0 ? 500 : _ref4$far;

      if (fovy > Math.PI * 2) {
        throw Error('radians');
      }

      var halfY = fovy / 2;
      var top = focalDistance * Math.tan(halfY); // focus_plane is the distance from the camera

      var right = top * aspect;
      return new Matrix4().ortho({
        left: -right,
        right: right,
        bottom: -top,
        top: top,
        near: near,
        far: far
      });
    } // Generates a perspective projection matrix with the given bounds
    // fovy  number  Vertical field of view in radians
    // aspect  number  Aspect ratio. typically viewport width/height
    // near  number  Near bound of the frustum
    // far number  Far bound of the frustum

  }, {
    key: "perspective",
    value: function perspective() {
      var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          fovy = _ref5.fovy,
          _ref5$fov = _ref5.fov,
          fov = _ref5$fov === void 0 ? 45 * Math.PI / 180 : _ref5$fov,
          _ref5$aspect = _ref5.aspect,
          aspect = _ref5$aspect === void 0 ? 1 : _ref5$aspect,
          _ref5$near = _ref5.near,
          near = _ref5$near === void 0 ? 0.1 : _ref5$near,
          _ref5$far = _ref5.far,
          far = _ref5$far === void 0 ? 500 : _ref5$far;

      fovy = fovy || fov;

      if (fovy > Math.PI * 2) {
        throw Error('radians');
      }

      mat4_perspective(this, fovy, aspect, near, far);
      return this.check();
    } // Modifiers

  }, {
    key: "transpose",
    value: function transpose() {
      mat4_transpose(this, this);
      return this.check();
    }
  }, {
    key: "invert",
    value: function invert() {
      mat4_invert(this, this);
      return this.check();
    } // Operations

  }, {
    key: "multiplyLeft",
    value: function multiplyLeft(a) {
      mat4_multiply(this, a, this);
      return this.check();
    }
  }, {
    key: "multiplyRight",
    value: function multiplyRight(a) {
      mat4_multiply(this, this, a);
      return this.check();
    } // Rotates a matrix by the given angle around the X axis

  }, {
    key: "rotateX",
    value: function rotateX(radians) {
      mat4_rotateX(this, this, radians); // mat4_rotate(this, this, radians, [1, 0, 0]);

      return this.check();
    } // Rotates a matrix by the given angle around the Y axis.

  }, {
    key: "rotateY",
    value: function rotateY(radians) {
      mat4_rotateY(this, this, radians); // mat4_rotate(this, this, radians, [0, 1, 0]);

      return this.check();
    } // Rotates a matrix by the given angle around the Z axis.

  }, {
    key: "rotateZ",
    value: function rotateZ(radians) {
      mat4_rotateZ(this, this, radians); // mat4_rotate(this, this, radians, [0, 0, 1]);

      return this.check();
    }
  }, {
    key: "rotateXYZ",
    value: function rotateXYZ(_ref6) {
      var _ref7 = _slicedToArray(_ref6, 3),
          rx = _ref7[0],
          ry = _ref7[1],
          rz = _ref7[2];

      return this.rotateX(rx).rotateY(ry).rotateZ(rz);
    }
  }, {
    key: "rotateAxis",
    value: function rotateAxis(radians, axis) {
      mat4_rotate(this, this, radians, axis);
      return this.check();
    }
  }, {
    key: "scale",
    value: function scale(vec) {
      mat4_scale(this, this, vec);
      return this.check();
    }
  }, {
    key: "translate",
    value: function translate(vec) {
      mat4_translate(this, this, vec);
      return this.check();
    }
  }, {
    key: "transformVector2",
    value: function transformVector2(vector, out) {
      // out = out || [0, 0];
      out = out || new Vector2();
      vec2_transformMat4(out, vector, this);
      validateVector(out, 2);
      return out;
    }
  }, {
    key: "transformVector3",
    value: function transformVector3(vector, out) {
      // out = out || [0, 0, 0];
      out = out || new Vector3();
      vec3_transformMat4(out, vector, this);
      validateVector(out, 3);
      return out;
    }
  }, {
    key: "transformVector4",
    value: function transformVector4(vector, out) {
      // out = out || [0, 0, 0, 0];
      out = out || new Vector4();
      vec4_transformMat4(out, vector, this);
      validateVector(out, 4);
      return out.check();
    } // Transforms any 2, 3 or 4 element vector
    // returns a newly minted Vector2, Vector3 or Vector4

  }, {
    key: "transformVector",
    value: function transformVector(vector, out) {
      switch (vector.length) {
        case 2:
          return this.transformVector2(vector, out);

        case 3:
          return this.transformVector3(vector, out);

        case 4:
          return this.transformVector4(vector, out);

        default:
          throw new Error('Illegal vector');
      }
    }
  }, {
    key: "transformDirection",
    value: function transformDirection(vector, out) {
      return this._transformVector(vector, out, 0);
    }
  }, {
    key: "transformPoint",
    value: function transformPoint(vector, out) {
      return this._transformVector(vector, out, 1);
    }
  }, {
    key: "_transformVector",
    value: function _transformVector(vector, out, w) {
      switch (vector.length) {
        case 2:
          out = out || new Vector2(); // out = out || [0, 0];

          vec4_transformMat4(out, [vector[0], vector[1], 0, w], this);
          out.length = 2;
          validateVector(out, 2);
          break;

        case 3:
          out = out || new Vector3(); // out = out || [0, 0, 0];

          vec4_transformMat4(out, [vector[0], vector[1], vector[2], w], this);
          out.length = 3;
          validateVector(out, 3);
          break;

        case 4:
          if (Boolean(w) !== Boolean(vector[3])) {
            throw new Error('math.gl: Matrix4.transformPoint - invalid vector');
          }

          out = out || new Vector4(); // out = out || [0, 0, 0, 0];

          vec4_transformMat4(out, vector, this);
          validateVector(out, 4);
          break;

        default:
          throw new Error('Illegal vector');
      }

      return out;
    } // three.js compatibility

  }, {
    key: "makeRotationX",
    value: function makeRotationX(radians) {
      return this.identity().rotateX(radians);
    }
  }, {
    key: "makeTranslation",
    value: function makeTranslation(x, y, z) {
      return this.identity().translate([x, y, z]);
    }
  }, {
    key: "ELEMENTS",
    get: function get() {
      return 16;
    }
  }]);

  return Matrix4;
}(MathArray);

export { Matrix4 as default };
//# sourceMappingURL=matrix4.js.map