'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

var _matrix = require('./matrix4');

var _matrix2 = _interopRequireDefault(_matrix);

var _quaternion = require('./quaternion');

var _quaternion2 = _interopRequireDefault(_quaternion);

var _vector = require('./vector3');

var _vector2 = _interopRequireDefault(_vector);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Internal constants
var ERR_UNKNOWN_ORDER = 'Unknown Euler angle order';
var ALMOST_ONE = 0.99999;

function validateOrder(value) {
  return value >= 0 && value < 6;
}

function checkOrder(value) {
  if (value < 0 && value >= 6) {
    throw new Error(ERR_UNKNOWN_ORDER);
  }
  return value;
}

var Euler = function (_MathArray) {
  _inherits(Euler, _MathArray);

  _createClass(Euler, [{
    key: 'ELEMENTS',
    get: function get() {
      return 4;
    }
    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    /*
     * Number|Number[], Number, Number, Number
     */

  }], [{
    key: 'rotationOrder',
    value: function rotationOrder(order) {
      return Euler.RotationOrders[order];
    }
  }, {
    key: 'ZYX',


    // static XYZ = 0;
    // static YZX = 1;
    // static ZXY = 2;
    // static XZY = 3;
    // static YXZ = 4;
    // static ZYX = 5;
    // static RollPitchYaw = 0;
    // static DefaultOrder = 0;

    // Constants
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */
    get: function get() {
      return 0;
    }
  }, {
    key: 'YXZ',
    get: function get() {
      return 1;
    }
  }, {
    key: 'XZY',
    get: function get() {
      return 2;
    }
  }, {
    key: 'ZXY',
    get: function get() {
      return 3;
    }
  }, {
    key: 'YZX',
    get: function get() {
      return 4;
    }
  }, {
    key: 'XYZ',
    get: function get() {
      return 5;
    }
  }, {
    key: 'RollPitchYaw',
    get: function get() {
      return 0;
    }
  }, {
    key: 'DefaultOrder',
    get: function get() {
      return Euler.ZYX;
    }
  }, {
    key: 'RotationOrders',
    get: function get() {
      return ['ZYX', 'YXZ', 'XZY', 'ZXY', 'YZX', 'XYZ'];
    }
  }]);

  function Euler() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var order = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Euler.DefaultOrder;

    _classCallCheck(this, Euler);

    var _this = _possibleConstructorReturn(this, (Euler.__proto__ || Object.getPrototypeOf(Euler)).call(this));

    if (arguments.length > 0 && Array.isArray(arguments[0])) {
      _this.fromVector3.apply(_this, arguments);
    } else {
      _this.set(x, y, z, order);
    }
    return _this;
  }

  // If copied array does contain fourth element, preserves currently set order


  _createClass(Euler, [{
    key: 'copy',
    value: function copy(array) {
      for (var i = 0; i < 3; ++i) {
        this[i] = array[i];
      }
      this[3] = Number.isFinite(array[3]) || this.order;
      this.check();
      return this;
    }

    // Sets the three angles, and optionally sets the rotation order
    // If order is not specified, preserves currently set order

  }, {
    key: 'set',
    value: function set() {
      var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var order = arguments[3];

      this[0] = x;
      this[1] = y;
      this[2] = z;
      this[3] = Number.isFinite(order) ? order : this[3];
      this.check();
      return this;
    }
  }, {
    key: 'validate',
    value: function validate() {
      return validateOrder(this[3]) && Number.isFinite(this[0]) && Number.isFinite(this[1]) && Number.isFinite(this[2]);
    }

    // Does not copy the orientation element

  }, {
    key: 'toArray',
    value: function toArray() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      array[offset] = this[0];
      array[offset + 1] = this[1];
      array[offset + 2] = this[2];
      return array;
    }

    // Copies the orientation element

  }, {
    key: 'toArray4',
    value: function toArray4() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      array[offset] = this[0];
      array[offset + 1] = this[1];
      array[offset + 2] = this[2];
      array[offset + 3] = this[3];
      return array;
    }
  }, {
    key: 'toVector3',
    value: function toVector3(optionalResult) {
      if (optionalResult) {
        return optionalResult.set(this[0], this[1], this[2]);
      }
      return new _vector2.default(this[0], this[1], this[2]);
    }

    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */
    // x, y, z angle notation (note: only corresponds to axis in XYZ orientation)

  }, {
    key: 'fromVector3',

    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

    // Constructors
    value: function fromVector3(v, order) {
      return this.set(v[0], v[1], v[2], Number.isFinite(order) ? order : this[3]);
    }

    // TODO - with and without 4th element

  }, {
    key: 'fromArray',
    value: function fromArray(array) {
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      this[0] = array[0 + offset];
      this[1] = array[1 + offset];
      this[2] = array[2 + offset];
      if (array[3] !== undefined) {
        this[3] = array[3];
      }
      this.check();
      return this;
    }

    // Common ZYX rotation order

  }, {
    key: 'fromRollPitchYaw',
    value: function fromRollPitchYaw(roll, pitch, yaw) {
      return this.set(roll, pitch, yaw, Euler.ZYX);
    }
  }, {
    key: 'fromQuaternion',
    value: function fromQuaternion(q, order) {
      this._fromRotationMatrix(_matrix2.default.fromQuaternion(q), order);
      this.check();
      return this;
    }
  }, {
    key: 'fromRotationMatrix',
    value: function fromRotationMatrix(m) {
      var order = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Euler.DefaultOrder;

      this._fromRotationMatrix(m, order);
      this.check();
      return this;
    }

    // ACCESSORS

    // @return {Matrix4} a rotation matrix corresponding to rotations
    //   per the specified euler angles

  }, {
    key: 'getRotationMatrix',
    value: function getRotationMatrix() {
      var m = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new _matrix2.default();

      this._getRotationMatrix(m);
      return m;
    }
  }, {
    key: 'getQuaternion',
    value: function getQuaternion() {
      var q = new _quaternion2.default();
      switch (this[4]) {
        case Euler.XYZ:
          return q.rotateX(this[0]).rotateY(this[1]).rotateZ(this[2]);
        case Euler.YXZ:
          return q.rotateY(this[0]).rotateX(this[1]).rotateZ(this[2]);
        case Euler.ZXY:
          return q.rotateZ(this[0]).rotateX(this[1]).rotateY(this[2]);
        case Euler.ZYX:
          return q.rotateZ(this[0]).rotateY(this[1]).rotateX(this[2]);
        case Euler.YZX:
          return q.rotateY(this[0]).rotateZ(this[1]).rotateX(this[2]);
        case Euler.XZY:
          return q.rotateX(this[0]).rotateZ(this[1]).rotateY(this[2]);
        default:
          throw new Error(ERR_UNKNOWN_ORDER);
      }
    }

    // INTERNAL METHODS

    // Concersion from Euler to rotation matrix and from matrix to Euler
    // Adapted from three.js under MIT license

    // // WARNING: this discards revolution information -bhouston
    // reorder(newOrder) {
    //   const q = new Quaternion().setFromEuler(this);
    //   return this.setFromQuaternion(q, newOrder);

    /* eslint-disable complexity, max-statements, one-var */

  }, {
    key: '_fromRotationMatrix',
    value: function _fromRotationMatrix(m) {
      var order = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Euler.DefaultOrder;

      // assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)

      var te = m.elements;
      var m11 = te[0],
          m12 = te[4],
          m13 = te[8];
      var m21 = te[1],
          m22 = te[5],
          m23 = te[9];
      var m31 = te[2],
          m32 = te[6],
          m33 = te[10];

      order = order || this[3];

      switch (order) {
        case Euler.XYZ:
          this[1] = Math.asin((0, _common.clamp)(m13, -1, 1));

          if (Math.abs(m13) < ALMOST_ONE) {
            this[0] = Math.atan2(-m23, m33);
            this[2] = Math.atan2(-m12, m11);
          } else {
            this[0] = Math.atan2(m32, m22);
            this[2] = 0;
          }
          break;

        case Euler.YXZ:
          this[0] = Math.asin(-(0, _common.clamp)(m23, -1, 1));

          if (Math.abs(m23) < ALMOST_ONE) {
            this[1] = Math.atan2(m13, m33);
            this[2] = Math.atan2(m21, m22);
          } else {
            this[1] = Math.atan2(-m31, m11);
            this[2] = 0;
          }
          break;

        case Euler.ZXY:
          this[0] = Math.asin((0, _common.clamp)(m32, -1, 1));

          if (Math.abs(m32) < ALMOST_ONE) {
            this[1] = Math.atan2(-m31, m33);
            this[2] = Math.atan2(-m12, m22);
          } else {
            this[1] = 0;
            this[2] = Math.atan2(m21, m11);
          }
          break;

        case Euler.ZYX:
          this[1] = Math.asin(-(0, _common.clamp)(m31, -1, 1));

          if (Math.abs(m31) < ALMOST_ONE) {
            this[0] = Math.atan2(m32, m33);
            this[2] = Math.atan2(m21, m11);
          } else {
            this[0] = 0;
            this[2] = Math.atan2(-m12, m22);
          }
          break;

        case Euler.YZX:
          this[2] = Math.asin((0, _common.clamp)(m21, -1, 1));

          if (Math.abs(m21) < ALMOST_ONE) {
            this[0] = Math.atan2(-m23, m22);
            this[1] = Math.atan2(-m31, m11);
          } else {
            this[0] = 0;
            this[1] = Math.atan2(m13, m33);
          }
          break;

        case Euler.XZY:
          this[2] = Math.asin(-(0, _common.clamp)(m12, -1, 1));

          if (Math.abs(m12) < ALMOST_ONE) {
            this[0] = Math.atan2(m32, m22);
            this[1] = Math.atan2(m13, m11);
          } else {
            this[0] = Math.atan2(-m23, m33);
            this[1] = 0;
          }
          break;

        default:
          throw new Error(ERR_UNKNOWN_ORDER);
      }

      this[3] = order;

      return this;
    }
  }, {
    key: '_getRotationMatrix',
    value: function _getRotationMatrix() {
      var te = new _matrix2.default();

      var x = this.x,
          y = this.y,
          z = this.z;
      var a = Math.cos(x);
      var c = Math.cos(y);
      var e = Math.cos(z);
      var b = Math.sin(x);
      var d = Math.sin(y);
      var f = Math.sin(z);

      switch (this[3]) {
        case Euler.XYZ:
          {
            var ae = a * e,
                af = a * f,
                be = b * e,
                bf = b * f;

            te[0] = c * e;
            te[4] = -c * f;
            te[8] = d;

            te[1] = af + be * d;
            te[5] = ae - bf * d;
            te[9] = -b * c;

            te[2] = bf - ae * d;
            te[6] = be + af * d;
            te[10] = a * c;
            break;
          }

        case Euler.YXZ:
          {
            var ce = c * e,
                cf = c * f,
                de = d * e,
                df = d * f;

            te[0] = ce + df * b;
            te[4] = de * b - cf;
            te[8] = a * d;

            te[1] = a * f;
            te[5] = a * e;
            te[9] = -b;

            te[2] = cf * b - de;
            te[6] = df + ce * b;
            te[10] = a * c;
            break;
          }

        case Euler.ZXY:
          {
            var _ce = c * e,
                _cf = c * f,
                _de = d * e,
                _df = d * f;

            te[0] = _ce - _df * b;
            te[4] = -a * f;
            te[8] = _de + _cf * b;

            te[1] = _cf + _de * b;
            te[5] = a * e;
            te[9] = _df - _ce * b;

            te[2] = -a * d;
            te[6] = b;
            te[10] = a * c;
            break;
          }

        case Euler.ZYX:
          {
            var _ae = a * e,
                _af = a * f,
                _be = b * e,
                _bf = b * f;

            te[0] = c * e;
            te[4] = _be * d - _af;
            te[8] = _ae * d + _bf;

            te[1] = c * f;
            te[5] = _bf * d + _ae;
            te[9] = _af * d - _be;

            te[2] = -d;
            te[6] = b * c;
            te[10] = a * c;
            break;
          }

        case Euler.YZX:
          {
            var ac = a * c,
                ad = a * d,
                bc = b * c,
                bd = b * d;

            te[0] = c * e;
            te[4] = bd - ac * f;
            te[8] = bc * f + ad;

            te[1] = f;
            te[5] = a * e;
            te[9] = -b * e;

            te[2] = -d * e;
            te[6] = ad * f + bc;
            te[10] = ac - bd * f;
            break;
          }

        case Euler.XZY:
          {
            var _ac = a * c,
                _ad = a * d,
                _bc = b * c,
                _bd = b * d;

            te[0] = c * e;
            te[4] = -f;
            te[8] = d * e;

            te[1] = _ac * f + _bd;
            te[5] = a * e;
            te[9] = _ad * f - _bc;

            te[2] = _bc * f - _ad;
            te[6] = b * e;
            te[10] = _bd * f + _ac;
            break;
          }

        default:
          throw new Error(ERR_UNKNOWN_ORDER);
      }

      // last column
      te[3] = 0;
      te[7] = 0;
      te[11] = 0;

      // bottom row
      te[12] = 0;
      te[13] = 0;
      te[14] = 0;
      te[15] = 1;

      return this;
    }
    /* eslint-enable complexity, max-statements, one-var */

  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'z',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }

    // alpha, beta, gamma angle notation

  }, {
    key: 'alpha',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'beta',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'gamma',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }

    // phi, theta, psi angle notation

  }, {
    key: 'phi',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'theta',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'psi',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }

    // roll, pitch, yaw angle notation

  }, {
    key: 'roll',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'pitch',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'yaw',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }

    // rotation order, in all three angle notations

  }, {
    key: 'order',
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = checkOrder(value);
    }
  }]);

  return Euler;
}(_mathArray2.default);

exports.default = Euler;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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