'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _common = require('./common');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _extendableBuiltin(cls) {
  function ExtendableBuiltin() {
    var instance = Reflect.construct(cls, Array.from(arguments));
    Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
    return instance;
  }

  ExtendableBuiltin.prototype = Object.create(cls.prototype, {
    constructor: {
      value: cls,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(ExtendableBuiltin, cls);
  } else {
    ExtendableBuiltin.__proto__ = cls;
  }

  return ExtendableBuiltin;
} // Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var MathArray = function (_extendableBuiltin2) {
  _inherits(MathArray, _extendableBuiltin2);

  function MathArray() {
    _classCallCheck(this, MathArray);

    return _possibleConstructorReturn(this, (MathArray.__proto__ || Object.getPrototypeOf(MathArray)).apply(this, arguments));
  }

  _createClass(MathArray, [{
    key: 'clone',
    value: function clone() {
      var Subclass = this.constructor;
      var clone = new Subclass().copy(this);
      clone.check();
      return clone;
    }
  }, {
    key: 'copy',
    value: function copy(array) {
      for (var i = 0; i < this.ELEMENTS; ++i) {
        this[i] = array[i];
      }
      return this.check();
    }
  }, {
    key: 'set',
    value: function set() {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      for (var i = 0; i < this.ELEMENTS; ++i) {
        this[i] = args[i] || 0;
      }
      return this.check();
    }
  }, {
    key: 'fromArray',
    value: function fromArray(array) {
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      for (var i = 0; i < this.ELEMENTS; ++i) {
        this[i] = array[i + offset];
      }
      return this.check();
    }
  }, {
    key: 'toString',
    value: function toString() {
      return this.formatString(_common.config);
    }
  }, {
    key: 'formatString',
    value: function formatString(opts) {
      var string = '';
      for (var i = 0; i < this.ELEMENTS; ++i) {
        string += (i > 0 ? ', ' : '') + (0, _common.formatValue)(this[i], opts);
      }
      return (opts.printTypes ? this.constructor.name : '') + '[' + string + ']';
    }
  }, {
    key: 'toArray',
    value: function toArray() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      for (var i = 0; i < this.ELEMENTS; ++i) {
        array[offset + i] = this[i];
      }
      return array;
    }
  }, {
    key: 'toFloat32Array',
    value: function toFloat32Array() {
      return new Float32Array(this);
    }
  }, {
    key: 'equals',
    value: function equals(array) {
      if (!array || this.length !== array.length) {
        return false;
      }
      for (var i = 0; i < this.ELEMENTS; ++i) {
        if (!(0, _common.equals)(this[i], array[i])) {
          return false;
        }
      }
      return true;
    }
  }, {
    key: 'exactEquals',
    value: function exactEquals(array) {
      if (!array || this.length !== array.length) {
        return false;
      }
      for (var i = 0; i < this.ELEMENTS; ++i) {
        if (this[i] !== array[i]) {
          return false;
        }
      }
      return true;
    }

    // Modifiers

  }, {
    key: 'negate',
    value: function negate() {
      for (var i = 0; i < this.ELEMENTS; ++i) {
        this[i] = -this[i];
      }
      return this.check();
    }
  }, {
    key: 'inverse',
    value: function inverse() {
      for (var i = 0; i < this.ELEMENTS; ++i) {
        this[i] = 1 / this[i];
      }
      return this.check();
    }
  }, {
    key: 'lerp',
    value: function lerp(vector, coeff) {
      for (var i = 0; i < this.ELEMENTS; ++i) {
        var coord = this[i];
        this[i] = coord + coeff * (vector[0] - coord);
      }
      return this.check();
    }

    // Debug checks

  }, {
    key: 'validate',
    value: function validate() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this;

      var valid = array && array.length === this.ELEMENTS;
      for (var i = 0; i < this.ELEMENTS; ++i) {
        valid = valid && Number.isFinite(array[i]);
      }
      return valid;
    }
  }, {
    key: 'check',
    value: function check() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this;

      if (_common.config.debug && !this.validate(array)) {
        throw new Error('Invalid ' + this.constructor.name);
      }
      return this;
    }
  }]);

  return MathArray;
}(_extendableBuiltin(Array));

exports.default = MathArray;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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