'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.validateMatrix4 = validateMatrix4;

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

var _vector = require('./vector2');

var _vector2 = _interopRequireDefault(_vector);

var _vector3 = require('./vector3');

var _vector4 = _interopRequireDefault(_vector3);

var _vector5 = require('./vector4');

var _vector6 = _interopRequireDefault(_vector5);

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

var _determinant = require('gl-mat4/determinant');

var _determinant2 = _interopRequireDefault(_determinant);

var _fromQuat = require('gl-mat4/fromQuat');

var _fromQuat2 = _interopRequireDefault(_fromQuat);

var _frustum = require('gl-mat4/frustum');

var _frustum2 = _interopRequireDefault(_frustum);

var _lookAt = require('gl-mat4/lookAt');

var _lookAt2 = _interopRequireDefault(_lookAt);

var _ortho = require('gl-mat4/ortho');

var _ortho2 = _interopRequireDefault(_ortho);

var _perspective = require('gl-mat4/perspective');

var _perspective2 = _interopRequireDefault(_perspective);

var _transpose = require('gl-mat4/transpose');

var _transpose2 = _interopRequireDefault(_transpose);

var _invert = require('gl-mat4/invert');

var _invert2 = _interopRequireDefault(_invert);

var _multiply = require('gl-mat4/multiply');

var _multiply2 = _interopRequireDefault(_multiply);

var _rotateX = require('gl-mat4/rotateX');

var _rotateX2 = _interopRequireDefault(_rotateX);

var _rotateY = require('gl-mat4/rotateY');

var _rotateY2 = _interopRequireDefault(_rotateY);

var _rotateZ = require('gl-mat4/rotateZ');

var _rotateZ2 = _interopRequireDefault(_rotateZ);

var _scale = require('gl-mat4/scale');

var _scale2 = _interopRequireDefault(_scale);

var _translate = require('gl-mat4/translate');

var _translate2 = _interopRequireDefault(_translate);

var _transformMat = require('gl-vec2/transformMat4');

var _transformMat2 = _interopRequireDefault(_transformMat);

var _transformMat3 = require('gl-vec3/transformMat4');

var _transformMat4 = _interopRequireDefault(_transformMat3);

var _transformMat5 = require('gl-vec4/transformMat4');

var _transformMat6 = _interopRequireDefault(_transformMat5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// gl-matrix is too big. Cherry-pick individual imports from stack.gl version
/* eslint-disable camelcase */


var IDENTITY = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];

function validateMatrix4(m) {
  return m.length === 16 && Number.isFinite(m[0]) && Number.isFinite(m[1]) && Number.isFinite(m[2]) && Number.isFinite(m[3]) && Number.isFinite(m[4]) && Number.isFinite(m[5]) && Number.isFinite(m[6]) && Number.isFinite(m[7]) && Number.isFinite(m[8]) && Number.isFinite(m[9]) && Number.isFinite(m[10]) && Number.isFinite(m[11]) && Number.isFinite(m[12]) && Number.isFinite(m[13]) && Number.isFinite(m[14]) && Number.isFinite(m[15]);
}

var tempVector4 = [0, 0, 0, 0];

var Matrix4 = function (_MathArray) {
  _inherits(Matrix4, _MathArray);

  function Matrix4() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _classCallCheck(this, Matrix4);

    var _this = _possibleConstructorReturn(this, (Matrix4.__proto__ || Object.getPrototypeOf(Matrix4)).call(this));

    if (Array.isArray(args[0]) && arguments.length === 1) {
      _this.copy(args[0]);
    } else {
      _this.identity();
    }
    return _this;
  }

  _createClass(Matrix4, [{
    key: 'setRowMajor',


    /* eslint-disable max-params */
    value: function setRowMajor() {
      var m00 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var m10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var m20 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var m30 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var m01 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
      var m11 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
      var m21 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
      var m31 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
      var m02 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
      var m12 = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : 0;
      var m22 = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 1;
      var m32 = arguments.length > 11 && arguments[11] !== undefined ? arguments[11] : 0;
      var m03 = arguments.length > 12 && arguments[12] !== undefined ? arguments[12] : 0;
      var m13 = arguments.length > 13 && arguments[13] !== undefined ? arguments[13] : 0;
      var m23 = arguments.length > 14 && arguments[14] !== undefined ? arguments[14] : 0;
      var m33 = arguments.length > 15 && arguments[15] !== undefined ? arguments[15] : 1;

      return this.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }
  }, {
    key: 'setColumnMajor',
    value: function setColumnMajor() {
      var m00 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var m01 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var m02 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var m03 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var m10 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
      var m11 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
      var m12 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
      var m13 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
      var m20 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
      var m21 = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : 0;
      var m22 = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 1;
      var m23 = arguments.length > 11 && arguments[11] !== undefined ? arguments[11] : 0;
      var m30 = arguments.length > 12 && arguments[12] !== undefined ? arguments[12] : 0;
      var m31 = arguments.length > 13 && arguments[13] !== undefined ? arguments[13] : 0;
      var m32 = arguments.length > 14 && arguments[14] !== undefined ? arguments[14] : 0;
      var m33 = arguments.length > 15 && arguments[15] !== undefined ? arguments[15] : 1;

      return this.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }
  }, {
    key: 'set',
    value: function set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
      this[0] = m00;
      this[1] = m01;
      this[2] = m02;
      this[3] = m03;
      this[4] = m10;
      this[5] = m11;
      this[6] = m12;
      this[7] = m13;
      this[8] = m20;
      this[9] = m21;
      this[10] = m22;
      this[11] = m23;
      this[12] = m30;
      this[13] = m31;
      this[14] = m32;
      this[15] = m33;
      this.check();
      return this;
    }
    /* eslint-enable max-params */

    // toString() {
    //   if (config.printRowMajor) {
    //     mat4_str(this);
    //   } else {
    //     mat4_str(this);
    //   }
    // }

    // Row major setters and getters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'determinant',

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    // Accessors

    value: function determinant() {
      return (0, _determinant2.default)(this);
    }

    // Constructors

  }, {
    key: 'identity',
    value: function identity() {
      for (var i = 0; i < IDENTITY.length; ++i) {
        this[i] = IDENTITY[i];
      }
      this.check();
      return this;
    }

    // Calculates a 4x4 matrix from the given quaternion
    // q quat  Quaternion to create matrix from

  }, {
    key: 'fromQuaternion',
    value: function fromQuaternion(q) {
      (0, _fromQuat2.default)(this, q);
      this.check();
      return this;
    }

    // Generates a frustum matrix with the given bounds
    // left  Number  Left bound of the frustum
    // right Number  Right bound of the frustum
    // bottom  Number  Bottom bound of the frustum
    // top Number  Top bound of the frustum
    // near  Number  Near bound of the frustum
    // far Number  Far bound of the frustum

  }, {
    key: 'frustum',
    value: function frustum(_ref) {
      var left = _ref.left,
          right = _ref.right,
          bottom = _ref.bottom,
          top = _ref.top,
          near = _ref.near,
          far = _ref.far;

      (0, _frustum2.default)(this, left, right, bottom, top, near, far);
      this.check();
      return this;
    }

    // Generates a look-at matrix with the given eye position, focal point,
    // and up axis
    // eye vec3  Position of the viewer
    // center  vec3  Point the viewer is looking at
    // up  vec3  vec3 pointing up

  }, {
    key: 'lookAt',
    value: function lookAt() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          eye = _ref2.eye,
          _ref2$center = _ref2.center,
          center = _ref2$center === undefined ? [0, 0, 0] : _ref2$center,
          _ref2$up = _ref2.up,
          up = _ref2$up === undefined ? [0, 1, 0] : _ref2$up;

      (0, _lookAt2.default)(this, eye, center, up);
      this.check();
      return this;
    }

    // Generates a orthogonal projection matrix with the given bounds
    // left  number  Left bound of the frustum
    // right number  Right bound of the frustum
    // bottom  number  Bottom bound of the frustum
    // top number  Top bound of the frustum
    // near  number  Near bound of the frustum
    // far number  Far bound of the frustum

  }, {
    key: 'ortho',
    value: function ortho(_ref3) {
      var left = _ref3.left,
          right = _ref3.right,
          bottom = _ref3.bottom,
          top = _ref3.top,
          _ref3$near = _ref3.near,
          near = _ref3$near === undefined ? 0.1 : _ref3$near,
          _ref3$far = _ref3.far,
          far = _ref3$far === undefined ? 500 : _ref3$far;

      (0, _ortho2.default)(this, left, right, bottom, top, near, far);
      this.check();
      return this;
    }

    // Generates a perspective projection matrix with the given bounds
    // fovy  number  Vertical field of view in radians
    // aspect  number  Aspect ratio. typically viewport width/height
    // near  number  Near bound of the frustum
    // far number  Far bound of the frustum

  }, {
    key: 'perspective',
    value: function perspective() {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref4$fov = _ref4.fov,
          fov = _ref4$fov === undefined ? 45 * Math.PI / 180 : _ref4$fov,
          _ref4$aspect = _ref4.aspect,
          aspect = _ref4$aspect === undefined ? 1 : _ref4$aspect,
          _ref4$near = _ref4.near,
          near = _ref4$near === undefined ? 0.1 : _ref4$near,
          _ref4$far = _ref4.far,
          far = _ref4$far === undefined ? 500 : _ref4$far;

      if (fov > Math.PI * 2) {
        throw Error('radians');
      }
      (0, _perspective2.default)(this, fov, aspect, near, far);
      this.check();
      return this;
    }

    // Modifiers

  }, {
    key: 'transpose',
    value: function transpose() {
      (0, _transpose2.default)(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'invert',
    value: function invert() {
      (0, _invert2.default)(this, this);
      this.check();
      return this;
    }

    // Operations

  }, {
    key: 'multiplyLeft',
    value: function multiplyLeft(a) {
      (0, _multiply2.default)(this, a, this);
      this.check();
      return this;
    }
  }, {
    key: 'multiplyRight',
    value: function multiplyRight(a) {
      (0, _multiply2.default)(this, this, a);
      this.check();
      return this;
    }

    // Rotates a matrix by the given angle around the X axis

  }, {
    key: 'rotateX',
    value: function rotateX(radians) {
      (0, _rotateX2.default)(this, this, radians);
      this.check();
      return this;
    }

    // Rotates a matrix by the given angle around the Y axis.

  }, {
    key: 'rotateY',
    value: function rotateY(radians) {
      (0, _rotateY2.default)(this, this, radians);
      this.check();
      return this;
    }

    // Rotates a matrix by the given angle around the Z axis.

  }, {
    key: 'rotateZ',
    value: function rotateZ(radians) {
      (0, _rotateZ2.default)(this, this, radians);
      this.check();
      return this;
    }
  }, {
    key: 'rotateXYZ',
    value: function rotateXYZ(_ref5) {
      var _ref6 = _slicedToArray(_ref5, 3),
          rx = _ref6[0],
          ry = _ref6[1],
          rz = _ref6[2];

      return this.rotateX(rx).rotateY(ry).rotateZ(rz);
    }
  }, {
    key: 'rotateAxis',
    value: function rotateAxis(radians, axis) {
      (0, _rotateZ2.default)(this, this, radians, axis);
      this.check();
      return this;
    }
  }, {
    key: 'scale',
    value: function scale(vec) {
      (0, _scale2.default)(this, this, vec);
      this.check();
      return this;
    }
  }, {
    key: 'translate',
    value: function translate(vec) {
      (0, _translate2.default)(this, this, vec);
      this.check();
      return this;
    }
  }, {
    key: 'transformVector2',
    value: function transformVector2(vector, out) {
      out = out || new _vector2.default();
      (0, _transformMat2.default)(out, vector, this);
      (0, _assert2.default)((0, _vector.validateVector2)(out));
      return out;
    }
  }, {
    key: 'transformVector3',
    value: function transformVector3(vector) {
      var out = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new _vector4.default();

      out = out || new _vector4.default();
      (0, _transformMat4.default)(out, vector, this);
      (0, _assert2.default)((0, _vector3.validateVector3)(out));
      return out;
    }
  }, {
    key: 'transformVector4',
    value: function transformVector4(vector) {
      var out = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new _vector6.default();

      out = out || new _vector6.default();
      (0, _transformMat6.default)(out, vector, this);
      (0, _assert2.default)((0, _vector5.validateVector4)(out));
      return out;
    }

    // Transforms any 2, 3 or 4 element vector
    // returns a newly minted Vector2, Vector3 or Vector4

  }, {
    key: 'transformVector',
    value: function transformVector(vector, out) {
      switch (vector.length) {
        case 2:
          return this.transformVector2(vector, out);
        case 3:
          return this.transformVector3(vector, out);
        case 4:
          return this.transformVector4(vector, out);
        default:
          throw new Error('Illegal vector');
      }
    }
  }, {
    key: 'transformDirection',
    value: function transformDirection(vector, out) {
      switch (vector.length) {
        case 2:
          (0, _transformMat6.default)(tempVector4, [vector[0], vector[1], 0, 0], this);
          out = out || new _vector2.default();
          out[0] = tempVector4[0];
          out[1] = tempVector4[1];

          break;
        case 3:
          (0, _transformMat6.default)(tempVector4, [vector[0], vector[1], vector[2], 0], this);
          out = out || new _vector4.default();
          out[0] = tempVector4[0];
          out[1] = tempVector4[1];
          out[2] = tempVector4[2];

          break;
        case 4:
          (0, _assert2.default)(vector[3] === 0);
          out = out || new _vector6.default();
          (0, _transformMat6.default)(out, vector, this);
          break;
        default:
          throw new Error('Illegal vector');
      }
      return out;
    }
  }, {
    key: 'transformPoint',
    value: function transformPoint(vector, out) {
      switch (vector.length) {
        case 2:
          out = out || new _vector2.default();
          (0, _transformMat6.default)(out, [vector[0], vector[1], 0, 1], this);
          out.length = 2;
          (0, _assert2.default)((0, _vector.validateVector2)(out));
          break;
        case 3:
          out = out || new _vector4.default();
          (0, _transformMat6.default)(out, [vector[0], vector[1], vector[2], 1], this);
          out.length = 3;
          (0, _assert2.default)((0, _vector3.validateVector3)(out));
          break;
        case 4:
          (0, _assert2.default)(vector[3] !== 0);
          out = out || new _vector6.default();
          (0, _transformMat6.default)(out, vector, this);
          (0, _assert2.default)((0, _vector5.validateVector4)(out));
          break;
        default:
          throw new Error('Illegal vector');
      }
      return out;
    }
  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 16;
    }
  }, {
    key: 'm00',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm01',
    get: function get() {
      return this[4];
    },
    set: function set(value) {
      return this[4] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm02',
    get: function get() {
      return this[8];
    },
    set: function set(value) {
      return this[8] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm03',
    get: function get() {
      return this[12];
    },
    set: function set(value) {
      return this[12] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm10',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm11',
    get: function get() {
      return this[5];
    },
    set: function set(value) {
      return this[5] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm12',
    get: function get() {
      return this[9];
    },
    set: function set(value) {
      return this[9] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm13',
    get: function get() {
      return this[13];
    },
    set: function set(value) {
      return this[13] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm20',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm21',
    get: function get() {
      return this[6];
    },
    set: function set(value) {
      return this[6] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm22',
    get: function get() {
      return this[10];
    },
    set: function set(value) {
      return this[10] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm23',
    get: function get() {
      return this[14];
    },
    set: function set(value) {
      return this[14] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm30',
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm31',
    get: function get() {
      return this[7];
    },
    set: function set(value) {
      return this[7] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm32',
    get: function get() {
      return this[11];
    },
    set: function set(value) {
      return this[11] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm33',
    get: function get() {
      return this[15];
    },
    set: function set(value) {
      return this[15] = (0, _common.checkNumber)(value);
    }
  }]);

  return Matrix4;
}(_mathArray2.default);

exports.default = Matrix4;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9tYXRyaXg0LmpzIl0sIm5hbWVzIjpbInZhbGlkYXRlTWF0cml4NCIsIklERU5USVRZIiwibSIsImxlbmd0aCIsIk51bWJlciIsImlzRmluaXRlIiwidGVtcFZlY3RvcjQiLCJNYXRyaXg0IiwiYXJncyIsIkFycmF5IiwiaXNBcnJheSIsImFyZ3VtZW50cyIsImNvcHkiLCJpZGVudGl0eSIsIm0wMCIsIm0xMCIsIm0yMCIsIm0zMCIsIm0wMSIsIm0xMSIsIm0yMSIsIm0zMSIsIm0wMiIsIm0xMiIsIm0yMiIsIm0zMiIsIm0wMyIsIm0xMyIsIm0yMyIsIm0zMyIsInNldCIsImNoZWNrIiwiaSIsInEiLCJsZWZ0IiwicmlnaHQiLCJib3R0b20iLCJ0b3AiLCJuZWFyIiwiZmFyIiwiZXllIiwiY2VudGVyIiwidXAiLCJmb3YiLCJNYXRoIiwiUEkiLCJhc3BlY3QiLCJFcnJvciIsImEiLCJyYWRpYW5zIiwicngiLCJyeSIsInJ6Iiwicm90YXRlWCIsInJvdGF0ZVkiLCJyb3RhdGVaIiwiYXhpcyIsInZlYyIsInZlY3RvciIsIm91dCIsInRyYW5zZm9ybVZlY3RvcjIiLCJ0cmFuc2Zvcm1WZWN0b3IzIiwidHJhbnNmb3JtVmVjdG9yNCIsInZhbHVlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O1FBa0RnQkEsZSxHQUFBQSxlOztBQTlCaEI7Ozs7QUFDQTs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUlBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUVBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7Ozs7Ozs7K2VBOUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQVNBO0FBQ0E7OztBQW9CQSxJQUFNQyxXQUFXLENBQUMsQ0FBRCxFQUFJLENBQUosRUFBTyxDQUFQLEVBQVUsQ0FBVixFQUFhLENBQWIsRUFBZ0IsQ0FBaEIsRUFBbUIsQ0FBbkIsRUFBc0IsQ0FBdEIsRUFBeUIsQ0FBekIsRUFBNEIsQ0FBNUIsRUFBK0IsQ0FBL0IsRUFBa0MsQ0FBbEMsRUFBcUMsQ0FBckMsRUFBd0MsQ0FBeEMsRUFBMkMsQ0FBM0MsRUFBOEMsQ0FBOUMsQ0FBakI7O0FBRU8sU0FBU0QsZUFBVCxDQUF5QkUsQ0FBekIsRUFBNEI7QUFDakMsU0FBT0EsRUFBRUMsTUFBRixLQUFhLEVBQWIsSUFDTEMsT0FBT0MsUUFBUCxDQUFnQkgsRUFBRSxDQUFGLENBQWhCLENBREssSUFDb0JFLE9BQU9DLFFBQVAsQ0FBZ0JILEVBQUUsQ0FBRixDQUFoQixDQURwQixJQUVMRSxPQUFPQyxRQUFQLENBQWdCSCxFQUFFLENBQUYsQ0FBaEIsQ0FGSyxJQUVvQkUsT0FBT0MsUUFBUCxDQUFnQkgsRUFBRSxDQUFGLENBQWhCLENBRnBCLElBR0xFLE9BQU9DLFFBQVAsQ0FBZ0JILEVBQUUsQ0FBRixDQUFoQixDQUhLLElBR29CRSxPQUFPQyxRQUFQLENBQWdCSCxFQUFFLENBQUYsQ0FBaEIsQ0FIcEIsSUFJTEUsT0FBT0MsUUFBUCxDQUFnQkgsRUFBRSxDQUFGLENBQWhCLENBSkssSUFJb0JFLE9BQU9DLFFBQVAsQ0FBZ0JILEVBQUUsQ0FBRixDQUFoQixDQUpwQixJQUtMRSxPQUFPQyxRQUFQLENBQWdCSCxFQUFFLENBQUYsQ0FBaEIsQ0FMSyxJQUtvQkUsT0FBT0MsUUFBUCxDQUFnQkgsRUFBRSxDQUFGLENBQWhCLENBTHBCLElBTUxFLE9BQU9DLFFBQVAsQ0FBZ0JILEVBQUUsRUFBRixDQUFoQixDQU5LLElBTXFCRSxPQUFPQyxRQUFQLENBQWdCSCxFQUFFLEVBQUYsQ0FBaEIsQ0FOckIsSUFPTEUsT0FBT0MsUUFBUCxDQUFnQkgsRUFBRSxFQUFGLENBQWhCLENBUEssSUFPcUJFLE9BQU9DLFFBQVAsQ0FBZ0JILEVBQUUsRUFBRixDQUFoQixDQVByQixJQVFMRSxPQUFPQyxRQUFQLENBQWdCSCxFQUFFLEVBQUYsQ0FBaEIsQ0FSSyxJQVFxQkUsT0FBT0MsUUFBUCxDQUFnQkgsRUFBRSxFQUFGLENBQWhCLENBUjVCO0FBU0Q7O0FBRUQsSUFBTUksY0FBYyxDQUFDLENBQUQsRUFBSSxDQUFKLEVBQU8sQ0FBUCxFQUFVLENBQVYsQ0FBcEI7O0lBRXFCQyxPOzs7QUFDbkIscUJBQXFCO0FBQUEsc0NBQU5DLElBQU07QUFBTkEsVUFBTTtBQUFBOztBQUFBOztBQUFBOztBQUVuQixRQUFJQyxNQUFNQyxPQUFOLENBQWNGLEtBQUssQ0FBTCxDQUFkLEtBQTBCRyxVQUFVUixNQUFWLEtBQXFCLENBQW5ELEVBQXNEO0FBQ3BELFlBQUtTLElBQUwsQ0FBVUosS0FBSyxDQUFMLENBQVY7QUFDRCxLQUZELE1BRU87QUFDTCxZQUFLSyxRQUFMO0FBQ0Q7QUFOa0I7QUFPcEI7Ozs7OztBQU1EO2tDQU1FO0FBQUEsVUFKQUMsR0FJQSx1RUFKTSxDQUlOO0FBQUEsVUFKU0MsR0FJVCx1RUFKZSxDQUlmO0FBQUEsVUFKa0JDLEdBSWxCLHVFQUp3QixDQUl4QjtBQUFBLFVBSjJCQyxHQUkzQix1RUFKaUMsQ0FJakM7QUFBQSxVQUhBQyxHQUdBLHVFQUhNLENBR047QUFBQSxVQUhTQyxHQUdULHVFQUhlLENBR2Y7QUFBQSxVQUhrQkMsR0FHbEIsdUVBSHdCLENBR3hCO0FBQUEsVUFIMkJDLEdBRzNCLHVFQUhpQyxDQUdqQztBQUFBLFVBRkFDLEdBRUEsdUVBRk0sQ0FFTjtBQUFBLFVBRlNDLEdBRVQsdUVBRmUsQ0FFZjtBQUFBLFVBRmtCQyxHQUVsQiwwRUFGd0IsQ0FFeEI7QUFBQSxVQUYyQkMsR0FFM0IsMEVBRmlDLENBRWpDO0FBQUEsVUFEQUMsR0FDQSwwRUFETSxDQUNOO0FBQUEsVUFEU0MsR0FDVCwwRUFEZSxDQUNmO0FBQUEsVUFEa0JDLEdBQ2xCLDBFQUR3QixDQUN4QjtBQUFBLFVBRDJCQyxHQUMzQiwwRUFEaUMsQ0FDakM7O0FBQ0EsYUFBTyxLQUFLQyxHQUFMLENBQ0xoQixHQURLLEVBQ0FJLEdBREEsRUFDS0ksR0FETCxFQUNVSSxHQURWLEVBRUxYLEdBRkssRUFFQUksR0FGQSxFQUVLSSxHQUZMLEVBRVVJLEdBRlYsRUFHTFgsR0FISyxFQUdBSSxHQUhBLEVBR0tJLEdBSEwsRUFHVUksR0FIVixFQUlMWCxHQUpLLEVBSUFJLEdBSkEsRUFJS0ksR0FKTCxFQUlVSSxHQUpWLENBQVA7QUFNRDs7O3FDQU9DO0FBQUEsVUFKQWYsR0FJQSx1RUFKTSxDQUlOO0FBQUEsVUFKU0ksR0FJVCx1RUFKZSxDQUlmO0FBQUEsVUFKa0JJLEdBSWxCLHVFQUp3QixDQUl4QjtBQUFBLFVBSjJCSSxHQUkzQix1RUFKaUMsQ0FJakM7QUFBQSxVQUhBWCxHQUdBLHVFQUhNLENBR047QUFBQSxVQUhTSSxHQUdULHVFQUhlLENBR2Y7QUFBQSxVQUhrQkksR0FHbEIsdUVBSHdCLENBR3hCO0FBQUEsVUFIMkJJLEdBRzNCLHVFQUhpQyxDQUdqQztBQUFBLFVBRkFYLEdBRUEsdUVBRk0sQ0FFTjtBQUFBLFVBRlNJLEdBRVQsdUVBRmUsQ0FFZjtBQUFBLFVBRmtCSSxHQUVsQiwwRUFGd0IsQ0FFeEI7QUFBQSxVQUYyQkksR0FFM0IsMEVBRmlDLENBRWpDO0FBQUEsVUFEQVgsR0FDQSwwRUFETSxDQUNOO0FBQUEsVUFEU0ksR0FDVCwwRUFEZSxDQUNmO0FBQUEsVUFEa0JJLEdBQ2xCLDBFQUR3QixDQUN4QjtBQUFBLFVBRDJCSSxHQUMzQiwwRUFEaUMsQ0FDakM7O0FBQ0EsYUFBTyxLQUFLQyxHQUFMLENBQ0xoQixHQURLLEVBQ0FJLEdBREEsRUFDS0ksR0FETCxFQUNVSSxHQURWLEVBRUxYLEdBRkssRUFFQUksR0FGQSxFQUVLSSxHQUZMLEVBRVVJLEdBRlYsRUFHTFgsR0FISyxFQUdBSSxHQUhBLEVBR0tJLEdBSEwsRUFHVUksR0FIVixFQUlMWCxHQUpLLEVBSUFJLEdBSkEsRUFJS0ksR0FKTCxFQUlVSSxHQUpWLENBQVA7QUFNRDs7O3dCQUVHZixHLEVBQUtJLEcsRUFBS0ksRyxFQUFLSSxHLEVBQUtYLEcsRUFBS0ksRyxFQUFLSSxHLEVBQUtJLEcsRUFBS1gsRyxFQUFLSSxHLEVBQUtJLEcsRUFBS0ksRyxFQUFLWCxHLEVBQUtJLEcsRUFBS0ksRyxFQUFLSSxHLEVBQUs7QUFDbEYsV0FBSyxDQUFMLElBQVVmLEdBQVY7QUFDQSxXQUFLLENBQUwsSUFBVUksR0FBVjtBQUNBLFdBQUssQ0FBTCxJQUFVSSxHQUFWO0FBQ0EsV0FBSyxDQUFMLElBQVVJLEdBQVY7QUFDQSxXQUFLLENBQUwsSUFBVVgsR0FBVjtBQUNBLFdBQUssQ0FBTCxJQUFVSSxHQUFWO0FBQ0EsV0FBSyxDQUFMLElBQVVJLEdBQVY7QUFDQSxXQUFLLENBQUwsSUFBVUksR0FBVjtBQUNBLFdBQUssQ0FBTCxJQUFVWCxHQUFWO0FBQ0EsV0FBSyxDQUFMLElBQVVJLEdBQVY7QUFDQSxXQUFLLEVBQUwsSUFBV0ksR0FBWDtBQUNBLFdBQUssRUFBTCxJQUFXSSxHQUFYO0FBQ0EsV0FBSyxFQUFMLElBQVdYLEdBQVg7QUFDQSxXQUFLLEVBQUwsSUFBV0ksR0FBWDtBQUNBLFdBQUssRUFBTCxJQUFXSSxHQUFYO0FBQ0EsV0FBSyxFQUFMLElBQVdJLEdBQVg7QUFDQSxXQUFLRSxLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7QUFDRDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOzs7OztBQWlDQTs7QUFFQTs7a0NBRWM7QUFDWixhQUFPLDJCQUFpQixJQUFqQixDQUFQO0FBQ0Q7O0FBRUQ7Ozs7K0JBRVc7QUFDVCxXQUFLLElBQUlDLElBQUksQ0FBYixFQUFnQkEsSUFBSS9CLFNBQVNFLE1BQTdCLEVBQXFDLEVBQUU2QixDQUF2QyxFQUEwQztBQUN4QyxhQUFLQSxDQUFMLElBQVUvQixTQUFTK0IsQ0FBVCxDQUFWO0FBQ0Q7QUFDRCxXQUFLRCxLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7QUFDQTs7OzttQ0FDZUUsQyxFQUFHO0FBQ2hCLDhCQUFjLElBQWQsRUFBb0JBLENBQXBCO0FBQ0EsV0FBS0YsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7O2tDQUMrQztBQUFBLFVBQXRDRyxJQUFzQyxRQUF0Q0EsSUFBc0M7QUFBQSxVQUFoQ0MsS0FBZ0MsUUFBaENBLEtBQWdDO0FBQUEsVUFBekJDLE1BQXlCLFFBQXpCQSxNQUF5QjtBQUFBLFVBQWpCQyxHQUFpQixRQUFqQkEsR0FBaUI7QUFBQSxVQUFaQyxJQUFZLFFBQVpBLElBQVk7QUFBQSxVQUFOQyxHQUFNLFFBQU5BLEdBQU07O0FBQzdDLDZCQUFhLElBQWIsRUFBbUJMLElBQW5CLEVBQXlCQyxLQUF6QixFQUFnQ0MsTUFBaEMsRUFBd0NDLEdBQXhDLEVBQTZDQyxJQUE3QyxFQUFtREMsR0FBbkQ7QUFDQSxXQUFLUixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs2QkFLUTtBQUFBLHNGQUFKLEVBQUk7QUFBQSxVQUhOUyxHQUdNLFNBSE5BLEdBR007QUFBQSwrQkFGTkMsTUFFTTtBQUFBLFVBRk5BLE1BRU0sZ0NBRkcsQ0FBQyxDQUFELEVBQUksQ0FBSixFQUFPLENBQVAsQ0FFSDtBQUFBLDJCQUROQyxFQUNNO0FBQUEsVUFETkEsRUFDTSw0QkFERCxDQUFDLENBQUQsRUFBSSxDQUFKLEVBQU8sQ0FBUCxDQUNDOztBQUNOLDRCQUFZLElBQVosRUFBa0JGLEdBQWxCLEVBQXVCQyxNQUF2QixFQUErQkMsRUFBL0I7QUFDQSxXQUFLWCxLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7aUNBQ3lEO0FBQUEsVUFBbERHLElBQWtELFNBQWxEQSxJQUFrRDtBQUFBLFVBQTVDQyxLQUE0QyxTQUE1Q0EsS0FBNEM7QUFBQSxVQUFyQ0MsTUFBcUMsU0FBckNBLE1BQXFDO0FBQUEsVUFBN0JDLEdBQTZCLFNBQTdCQSxHQUE2QjtBQUFBLDZCQUF4QkMsSUFBd0I7QUFBQSxVQUF4QkEsSUFBd0IsOEJBQWpCLEdBQWlCO0FBQUEsNEJBQVpDLEdBQVk7QUFBQSxVQUFaQSxHQUFZLDZCQUFOLEdBQU07O0FBQ3ZELDJCQUFXLElBQVgsRUFBaUJMLElBQWpCLEVBQXVCQyxLQUF2QixFQUE4QkMsTUFBOUIsRUFBc0NDLEdBQXRDLEVBQTJDQyxJQUEzQyxFQUFpREMsR0FBakQ7QUFDQSxXQUFLUixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7OztrQ0FNUTtBQUFBLHNGQUFKLEVBQUk7QUFBQSw0QkFKTlksR0FJTTtBQUFBLFVBSk5BLEdBSU0sNkJBSkEsS0FBS0MsS0FBS0MsRUFBVixHQUFlLEdBSWY7QUFBQSwrQkFITkMsTUFHTTtBQUFBLFVBSE5BLE1BR00sZ0NBSEcsQ0FHSDtBQUFBLDZCQUZOUixJQUVNO0FBQUEsVUFGTkEsSUFFTSw4QkFGQyxHQUVEO0FBQUEsNEJBRE5DLEdBQ007QUFBQSxVQUROQSxHQUNNLDZCQURBLEdBQ0E7O0FBQ04sVUFBSUksTUFBTUMsS0FBS0MsRUFBTCxHQUFVLENBQXBCLEVBQXVCO0FBQ3JCLGNBQU1FLE1BQU0sU0FBTixDQUFOO0FBQ0Q7QUFDRCxpQ0FBaUIsSUFBakIsRUFBdUJKLEdBQXZCLEVBQTRCRyxNQUE1QixFQUFvQ1IsSUFBcEMsRUFBMENDLEdBQTFDO0FBQ0EsV0FBS1IsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEOzs7O2dDQUVZO0FBQ1YsK0JBQWUsSUFBZixFQUFxQixJQUFyQjtBQUNBLFdBQUtBLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzZCQUVRO0FBQ1AsNEJBQVksSUFBWixFQUFrQixJQUFsQjtBQUNBLFdBQUtBLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7QUFFRDs7OztpQ0FFYWlCLEMsRUFBRztBQUNkLDhCQUFjLElBQWQsRUFBb0JBLENBQXBCLEVBQXVCLElBQXZCO0FBQ0EsV0FBS2pCLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7O2tDQUVhaUIsQyxFQUFHO0FBQ2YsOEJBQWMsSUFBZCxFQUFvQixJQUFwQixFQUEwQkEsQ0FBMUI7QUFDQSxXQUFLakIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEOzs7OzRCQUNRa0IsTyxFQUFTO0FBQ2YsNkJBQWEsSUFBYixFQUFtQixJQUFuQixFQUF5QkEsT0FBekI7QUFDQSxXQUFLbEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEOzs7OzRCQUNRa0IsTyxFQUFTO0FBQ2YsNkJBQWEsSUFBYixFQUFtQixJQUFuQixFQUF5QkEsT0FBekI7QUFDQSxXQUFLbEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEOzs7OzRCQUNRa0IsTyxFQUFTO0FBQ2YsNkJBQWEsSUFBYixFQUFtQixJQUFuQixFQUF5QkEsT0FBekI7QUFDQSxXQUFLbEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7cUNBRXVCO0FBQUE7QUFBQSxVQUFibUIsRUFBYTtBQUFBLFVBQVRDLEVBQVM7QUFBQSxVQUFMQyxFQUFLOztBQUN0QixhQUFPLEtBQUtDLE9BQUwsQ0FBYUgsRUFBYixFQUFpQkksT0FBakIsQ0FBeUJILEVBQXpCLEVBQTZCSSxPQUE3QixDQUFxQ0gsRUFBckMsQ0FBUDtBQUNEOzs7K0JBRVVILE8sRUFBU08sSSxFQUFNO0FBQ3hCLDZCQUFZLElBQVosRUFBa0IsSUFBbEIsRUFBd0JQLE9BQXhCLEVBQWlDTyxJQUFqQztBQUNBLFdBQUt6QixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7OzswQkFFSzBCLEcsRUFBSztBQUNULDJCQUFXLElBQVgsRUFBaUIsSUFBakIsRUFBdUJBLEdBQXZCO0FBQ0EsV0FBSzFCLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzhCQUVTMEIsRyxFQUFLO0FBQ2IsK0JBQWUsSUFBZixFQUFxQixJQUFyQixFQUEyQkEsR0FBM0I7QUFDQSxXQUFLMUIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7cUNBRWdCMkIsTSxFQUFRQyxHLEVBQUs7QUFDNUJBLFlBQU1BLE9BQU8sc0JBQWI7QUFDQSxrQ0FBbUJBLEdBQW5CLEVBQXdCRCxNQUF4QixFQUFnQyxJQUFoQztBQUNBLDRCQUFPLDZCQUFnQkMsR0FBaEIsQ0FBUDtBQUNBLGFBQU9BLEdBQVA7QUFDRDs7O3FDQUVnQkQsTSxFQUE2QjtBQUFBLFVBQXJCQyxHQUFxQix1RUFBZixzQkFBZTs7QUFDNUNBLFlBQU1BLE9BQU8sc0JBQWI7QUFDQSxrQ0FBbUJBLEdBQW5CLEVBQXdCRCxNQUF4QixFQUFnQyxJQUFoQztBQUNBLDRCQUFPLDhCQUFnQkMsR0FBaEIsQ0FBUDtBQUNBLGFBQU9BLEdBQVA7QUFDRDs7O3FDQUVnQkQsTSxFQUE2QjtBQUFBLFVBQXJCQyxHQUFxQix1RUFBZixzQkFBZTs7QUFDNUNBLFlBQU1BLE9BQU8sc0JBQWI7QUFDQSxrQ0FBbUJBLEdBQW5CLEVBQXdCRCxNQUF4QixFQUFnQyxJQUFoQztBQUNBLDRCQUFPLDhCQUFnQkMsR0FBaEIsQ0FBUDtBQUNBLGFBQU9BLEdBQVA7QUFDRDs7QUFFRDtBQUNBOzs7O29DQUNnQkQsTSxFQUFRQyxHLEVBQUs7QUFDM0IsY0FBUUQsT0FBT3ZELE1BQWY7QUFDQSxhQUFLLENBQUw7QUFBUSxpQkFBTyxLQUFLeUQsZ0JBQUwsQ0FBc0JGLE1BQXRCLEVBQThCQyxHQUE5QixDQUFQO0FBQ1IsYUFBSyxDQUFMO0FBQVEsaUJBQU8sS0FBS0UsZ0JBQUwsQ0FBc0JILE1BQXRCLEVBQThCQyxHQUE5QixDQUFQO0FBQ1IsYUFBSyxDQUFMO0FBQVEsaUJBQU8sS0FBS0csZ0JBQUwsQ0FBc0JKLE1BQXRCLEVBQThCQyxHQUE5QixDQUFQO0FBQ1I7QUFBUyxnQkFBTSxJQUFJWixLQUFKLENBQVUsZ0JBQVYsQ0FBTjtBQUpUO0FBTUQ7Ozt1Q0FFa0JXLE0sRUFBUUMsRyxFQUFLO0FBQzlCLGNBQVFELE9BQU92RCxNQUFmO0FBQ0EsYUFBSyxDQUFMO0FBQ0Usc0NBQW1CRyxXQUFuQixFQUFnQyxDQUFDb0QsT0FBTyxDQUFQLENBQUQsRUFBWUEsT0FBTyxDQUFQLENBQVosRUFBdUIsQ0FBdkIsRUFBMEIsQ0FBMUIsQ0FBaEMsRUFBOEQsSUFBOUQ7QUFDQUMsZ0JBQU1BLE9BQU8sc0JBQWI7QUFDQ0EsY0FBSSxDQUFKLENBSEgsR0FHcUJyRCxXQUhyQjtBQUdXcUQsY0FBSSxDQUFKLENBSFgsR0FHcUJyRCxXQUhyQjs7QUFJRTtBQUNGLGFBQUssQ0FBTDtBQUNFLHNDQUFtQkEsV0FBbkIsRUFBZ0MsQ0FBQ29ELE9BQU8sQ0FBUCxDQUFELEVBQVlBLE9BQU8sQ0FBUCxDQUFaLEVBQXVCQSxPQUFPLENBQVAsQ0FBdkIsRUFBa0MsQ0FBbEMsQ0FBaEMsRUFBc0UsSUFBdEU7QUFDQUMsZ0JBQU1BLE9BQU8sc0JBQWI7QUFDQ0EsY0FBSSxDQUFKLENBSEgsR0FHNkJyRCxXQUg3QjtBQUdXcUQsY0FBSSxDQUFKLENBSFgsR0FHNkJyRCxXQUg3QjtBQUdtQnFELGNBQUksQ0FBSixDQUhuQixHQUc2QnJELFdBSDdCOztBQUlFO0FBQ0YsYUFBSyxDQUFMO0FBQ0UsZ0NBQU9vRCxPQUFPLENBQVAsTUFBYyxDQUFyQjtBQUNBQyxnQkFBTUEsT0FBTyxzQkFBYjtBQUNBLHNDQUFtQkEsR0FBbkIsRUFBd0JELE1BQXhCLEVBQWdDLElBQWhDO0FBQ0E7QUFDRjtBQUFTLGdCQUFNLElBQUlYLEtBQUosQ0FBVSxnQkFBVixDQUFOO0FBaEJUO0FBa0JBLGFBQU9ZLEdBQVA7QUFDRDs7O21DQUVjRCxNLEVBQVFDLEcsRUFBSztBQUMxQixjQUFRRCxPQUFPdkQsTUFBZjtBQUNBLGFBQUssQ0FBTDtBQUNFd0QsZ0JBQU1BLE9BQU8sc0JBQWI7QUFDQSxzQ0FBbUJBLEdBQW5CLEVBQXdCLENBQUNELE9BQU8sQ0FBUCxDQUFELEVBQVlBLE9BQU8sQ0FBUCxDQUFaLEVBQXVCLENBQXZCLEVBQTBCLENBQTFCLENBQXhCLEVBQXNELElBQXREO0FBQ0FDLGNBQUl4RCxNQUFKLEdBQWEsQ0FBYjtBQUNBLGdDQUFPLDZCQUFnQndELEdBQWhCLENBQVA7QUFDQTtBQUNGLGFBQUssQ0FBTDtBQUNFQSxnQkFBTUEsT0FBTyxzQkFBYjtBQUNBLHNDQUFtQkEsR0FBbkIsRUFBd0IsQ0FBQ0QsT0FBTyxDQUFQLENBQUQsRUFBWUEsT0FBTyxDQUFQLENBQVosRUFBdUJBLE9BQU8sQ0FBUCxDQUF2QixFQUFrQyxDQUFsQyxDQUF4QixFQUE4RCxJQUE5RDtBQUNBQyxjQUFJeEQsTUFBSixHQUFhLENBQWI7QUFDQSxnQ0FBTyw4QkFBZ0J3RCxHQUFoQixDQUFQO0FBQ0E7QUFDRixhQUFLLENBQUw7QUFDRSxnQ0FBT0QsT0FBTyxDQUFQLE1BQWMsQ0FBckI7QUFDQUMsZ0JBQU1BLE9BQU8sc0JBQWI7QUFDQSxzQ0FBbUJBLEdBQW5CLEVBQXdCRCxNQUF4QixFQUFnQyxJQUFoQztBQUNBLGdDQUFPLDhCQUFnQkMsR0FBaEIsQ0FBUDtBQUNBO0FBQ0Y7QUFDRSxnQkFBTSxJQUFJWixLQUFKLENBQVUsZ0JBQVYsQ0FBTjtBQXBCRjtBQXNCQSxhQUFPWSxHQUFQO0FBQ0Q7Ozt3QkE1VWM7QUFDYixhQUFPLEVBQVA7QUFDRDs7O3dCQStEYztBQUFFLGFBQU8sS0FBSyxDQUFMLENBQVA7QUFBaUIsSztzQkFDMUJJLEssRUFBTztBQUFFLGFBQU8sS0FBSyxDQUFMLElBQVUseUJBQVlBLEtBQVosQ0FBakI7QUFBc0M7Ozt3QkFDeEM7QUFBRSxhQUFPLEtBQUssQ0FBTCxDQUFQO0FBQWlCLEs7c0JBQzFCQSxLLEVBQU87QUFBRSxhQUFPLEtBQUssQ0FBTCxJQUFVLHlCQUFZQSxLQUFaLENBQWpCO0FBQXNDOzs7d0JBQ3hDO0FBQUUsYUFBTyxLQUFLLENBQUwsQ0FBUDtBQUFpQixLO3NCQUMxQkEsSyxFQUFPO0FBQUUsYUFBTyxLQUFLLENBQUwsSUFBVSx5QkFBWUEsS0FBWixDQUFqQjtBQUFzQzs7O3dCQUN4QztBQUFFLGFBQU8sS0FBSyxFQUFMLENBQVA7QUFBa0IsSztzQkFDM0JBLEssRUFBTztBQUFFLGFBQU8sS0FBSyxFQUFMLElBQVcseUJBQVlBLEtBQVosQ0FBbEI7QUFBdUM7Ozt3QkFDekM7QUFBRSxhQUFPLEtBQUssQ0FBTCxDQUFQO0FBQWlCLEs7c0JBQzFCQSxLLEVBQU87QUFBRSxhQUFPLEtBQUssQ0FBTCxJQUFVLHlCQUFZQSxLQUFaLENBQWpCO0FBQXNDOzs7d0JBQ3hDO0FBQUUsYUFBTyxLQUFLLENBQUwsQ0FBUDtBQUFpQixLO3NCQUMxQkEsSyxFQUFPO0FBQUUsYUFBTyxLQUFLLENBQUwsSUFBVSx5QkFBWUEsS0FBWixDQUFqQjtBQUFzQzs7O3dCQUN4QztBQUFFLGFBQU8sS0FBSyxDQUFMLENBQVA7QUFBaUIsSztzQkFDMUJBLEssRUFBTztBQUFFLGFBQU8sS0FBSyxDQUFMLElBQVUseUJBQVlBLEtBQVosQ0FBakI7QUFBc0M7Ozt3QkFDeEM7QUFBRSxhQUFPLEtBQUssRUFBTCxDQUFQO0FBQWtCLEs7c0JBQzNCQSxLLEVBQU87QUFBRSxhQUFPLEtBQUssRUFBTCxJQUFXLHlCQUFZQSxLQUFaLENBQWxCO0FBQXVDOzs7d0JBQ3pDO0FBQUUsYUFBTyxLQUFLLENBQUwsQ0FBUDtBQUFpQixLO3NCQUMxQkEsSyxFQUFPO0FBQUUsYUFBTyxLQUFLLENBQUwsSUFBVSx5QkFBWUEsS0FBWixDQUFqQjtBQUFzQzs7O3dCQUN4QztBQUFFLGFBQU8sS0FBSyxDQUFMLENBQVA7QUFBaUIsSztzQkFDMUJBLEssRUFBTztBQUFFLGFBQU8sS0FBSyxDQUFMLElBQVUseUJBQVlBLEtBQVosQ0FBakI7QUFBc0M7Ozt3QkFDeEM7QUFBRSxhQUFPLEtBQUssRUFBTCxDQUFQO0FBQWtCLEs7c0JBQzNCQSxLLEVBQU87QUFBRSxhQUFPLEtBQUssRUFBTCxJQUFXLHlCQUFZQSxLQUFaLENBQWxCO0FBQXVDOzs7d0JBQ3pDO0FBQUUsYUFBTyxLQUFLLEVBQUwsQ0FBUDtBQUFrQixLO3NCQUMzQkEsSyxFQUFPO0FBQUUsYUFBTyxLQUFLLEVBQUwsSUFBVyx5QkFBWUEsS0FBWixDQUFsQjtBQUF1Qzs7O3dCQUN6QztBQUFFLGFBQU8sS0FBSyxDQUFMLENBQVA7QUFBaUIsSztzQkFDMUJBLEssRUFBTztBQUFFLGFBQU8sS0FBSyxDQUFMLElBQVUseUJBQVlBLEtBQVosQ0FBakI7QUFBc0M7Ozt3QkFDeEM7QUFBRSxhQUFPLEtBQUssQ0FBTCxDQUFQO0FBQWlCLEs7c0JBQzFCQSxLLEVBQU87QUFBRSxhQUFPLEtBQUssQ0FBTCxJQUFVLHlCQUFZQSxLQUFaLENBQWpCO0FBQXNDOzs7d0JBQ3hDO0FBQUUsYUFBTyxLQUFLLEVBQUwsQ0FBUDtBQUFrQixLO3NCQUMzQkEsSyxFQUFPO0FBQUUsYUFBTyxLQUFLLEVBQUwsSUFBVyx5QkFBWUEsS0FBWixDQUFsQjtBQUF1Qzs7O3dCQUN6QztBQUFFLGFBQU8sS0FBSyxFQUFMLENBQVA7QUFBa0IsSztzQkFDM0JBLEssRUFBTztBQUFFLGFBQU8sS0FBSyxFQUFMLElBQVcseUJBQVlBLEtBQVosQ0FBbEI7QUFBdUM7Ozs7OztrQkExR3JDeEQsTyIsImZpbGUiOiJtYXRyaXg0LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSAyMDE3IFViZXIgVGVjaG5vbG9naWVzLCBJbmMuXG4vL1xuLy8gUGVybWlzc2lvbiBpcyBoZXJlYnkgZ3JhbnRlZCwgZnJlZSBvZiBjaGFyZ2UsIHRvIGFueSBwZXJzb24gb2J0YWluaW5nIGEgY29weVxuLy8gb2YgdGhpcyBzb2Z0d2FyZSBhbmQgYXNzb2NpYXRlZCBkb2N1bWVudGF0aW9uIGZpbGVzICh0aGUgXCJTb2Z0d2FyZVwiKSwgdG8gZGVhbFxuLy8gaW4gdGhlIFNvZnR3YXJlIHdpdGhvdXQgcmVzdHJpY3Rpb24sIGluY2x1ZGluZyB3aXRob3V0IGxpbWl0YXRpb24gdGhlIHJpZ2h0c1xuLy8gdG8gdXNlLCBjb3B5LCBtb2RpZnksIG1lcmdlLCBwdWJsaXNoLCBkaXN0cmlidXRlLCBzdWJsaWNlbnNlLCBhbmQvb3Igc2VsbFxuLy8gY29waWVzIG9mIHRoZSBTb2Z0d2FyZSwgYW5kIHRvIHBlcm1pdCBwZXJzb25zIHRvIHdob20gdGhlIFNvZnR3YXJlIGlzXG4vLyBmdXJuaXNoZWQgdG8gZG8gc28sIHN1YmplY3QgdG8gdGhlIGZvbGxvd2luZyBjb25kaXRpb25zOlxuLy9cbi8vIFRoZSBhYm92ZSBjb3B5cmlnaHQgbm90aWNlIGFuZCB0aGlzIHBlcm1pc3Npb24gbm90aWNlIHNoYWxsIGJlIGluY2x1ZGVkIGluXG4vLyBhbGwgY29waWVzIG9yIHN1YnN0YW50aWFsIHBvcnRpb25zIG9mIHRoZSBTb2Z0d2FyZS5cbi8vXG4vLyBUSEUgU09GVFdBUkUgSVMgUFJPVklERUQgXCJBUyBJU1wiLCBXSVRIT1VUIFdBUlJBTlRZIE9GIEFOWSBLSU5ELCBFWFBSRVNTIE9SXG4vLyBJTVBMSUVELCBJTkNMVURJTkcgQlVUIE5PVCBMSU1JVEVEIFRPIFRIRSBXQVJSQU5USUVTIE9GIE1FUkNIQU5UQUJJTElUWSxcbi8vIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuLy8gQVVUSE9SUyBPUiBDT1BZUklHSFQgSE9MREVSUyBCRSBMSUFCTEUgRk9SIEFOWSBDTEFJTSwgREFNQUdFUyBPUiBPVEhFUlxuLy8gTElBQklMSVRZLCBXSEVUSEVSIElOIEFOIEFDVElPTiBPRiBDT05UUkFDVCwgVE9SVCBPUiBPVEhFUldJU0UsIEFSSVNJTkcgRlJPTSxcbi8vIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbi8vIFRIRSBTT0ZUV0FSRS5cblxuaW1wb3J0IE1hdGhBcnJheSBmcm9tICcuL21hdGgtYXJyYXknO1xuaW1wb3J0IHtjaGVja051bWJlcn0gZnJvbSAnLi9jb21tb24nO1xuaW1wb3J0IFZlY3RvcjIsIHt2YWxpZGF0ZVZlY3RvcjJ9IGZyb20gJy4vdmVjdG9yMic7XG5pbXBvcnQgVmVjdG9yMywge3ZhbGlkYXRlVmVjdG9yM30gZnJvbSAnLi92ZWN0b3IzJztcbmltcG9ydCBWZWN0b3I0LCB7dmFsaWRhdGVWZWN0b3I0fSBmcm9tICcuL3ZlY3RvcjQnO1xuaW1wb3J0IGFzc2VydCBmcm9tICdhc3NlcnQnO1xuXG4vLyBnbC1tYXRyaXggaXMgdG9vIGJpZy4gQ2hlcnJ5LXBpY2sgaW5kaXZpZHVhbCBpbXBvcnRzIGZyb20gc3RhY2suZ2wgdmVyc2lvblxuLyogZXNsaW50LWRpc2FibGUgY2FtZWxjYXNlICovXG5pbXBvcnQgbWF0NF9kZXRlcm1pbmFudCBmcm9tICdnbC1tYXQ0L2RldGVybWluYW50JztcbmltcG9ydCBtYXQ0X2Zyb21RdWF0IGZyb20gJ2dsLW1hdDQvZnJvbVF1YXQnO1xuaW1wb3J0IG1hdDRfZnJ1c3R1bSBmcm9tICdnbC1tYXQ0L2ZydXN0dW0nO1xuaW1wb3J0IG1hdDRfbG9va0F0IGZyb20gJ2dsLW1hdDQvbG9va0F0JztcbmltcG9ydCBtYXQ0X29ydGhvIGZyb20gJ2dsLW1hdDQvb3J0aG8nO1xuaW1wb3J0IG1hdDRfcGVyc3BlY3RpdmUgZnJvbSAnZ2wtbWF0NC9wZXJzcGVjdGl2ZSc7XG5pbXBvcnQgbWF0NF90cmFuc3Bvc2UgZnJvbSAnZ2wtbWF0NC90cmFuc3Bvc2UnO1xuaW1wb3J0IG1hdDRfaW52ZXJ0IGZyb20gJ2dsLW1hdDQvaW52ZXJ0JztcbmltcG9ydCBtYXQ0X211bHRpcGx5IGZyb20gJ2dsLW1hdDQvbXVsdGlwbHknO1xuaW1wb3J0IG1hdDRfcm90YXRlWCBmcm9tICdnbC1tYXQ0L3JvdGF0ZVgnO1xuaW1wb3J0IG1hdDRfcm90YXRlWSBmcm9tICdnbC1tYXQ0L3JvdGF0ZVknO1xuaW1wb3J0IG1hdDRfcm90YXRlWiBmcm9tICdnbC1tYXQ0L3JvdGF0ZVonO1xuaW1wb3J0IG1hdDRfcm90YXRlIGZyb20gJ2dsLW1hdDQvcm90YXRlWic7XG5pbXBvcnQgbWF0NF9zY2FsZSBmcm9tICdnbC1tYXQ0L3NjYWxlJztcbmltcG9ydCBtYXQ0X3RyYW5zbGF0ZSBmcm9tICdnbC1tYXQ0L3RyYW5zbGF0ZSc7XG5pbXBvcnQgdmVjMl90cmFuc2Zvcm1NYXQ0IGZyb20gJ2dsLXZlYzIvdHJhbnNmb3JtTWF0NCc7XG5pbXBvcnQgdmVjM190cmFuc2Zvcm1NYXQ0IGZyb20gJ2dsLXZlYzMvdHJhbnNmb3JtTWF0NCc7XG5pbXBvcnQgdmVjNF90cmFuc2Zvcm1NYXQ0IGZyb20gJ2dsLXZlYzQvdHJhbnNmb3JtTWF0NCc7XG5cbmNvbnN0IElERU5USVRZID0gWzEsIDAsIDAsIDAsIDAsIDEsIDAsIDAsIDAsIDAsIDEsIDAsIDAsIDAsIDAsIDFdO1xuXG5leHBvcnQgZnVuY3Rpb24gdmFsaWRhdGVNYXRyaXg0KG0pIHtcbiAgcmV0dXJuIG0ubGVuZ3RoID09PSAxNiAmJlxuICAgIE51bWJlci5pc0Zpbml0ZShtWzBdKSAmJiBOdW1iZXIuaXNGaW5pdGUobVsxXSkgJiZcbiAgICBOdW1iZXIuaXNGaW5pdGUobVsyXSkgJiYgTnVtYmVyLmlzRmluaXRlKG1bM10pICYmXG4gICAgTnVtYmVyLmlzRmluaXRlKG1bNF0pICYmIE51bWJlci5pc0Zpbml0ZShtWzVdKSAmJlxuICAgIE51bWJlci5pc0Zpbml0ZShtWzZdKSAmJiBOdW1iZXIuaXNGaW5pdGUobVs3XSkgJiZcbiAgICBOdW1iZXIuaXNGaW5pdGUobVs4XSkgJiYgTnVtYmVyLmlzRmluaXRlKG1bOV0pICYmXG4gICAgTnVtYmVyLmlzRmluaXRlKG1bMTBdKSAmJiBOdW1iZXIuaXNGaW5pdGUobVsxMV0pICYmXG4gICAgTnVtYmVyLmlzRmluaXRlKG1bMTJdKSAmJiBOdW1iZXIuaXNGaW5pdGUobVsxM10pICYmXG4gICAgTnVtYmVyLmlzRmluaXRlKG1bMTRdKSAmJiBOdW1iZXIuaXNGaW5pdGUobVsxNV0pO1xufVxuXG5jb25zdCB0ZW1wVmVjdG9yNCA9IFswLCAwLCAwLCAwXTtcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTWF0cml4NCBleHRlbmRzIE1hdGhBcnJheSB7XG4gIGNvbnN0cnVjdG9yKC4uLmFyZ3MpIHtcbiAgICBzdXBlcigpO1xuICAgIGlmIChBcnJheS5pc0FycmF5KGFyZ3NbMF0pICYmIGFyZ3VtZW50cy5sZW5ndGggPT09IDEpIHtcbiAgICAgIHRoaXMuY29weShhcmdzWzBdKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5pZGVudGl0eSgpO1xuICAgIH1cbiAgfVxuXG4gIGdldCBFTEVNRU5UUygpIHtcbiAgICByZXR1cm4gMTY7XG4gIH1cblxuICAvKiBlc2xpbnQtZGlzYWJsZSBtYXgtcGFyYW1zICovXG4gIHNldFJvd01ham9yKFxuICAgIG0wMCA9IDEsIG0xMCA9IDAsIG0yMCA9IDAsIG0zMCA9IDAsXG4gICAgbTAxID0gMCwgbTExID0gMSwgbTIxID0gMCwgbTMxID0gMCxcbiAgICBtMDIgPSAwLCBtMTIgPSAwLCBtMjIgPSAxLCBtMzIgPSAwLFxuICAgIG0wMyA9IDAsIG0xMyA9IDAsIG0yMyA9IDAsIG0zMyA9IDFcbiAgKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0KFxuICAgICAgbTAwLCBtMDEsIG0wMiwgbTAzLFxuICAgICAgbTEwLCBtMTEsIG0xMiwgbTEzLFxuICAgICAgbTIwLCBtMjEsIG0yMiwgbTIzLFxuICAgICAgbTMwLCBtMzEsIG0zMiwgbTMzXG4gICAgKTtcbiAgfVxuXG4gIHNldENvbHVtbk1ham9yKFxuICAgIG0wMCA9IDEsIG0wMSA9IDAsIG0wMiA9IDAsIG0wMyA9IDAsXG4gICAgbTEwID0gMCwgbTExID0gMSwgbTEyID0gMCwgbTEzID0gMCxcbiAgICBtMjAgPSAwLCBtMjEgPSAwLCBtMjIgPSAxLCBtMjMgPSAwLFxuICAgIG0zMCA9IDAsIG0zMSA9IDAsIG0zMiA9IDAsIG0zMyA9IDFcbiAgKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0KFxuICAgICAgbTAwLCBtMDEsIG0wMiwgbTAzLFxuICAgICAgbTEwLCBtMTEsIG0xMiwgbTEzLFxuICAgICAgbTIwLCBtMjEsIG0yMiwgbTIzLFxuICAgICAgbTMwLCBtMzEsIG0zMiwgbTMzXG4gICAgKTtcbiAgfVxuXG4gIHNldChtMDAsIG0wMSwgbTAyLCBtMDMsIG0xMCwgbTExLCBtMTIsIG0xMywgbTIwLCBtMjEsIG0yMiwgbTIzLCBtMzAsIG0zMSwgbTMyLCBtMzMpIHtcbiAgICB0aGlzWzBdID0gbTAwO1xuICAgIHRoaXNbMV0gPSBtMDE7XG4gICAgdGhpc1syXSA9IG0wMjtcbiAgICB0aGlzWzNdID0gbTAzO1xuICAgIHRoaXNbNF0gPSBtMTA7XG4gICAgdGhpc1s1XSA9IG0xMTtcbiAgICB0aGlzWzZdID0gbTEyO1xuICAgIHRoaXNbN10gPSBtMTM7XG4gICAgdGhpc1s4XSA9IG0yMDtcbiAgICB0aGlzWzldID0gbTIxO1xuICAgIHRoaXNbMTBdID0gbTIyO1xuICAgIHRoaXNbMTFdID0gbTIzO1xuICAgIHRoaXNbMTJdID0gbTMwO1xuICAgIHRoaXNbMTNdID0gbTMxO1xuICAgIHRoaXNbMTRdID0gbTMyO1xuICAgIHRoaXNbMTVdID0gbTMzO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuICAvKiBlc2xpbnQtZW5hYmxlIG1heC1wYXJhbXMgKi9cblxuICAvLyB0b1N0cmluZygpIHtcbiAgLy8gICBpZiAoY29uZmlnLnByaW50Um93TWFqb3IpIHtcbiAgLy8gICAgIG1hdDRfc3RyKHRoaXMpO1xuICAvLyAgIH0gZWxzZSB7XG4gIC8vICAgICBtYXQ0X3N0cih0aGlzKTtcbiAgLy8gICB9XG4gIC8vIH1cblxuICAvLyBSb3cgbWFqb3Igc2V0dGVycyBhbmQgZ2V0dGVyc1xuICAvKiBlc2xpbnQtZGlzYWJsZSBuby1tdWx0aS1zcGFjZXMsIGJyYWNlLXN0eWxlLCBuby1yZXR1cm4tYXNzaWduICovXG4gIGdldCBtMDAoKSAgICAgIHsgcmV0dXJuIHRoaXNbMF07IH1cbiAgc2V0IG0wMCh2YWx1ZSkgeyByZXR1cm4gdGhpc1swXSA9IGNoZWNrTnVtYmVyKHZhbHVlKTsgfVxuICBnZXQgbTAxKCkgICAgICB7IHJldHVybiB0aGlzWzRdOyB9XG4gIHNldCBtMDEodmFsdWUpIHsgcmV0dXJuIHRoaXNbNF0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IG0wMigpICAgICAgeyByZXR1cm4gdGhpc1s4XTsgfVxuICBzZXQgbTAyKHZhbHVlKSB7IHJldHVybiB0aGlzWzhdID0gY2hlY2tOdW1iZXIodmFsdWUpOyB9XG4gIGdldCBtMDMoKSAgICAgIHsgcmV0dXJuIHRoaXNbMTJdOyB9XG4gIHNldCBtMDModmFsdWUpIHsgcmV0dXJuIHRoaXNbMTJdID0gY2hlY2tOdW1iZXIodmFsdWUpOyB9XG4gIGdldCBtMTAoKSAgICAgIHsgcmV0dXJuIHRoaXNbMV07IH1cbiAgc2V0IG0xMCh2YWx1ZSkgeyByZXR1cm4gdGhpc1sxXSA9IGNoZWNrTnVtYmVyKHZhbHVlKTsgfVxuICBnZXQgbTExKCkgICAgICB7IHJldHVybiB0aGlzWzVdOyB9XG4gIHNldCBtMTEodmFsdWUpIHsgcmV0dXJuIHRoaXNbNV0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IG0xMigpICAgICAgeyByZXR1cm4gdGhpc1s5XTsgfVxuICBzZXQgbTEyKHZhbHVlKSB7IHJldHVybiB0aGlzWzldID0gY2hlY2tOdW1iZXIodmFsdWUpOyB9XG4gIGdldCBtMTMoKSAgICAgIHsgcmV0dXJuIHRoaXNbMTNdOyB9XG4gIHNldCBtMTModmFsdWUpIHsgcmV0dXJuIHRoaXNbMTNdID0gY2hlY2tOdW1iZXIodmFsdWUpOyB9XG4gIGdldCBtMjAoKSAgICAgIHsgcmV0dXJuIHRoaXNbMl07IH1cbiAgc2V0IG0yMCh2YWx1ZSkgeyByZXR1cm4gdGhpc1syXSA9IGNoZWNrTnVtYmVyKHZhbHVlKTsgfVxuICBnZXQgbTIxKCkgICAgICB7IHJldHVybiB0aGlzWzZdOyB9XG4gIHNldCBtMjEodmFsdWUpIHsgcmV0dXJuIHRoaXNbNl0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IG0yMigpICAgICAgeyByZXR1cm4gdGhpc1sxMF07IH1cbiAgc2V0IG0yMih2YWx1ZSkgeyByZXR1cm4gdGhpc1sxMF0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IG0yMygpICAgICAgeyByZXR1cm4gdGhpc1sxNF07IH1cbiAgc2V0IG0yMyh2YWx1ZSkgeyByZXR1cm4gdGhpc1sxNF0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IG0zMCgpICAgICAgeyByZXR1cm4gdGhpc1szXTsgfVxuICBzZXQgbTMwKHZhbHVlKSB7IHJldHVybiB0aGlzWzNdID0gY2hlY2tOdW1iZXIodmFsdWUpOyB9XG4gIGdldCBtMzEoKSAgICAgIHsgcmV0dXJuIHRoaXNbN107IH1cbiAgc2V0IG0zMSh2YWx1ZSkgeyByZXR1cm4gdGhpc1s3XSA9IGNoZWNrTnVtYmVyKHZhbHVlKTsgfVxuICBnZXQgbTMyKCkgICAgICB7IHJldHVybiB0aGlzWzExXTsgfVxuICBzZXQgbTMyKHZhbHVlKSB7IHJldHVybiB0aGlzWzExXSA9IGNoZWNrTnVtYmVyKHZhbHVlKTsgfVxuICBnZXQgbTMzKCkgICAgICB7IHJldHVybiB0aGlzWzE1XTsgfVxuICBzZXQgbTMzKHZhbHVlKSB7IHJldHVybiB0aGlzWzE1XSA9IGNoZWNrTnVtYmVyKHZhbHVlKTsgfVxuICAvKiBlc2xpbnQtZW5hYmxlIG5vLW11bHRpLXNwYWNlcywgYnJhY2Utc3R5bGUsIG5vLXJldHVybi1hc3NpZ24gKi9cblxuICAvLyBBY2Nlc3NvcnNcblxuICBkZXRlcm1pbmFudCgpIHtcbiAgICByZXR1cm4gbWF0NF9kZXRlcm1pbmFudCh0aGlzKTtcbiAgfVxuXG4gIC8vIENvbnN0cnVjdG9yc1xuXG4gIGlkZW50aXR5KCkge1xuICAgIGZvciAobGV0IGkgPSAwOyBpIDwgSURFTlRJVFkubGVuZ3RoOyArK2kpIHtcbiAgICAgIHRoaXNbaV0gPSBJREVOVElUWVtpXTtcbiAgICB9XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gQ2FsY3VsYXRlcyBhIDR4NCBtYXRyaXggZnJvbSB0aGUgZ2l2ZW4gcXVhdGVybmlvblxuICAvLyBxIHF1YXQgIFF1YXRlcm5pb24gdG8gY3JlYXRlIG1hdHJpeCBmcm9tXG4gIGZyb21RdWF0ZXJuaW9uKHEpIHtcbiAgICBtYXQ0X2Zyb21RdWF0KHRoaXMsIHEpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIEdlbmVyYXRlcyBhIGZydXN0dW0gbWF0cml4IHdpdGggdGhlIGdpdmVuIGJvdW5kc1xuICAvLyBsZWZ0ICBOdW1iZXIgIExlZnQgYm91bmQgb2YgdGhlIGZydXN0dW1cbiAgLy8gcmlnaHQgTnVtYmVyICBSaWdodCBib3VuZCBvZiB0aGUgZnJ1c3R1bVxuICAvLyBib3R0b20gIE51bWJlciAgQm90dG9tIGJvdW5kIG9mIHRoZSBmcnVzdHVtXG4gIC8vIHRvcCBOdW1iZXIgIFRvcCBib3VuZCBvZiB0aGUgZnJ1c3R1bVxuICAvLyBuZWFyICBOdW1iZXIgIE5lYXIgYm91bmQgb2YgdGhlIGZydXN0dW1cbiAgLy8gZmFyIE51bWJlciAgRmFyIGJvdW5kIG9mIHRoZSBmcnVzdHVtXG4gIGZydXN0dW0oe2xlZnQsIHJpZ2h0LCBib3R0b20sIHRvcCwgbmVhciwgZmFyfSkge1xuICAgIG1hdDRfZnJ1c3R1bSh0aGlzLCBsZWZ0LCByaWdodCwgYm90dG9tLCB0b3AsIG5lYXIsIGZhcik7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gR2VuZXJhdGVzIGEgbG9vay1hdCBtYXRyaXggd2l0aCB0aGUgZ2l2ZW4gZXllIHBvc2l0aW9uLCBmb2NhbCBwb2ludCxcbiAgLy8gYW5kIHVwIGF4aXNcbiAgLy8gZXllIHZlYzMgIFBvc2l0aW9uIG9mIHRoZSB2aWV3ZXJcbiAgLy8gY2VudGVyICB2ZWMzICBQb2ludCB0aGUgdmlld2VyIGlzIGxvb2tpbmcgYXRcbiAgLy8gdXAgIHZlYzMgIHZlYzMgcG9pbnRpbmcgdXBcbiAgbG9va0F0KHtcbiAgICBleWUsXG4gICAgY2VudGVyID0gWzAsIDAsIDBdLFxuICAgIHVwID0gWzAsIDEsIDBdXG4gIH0gPSB7fSkge1xuICAgIG1hdDRfbG9va0F0KHRoaXMsIGV5ZSwgY2VudGVyLCB1cCk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gR2VuZXJhdGVzIGEgb3J0aG9nb25hbCBwcm9qZWN0aW9uIG1hdHJpeCB3aXRoIHRoZSBnaXZlbiBib3VuZHNcbiAgLy8gbGVmdCAgbnVtYmVyICBMZWZ0IGJvdW5kIG9mIHRoZSBmcnVzdHVtXG4gIC8vIHJpZ2h0IG51bWJlciAgUmlnaHQgYm91bmQgb2YgdGhlIGZydXN0dW1cbiAgLy8gYm90dG9tICBudW1iZXIgIEJvdHRvbSBib3VuZCBvZiB0aGUgZnJ1c3R1bVxuICAvLyB0b3AgbnVtYmVyICBUb3AgYm91bmQgb2YgdGhlIGZydXN0dW1cbiAgLy8gbmVhciAgbnVtYmVyICBOZWFyIGJvdW5kIG9mIHRoZSBmcnVzdHVtXG4gIC8vIGZhciBudW1iZXIgIEZhciBib3VuZCBvZiB0aGUgZnJ1c3R1bVxuICBvcnRobyh7bGVmdCwgcmlnaHQsIGJvdHRvbSwgdG9wLCBuZWFyID0gMC4xLCBmYXIgPSA1MDB9KSB7XG4gICAgbWF0NF9vcnRobyh0aGlzLCBsZWZ0LCByaWdodCwgYm90dG9tLCB0b3AsIG5lYXIsIGZhcik7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gR2VuZXJhdGVzIGEgcGVyc3BlY3RpdmUgcHJvamVjdGlvbiBtYXRyaXggd2l0aCB0aGUgZ2l2ZW4gYm91bmRzXG4gIC8vIGZvdnkgIG51bWJlciAgVmVydGljYWwgZmllbGQgb2YgdmlldyBpbiByYWRpYW5zXG4gIC8vIGFzcGVjdCAgbnVtYmVyICBBc3BlY3QgcmF0aW8uIHR5cGljYWxseSB2aWV3cG9ydCB3aWR0aC9oZWlnaHRcbiAgLy8gbmVhciAgbnVtYmVyICBOZWFyIGJvdW5kIG9mIHRoZSBmcnVzdHVtXG4gIC8vIGZhciBudW1iZXIgIEZhciBib3VuZCBvZiB0aGUgZnJ1c3R1bVxuICBwZXJzcGVjdGl2ZSh7XG4gICAgZm92ID0gNDUgKiBNYXRoLlBJIC8gMTgwLFxuICAgIGFzcGVjdCA9IDEsXG4gICAgbmVhciA9IDAuMSxcbiAgICBmYXIgPSA1MDBcbiAgfSA9IHt9KSB7XG4gICAgaWYgKGZvdiA+IE1hdGguUEkgKiAyKSB7XG4gICAgICB0aHJvdyBFcnJvcigncmFkaWFucycpO1xuICAgIH1cbiAgICBtYXQ0X3BlcnNwZWN0aXZlKHRoaXMsIGZvdiwgYXNwZWN0LCBuZWFyLCBmYXIpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIE1vZGlmaWVyc1xuXG4gIHRyYW5zcG9zZSgpIHtcbiAgICBtYXQ0X3RyYW5zcG9zZSh0aGlzLCB0aGlzKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBpbnZlcnQoKSB7XG4gICAgbWF0NF9pbnZlcnQodGhpcywgdGhpcyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gT3BlcmF0aW9uc1xuXG4gIG11bHRpcGx5TGVmdChhKSB7XG4gICAgbWF0NF9tdWx0aXBseSh0aGlzLCBhLCB0aGlzKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBtdWx0aXBseVJpZ2h0KGEpIHtcbiAgICBtYXQ0X211bHRpcGx5KHRoaXMsIHRoaXMsIGEpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIFJvdGF0ZXMgYSBtYXRyaXggYnkgdGhlIGdpdmVuIGFuZ2xlIGFyb3VuZCB0aGUgWCBheGlzXG4gIHJvdGF0ZVgocmFkaWFucykge1xuICAgIG1hdDRfcm90YXRlWCh0aGlzLCB0aGlzLCByYWRpYW5zKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvLyBSb3RhdGVzIGEgbWF0cml4IGJ5IHRoZSBnaXZlbiBhbmdsZSBhcm91bmQgdGhlIFkgYXhpcy5cbiAgcm90YXRlWShyYWRpYW5zKSB7XG4gICAgbWF0NF9yb3RhdGVZKHRoaXMsIHRoaXMsIHJhZGlhbnMpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIFJvdGF0ZXMgYSBtYXRyaXggYnkgdGhlIGdpdmVuIGFuZ2xlIGFyb3VuZCB0aGUgWiBheGlzLlxuICByb3RhdGVaKHJhZGlhbnMpIHtcbiAgICBtYXQ0X3JvdGF0ZVoodGhpcywgdGhpcywgcmFkaWFucyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgcm90YXRlWFlaKFtyeCwgcnksIHJ6XSkge1xuICAgIHJldHVybiB0aGlzLnJvdGF0ZVgocngpLnJvdGF0ZVkocnkpLnJvdGF0ZVoocnopO1xuICB9XG5cbiAgcm90YXRlQXhpcyhyYWRpYW5zLCBheGlzKSB7XG4gICAgbWF0NF9yb3RhdGUodGhpcywgdGhpcywgcmFkaWFucywgYXhpcyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgc2NhbGUodmVjKSB7XG4gICAgbWF0NF9zY2FsZSh0aGlzLCB0aGlzLCB2ZWMpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHRyYW5zbGF0ZSh2ZWMpIHtcbiAgICBtYXQ0X3RyYW5zbGF0ZSh0aGlzLCB0aGlzLCB2ZWMpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHRyYW5zZm9ybVZlY3RvcjIodmVjdG9yLCBvdXQpIHtcbiAgICBvdXQgPSBvdXQgfHwgbmV3IFZlY3RvcjIoKTtcbiAgICB2ZWMyX3RyYW5zZm9ybU1hdDQob3V0LCB2ZWN0b3IsIHRoaXMpO1xuICAgIGFzc2VydCh2YWxpZGF0ZVZlY3RvcjIob3V0KSk7XG4gICAgcmV0dXJuIG91dDtcbiAgfVxuXG4gIHRyYW5zZm9ybVZlY3RvcjModmVjdG9yLCBvdXQgPSBuZXcgVmVjdG9yMygpKSB7XG4gICAgb3V0ID0gb3V0IHx8IG5ldyBWZWN0b3IzKCk7XG4gICAgdmVjM190cmFuc2Zvcm1NYXQ0KG91dCwgdmVjdG9yLCB0aGlzKTtcbiAgICBhc3NlcnQodmFsaWRhdGVWZWN0b3IzKG91dCkpO1xuICAgIHJldHVybiBvdXQ7XG4gIH1cblxuICB0cmFuc2Zvcm1WZWN0b3I0KHZlY3Rvciwgb3V0ID0gbmV3IFZlY3RvcjQoKSkge1xuICAgIG91dCA9IG91dCB8fCBuZXcgVmVjdG9yNCgpO1xuICAgIHZlYzRfdHJhbnNmb3JtTWF0NChvdXQsIHZlY3RvciwgdGhpcyk7XG4gICAgYXNzZXJ0KHZhbGlkYXRlVmVjdG9yNChvdXQpKTtcbiAgICByZXR1cm4gb3V0O1xuICB9XG5cbiAgLy8gVHJhbnNmb3JtcyBhbnkgMiwgMyBvciA0IGVsZW1lbnQgdmVjdG9yXG4gIC8vIHJldHVybnMgYSBuZXdseSBtaW50ZWQgVmVjdG9yMiwgVmVjdG9yMyBvciBWZWN0b3I0XG4gIHRyYW5zZm9ybVZlY3Rvcih2ZWN0b3IsIG91dCkge1xuICAgIHN3aXRjaCAodmVjdG9yLmxlbmd0aCkge1xuICAgIGNhc2UgMjogcmV0dXJuIHRoaXMudHJhbnNmb3JtVmVjdG9yMih2ZWN0b3IsIG91dCk7XG4gICAgY2FzZSAzOiByZXR1cm4gdGhpcy50cmFuc2Zvcm1WZWN0b3IzKHZlY3Rvciwgb3V0KTtcbiAgICBjYXNlIDQ6IHJldHVybiB0aGlzLnRyYW5zZm9ybVZlY3RvcjQodmVjdG9yLCBvdXQpO1xuICAgIGRlZmF1bHQ6IHRocm93IG5ldyBFcnJvcignSWxsZWdhbCB2ZWN0b3InKTtcbiAgICB9XG4gIH1cblxuICB0cmFuc2Zvcm1EaXJlY3Rpb24odmVjdG9yLCBvdXQpIHtcbiAgICBzd2l0Y2ggKHZlY3Rvci5sZW5ndGgpIHtcbiAgICBjYXNlIDI6XG4gICAgICB2ZWM0X3RyYW5zZm9ybU1hdDQodGVtcFZlY3RvcjQsIFt2ZWN0b3JbMF0sIHZlY3RvclsxXSwgMCwgMF0sIHRoaXMpO1xuICAgICAgb3V0ID0gb3V0IHx8IG5ldyBWZWN0b3IyKCk7XG4gICAgICBbb3V0WzBdLCBvdXRbMV1dID0gdGVtcFZlY3RvcjQ7XG4gICAgICBicmVhaztcbiAgICBjYXNlIDM6XG4gICAgICB2ZWM0X3RyYW5zZm9ybU1hdDQodGVtcFZlY3RvcjQsIFt2ZWN0b3JbMF0sIHZlY3RvclsxXSwgdmVjdG9yWzJdLCAwXSwgdGhpcyk7XG4gICAgICBvdXQgPSBvdXQgfHwgbmV3IFZlY3RvcjMoKTtcbiAgICAgIFtvdXRbMF0sIG91dFsxXSwgb3V0WzJdXSA9IHRlbXBWZWN0b3I0O1xuICAgICAgYnJlYWs7XG4gICAgY2FzZSA0OlxuICAgICAgYXNzZXJ0KHZlY3RvclszXSA9PT0gMCk7XG4gICAgICBvdXQgPSBvdXQgfHwgbmV3IFZlY3RvcjQoKTtcbiAgICAgIHZlYzRfdHJhbnNmb3JtTWF0NChvdXQsIHZlY3RvciwgdGhpcyk7XG4gICAgICBicmVhaztcbiAgICBkZWZhdWx0OiB0aHJvdyBuZXcgRXJyb3IoJ0lsbGVnYWwgdmVjdG9yJyk7XG4gICAgfVxuICAgIHJldHVybiBvdXQ7XG4gIH1cblxuICB0cmFuc2Zvcm1Qb2ludCh2ZWN0b3IsIG91dCkge1xuICAgIHN3aXRjaCAodmVjdG9yLmxlbmd0aCkge1xuICAgIGNhc2UgMjpcbiAgICAgIG91dCA9IG91dCB8fCBuZXcgVmVjdG9yMigpO1xuICAgICAgdmVjNF90cmFuc2Zvcm1NYXQ0KG91dCwgW3ZlY3RvclswXSwgdmVjdG9yWzFdLCAwLCAxXSwgdGhpcyk7XG4gICAgICBvdXQubGVuZ3RoID0gMjtcbiAgICAgIGFzc2VydCh2YWxpZGF0ZVZlY3RvcjIob3V0KSk7XG4gICAgICBicmVhaztcbiAgICBjYXNlIDM6XG4gICAgICBvdXQgPSBvdXQgfHwgbmV3IFZlY3RvcjMoKTtcbiAgICAgIHZlYzRfdHJhbnNmb3JtTWF0NChvdXQsIFt2ZWN0b3JbMF0sIHZlY3RvclsxXSwgdmVjdG9yWzJdLCAxXSwgdGhpcyk7XG4gICAgICBvdXQubGVuZ3RoID0gMztcbiAgICAgIGFzc2VydCh2YWxpZGF0ZVZlY3RvcjMob3V0KSk7XG4gICAgICBicmVhaztcbiAgICBjYXNlIDQ6XG4gICAgICBhc3NlcnQodmVjdG9yWzNdICE9PSAwKTtcbiAgICAgIG91dCA9IG91dCB8fCBuZXcgVmVjdG9yNCgpO1xuICAgICAgdmVjNF90cmFuc2Zvcm1NYXQ0KG91dCwgdmVjdG9yLCB0aGlzKTtcbiAgICAgIGFzc2VydCh2YWxpZGF0ZVZlY3RvcjQob3V0KSk7XG4gICAgICBicmVhaztcbiAgICBkZWZhdWx0OlxuICAgICAgdGhyb3cgbmV3IEVycm9yKCdJbGxlZ2FsIHZlY3RvcicpO1xuICAgIH1cbiAgICByZXR1cm4gb3V0O1xuICB9XG59XG4iXX0=