'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.validateQuaternion = validateQuaternion;

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

var _fromMat = require('gl-quat/fromMat3');

var _fromMat2 = _interopRequireDefault(_fromMat);

var _identity = require('gl-quat/identity');

var _identity2 = _interopRequireDefault(_identity);

var _length = require('gl-quat/length');

var _length2 = _interopRequireDefault(_length);

var _squaredLength = require('gl-quat/squaredLength');

var _squaredLength2 = _interopRequireDefault(_squaredLength);

var _dot = require('gl-quat/dot');

var _dot2 = _interopRequireDefault(_dot);

var _rotationTo = require('gl-quat/rotationTo');

var _rotationTo2 = _interopRequireDefault(_rotationTo);

var _add = require('gl-quat/add');

var _add2 = _interopRequireDefault(_add);

var _calculateW = require('gl-quat/calculateW');

var _calculateW2 = _interopRequireDefault(_calculateW);

var _conjugate = require('gl-quat/conjugate');

var _conjugate2 = _interopRequireDefault(_conjugate);

var _invert = require('gl-quat/invert');

var _invert2 = _interopRequireDefault(_invert);

var _lerp = require('gl-quat/lerp');

var _lerp2 = _interopRequireDefault(_lerp);

var _multiply = require('gl-quat/multiply');

var _multiply2 = _interopRequireDefault(_multiply);

var _normalize = require('gl-quat/normalize');

var _normalize2 = _interopRequireDefault(_normalize);

var _rotateX = require('gl-quat/rotateX');

var _rotateX2 = _interopRequireDefault(_rotateX);

var _rotateY = require('gl-quat/rotateY');

var _rotateY2 = _interopRequireDefault(_rotateY);

var _rotateZ = require('gl-quat/rotateZ');

var _rotateZ2 = _interopRequireDefault(_rotateZ);

var _scale = require('gl-quat/scale');

var _scale2 = _interopRequireDefault(_scale);

var _set = require('gl-quat/set');

var _set2 = _interopRequireDefault(_set);

var _setAxisAngle = require('gl-quat/setAxisAngle');

var _setAxisAngle2 = _interopRequireDefault(_setAxisAngle);

var _slerp = require('gl-quat/slerp');

var _slerp2 = _interopRequireDefault(_slerp);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// gl-matrix is too big. Cherry-pick individual imports from stack.gl version
/* eslint-disable camelcase */

// import quat_getAxisAngle from 'gl-quat/getAxisAngle';


var IDENTITY_QUATERNION = [0, 0, 0, 1];

function validateQuaternion(q) {
  return q.length === 4 && Number.isFinite(q[0]) && Number.isFinite(q[1]) && Number.isFinite(q[2]) && Number.isFinite(q[3]);
}

var Quaternion = function (_MathArray) {
  _inherits(Quaternion, _MathArray);

  // Creates a new identity quat
  function Quaternion() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var w = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;

    _classCallCheck(this, Quaternion);

    var _this = _possibleConstructorReturn(this, (Quaternion.__proto__ || Object.getPrototypeOf(Quaternion)).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y, z, w);
    }
    return _this;
  }

  // Creates a quaternion from the given 3x3 rotation matrix.
  // NOTE: The resultant quaternion is not normalized, so you should
  // be sure to renormalize the quaternion yourself where necessary.


  _createClass(Quaternion, [{
    key: 'fromMatrix3',
    value: function fromMatrix3(m) {
      (0, _fromMat2.default)(this, m);
      this.check();
      return this;
    }

    // Creates a new quat initialized with the given values

  }, {
    key: 'fromValues',
    value: function fromValues(x, y, z, w) {
      return this.set(x, y, z, w);
    }

    // Set a quat to the identity quaternion

  }, {
    key: 'identity',
    value: function identity() {
      (0, _identity2.default)(this);
      this.check();
      return this;
    }

    // Getters/setters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'length',

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    // Calculates the length of a quat
    value: function length() {
      return (0, _length2.default)(this);
    }

    // Calculates the squared length of a quat

  }, {
    key: 'squaredLength',
    value: function squaredLength(a) {
      return (0, _squaredLength2.default)(this);
    }

    // Calculates the dot product of two quat's
    // @return {Number}

  }, {
    key: 'dot',
    value: function dot(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.dot only takes one argument');
      }
      return (0, _dot2.default)(this, a);
    }

    // Gets the rotation axis and angle for a given quaternion.
    // If a quaternion is created with setAxisAngle, this method will
    // return the same values as providied in the original parameter
    // list OR functionally equivalent values.
    // Example: The quaternion formed by axis [0, 0, 1] and angle -90
    // is the same as the quaternion formed by [0, 0, 1] and 270.
    // This method favors the latter.
    // @return {{[x,y,z], Number}}
    // getAxisAngle() {
    //   const axis = [];
    //   const angle = quat_getAxisAngle(axis, this);
    //   return {axis, angle};
    // }

    // MODIFIERS

    // Sets a quaternion to represent the shortest rotation from one vector
    // to another. Both vectors are assumed to be unit length.

  }, {
    key: 'rotationTo',
    value: function rotationTo(vectorA, vectorB) {
      (0, _rotationTo2.default)(this, vectorA, vectorB);
      this.check();
      return this;
    }

    // Sets the specified quaternion with values corresponding to the given axes.
    // Each axis is a vec3 and is expected to be unit length and perpendicular
    // to all other specified axes.
    // setAxes() {
    //   Number
    // }

    // Performs a spherical linear interpolation with two control points
    // sqlerp() {
    //   Number;
    // }

    // Adds two quat's

  }, {
    key: 'add',
    value: function add(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.add only takes one argument');
      }
      (0, _add2.default)(this, a);
      this.check();
      return this;
    }

    // Calculates the W component of a quat from the X, Y, and Z components.
    // Any existing W component will be ignored.

  }, {
    key: 'calculateW',
    value: function calculateW() {
      (0, _calculateW2.default)(this, this);
      this.check();
      return this;
    }

    // Calculates the conjugate of a quat If the quaternion is normalized,
    // this function is faster than quat_inverse and produces the same result.

  }, {
    key: 'conjugate',
    value: function conjugate() {
      (0, _conjugate2.default)(this, this);
      this.check();
      return this;
    }

    // Calculates the inverse of a quat

  }, {
    key: 'invert',
    value: function invert() {
      (0, _invert2.default)(this, this);
      this.check();
      return this;
    }

    // Performs a linear interpolation between two quat's

  }, {
    key: 'lerp',
    value: function lerp(a, b, t) {
      (0, _lerp2.default)(this, a, b, t);
      this.check();
      return this;
    }

    // Multiplies two quat's

  }, {
    key: 'multiply',
    value: function multiply(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.multiply only takes one argument');
      }
      (0, _multiply2.default)(this, this, b);
      this.check();
      return this;
    }

    // Normalize a quat

  }, {
    key: 'normalize',
    value: function normalize() {
      (0, _normalize2.default)(this, this);
      this.check();
      return this;
    }

    // Rotates a quaternion by the given angle about the X axis

  }, {
    key: 'rotateX',
    value: function rotateX(rad) {
      (0, _rotateX2.default)(this, this, rad);
      this.check();
      return this;
    }

    // Rotates a quaternion by the given angle about the Y axis

  }, {
    key: 'rotateY',
    value: function rotateY(rad) {
      (0, _rotateY2.default)(this, this, rad);
      this.check();
      return this;
    }

    // Rotates a quaternion by the given angle about the Z axis

  }, {
    key: 'rotateZ',
    value: function rotateZ(rad) {
      (0, _rotateZ2.default)(this, this, rad);
      this.check();
      return this;
    }

    // Scales a quat by a scalar number

  }, {
    key: 'scale',
    value: function scale(b) {
      (0, _scale2.default)(this, this, b);
      this.check();
      return this;
    }

    // Set the components of a quat to the given values

  }, {
    key: 'set',
    value: function set(i, j, k, l) {
      (0, _set2.default)(this, i, j, k, l);
      this.check();
      return this;
    }

    // Sets a quat from the given angle and rotation axis, then returns it.

  }, {
    key: 'setAxisAngle',
    value: function setAxisAngle(axis, rad) {
      (0, _setAxisAngle2.default)(this, axis, rad);
      this.check();
      return this;
    }

    // Performs a spherical linear interpolation between two quat

  }, {
    key: 'slerp',
    value: function slerp(_ref) {
      var _ref$start = _ref.start,
          start = _ref$start === undefined ? IDENTITY_QUATERNION : _ref$start,
          target = _ref.target,
          ratio = _ref.ratio;

      (0, _slerp2.default)(this, start, target, ratio);
      this.check();
      return this;
    }
  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 4;
    }
  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'z',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'w',
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = (0, _common.checkNumber)(value);
    }
  }]);

  return Quaternion;
}(_mathArray2.default);

exports.default = Quaternion;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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