'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Vector = function (_MathArray) {
  _inherits(Vector, _MathArray);

  function Vector() {
    _classCallCheck(this, Vector);

    return _possibleConstructorReturn(this, (Vector.__proto__ || Object.getPrototypeOf(Vector)).apply(this, arguments));
  }

  _createClass(Vector, [{
    key: 'len',


    // ACCESSORS

    // NOTE: `length` is a reserved word for Arrays, so we can't use `v.length()`
    // Offer `len` and `magnitude`

    value: function len() {
      return Math.sqrt(this.lengthSquared());
    }
  }, {
    key: 'magnitude',
    value: function magnitude() {
      return Math.sqrt(this.lengthSquared());
    }
  }, {
    key: 'lengthSquared',
    value: function lengthSquared() {
      var length = 0;
      for (var i = 0; i < this.ELEMENTS; ++i) {
        length += this[i] * this[i];
      }
      return length;
    }
  }, {
    key: 'distance',
    value: function distance(mathArray) {
      return Math.sqrt(this.distanceSquared(mathArray));
    }
  }, {
    key: 'distanceSquared',
    value: function distanceSquared(mathArray) {
      var length = 0;
      for (var i = 0; i < this.ELEMENTS; ++i) {
        var dist = this[i] - mathArray[i];
        length += dist * dist;
      }
      return (0, _common.checkNumber)(length);
    }
  }, {
    key: 'dot',
    value: function dot(mathArray) {
      var product = 0;
      for (var i = 0; i < this.ELEMENTS; ++i) {
        product += this[i] * mathArray[i];
      }
      return (0, _common.checkNumber)(product);
    }

    // MODIFIERS

  }, {
    key: 'normalize',
    value: function normalize() {
      var length = this.magnitude();
      if (length !== 0) {
        for (var i = 0; i < this.ELEMENTS; ++i) {
          this[i] /= length;
        }
      }
      return this.check();
    }
  }]);

  return Vector;
}(_mathArray2.default);

exports.default = Vector;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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