'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.validateVector2 = validateVector2;

var _vector = require('./vector');

var _vector2 = _interopRequireDefault(_vector);

var _common = require('./common');

var _set = require('gl-vec2/set');

var _set2 = _interopRequireDefault(_set);

var _add = require('gl-vec2/add');

var _add2 = _interopRequireDefault(_add);

var _subtract = require('gl-vec2/subtract');

var _subtract2 = _interopRequireDefault(_subtract);

var _multiply = require('gl-vec2/multiply');

var _multiply2 = _interopRequireDefault(_multiply);

var _divide = require('gl-vec2/divide');

var _divide2 = _interopRequireDefault(_divide);

var _scale2 = require('gl-vec2/scale');

var _scale3 = _interopRequireDefault(_scale2);

var _scaleAndAdd = require('gl-vec2/scaleAndAdd');

var _scaleAndAdd2 = _interopRequireDefault(_scaleAndAdd);

var _negate = require('gl-vec2/negate');

var _negate2 = _interopRequireDefault(_negate);

var _normalize = require('gl-vec2/normalize');

var _normalize2 = _interopRequireDefault(_normalize);

var _dot = require('gl-vec2/dot');

var _dot2 = _interopRequireDefault(_dot);

var _cross = require('gl-vec2/cross');

var _cross2 = _interopRequireDefault(_cross);

var _lerp = require('gl-vec2/lerp');

var _lerp2 = _interopRequireDefault(_lerp);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// gl-matrix is too big. Cherry-pick individual imports from stack.gl version
/* eslint-disable camelcase */


function validateVector2(v) {
  return v.length === 2 && Number.isFinite(v[0]) && Number.isFinite(v[1]);
}

var Vector2 = function (_Vector) {
  _inherits(Vector2, _Vector);

  // Creates a new, empty vec2
  function Vector2() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

    _classCallCheck(this, Vector2);

    var _this = _possibleConstructorReturn(this, (Vector2.__proto__ || Object.getPrototypeOf(Vector2)).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y);
    }
    return _this;
  }

  _createClass(Vector2, [{
    key: 'set',
    value: function set(x, y) {
      (0, _set2.default)(this, x, y);
      this.check();
      return this;
    }

    // Getters/setters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'add',

    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

    value: function add() {
      for (var _len = arguments.length, vectors = Array(_len), _key = 0; _key < _len; _key++) {
        vectors[_key] = arguments[_key];
      }

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = vectors[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var vector = _step.value;

          (0, _add2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return this;
    }
  }, {
    key: 'subtract',
    value: function subtract() {
      for (var _len2 = arguments.length, vectors = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        vectors[_key2] = arguments[_key2];
      }

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = vectors[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var vector = _step2.value;

          (0, _subtract2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'multiply',
    value: function multiply() {
      for (var _len3 = arguments.length, vectors = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        vectors[_key3] = arguments[_key3];
      }

      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = vectors[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var vector = _step3.value;

          (0, _multiply2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'divide',
    value: function divide() {
      for (var _len4 = arguments.length, vectors = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        vectors[_key4] = arguments[_key4];
      }

      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = vectors[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var vector = _step4.value;

          (0, _divide2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'scale',
    value: function scale(_scale) {
      if (Number.isFinite(_scale)) {
        (0, _scale3.default)(this, this, _scale);
      }
      this.check();
      return this;
    }
  }, {
    key: 'scaleAndAdd',
    value: function scaleAndAdd(vector, scale) {
      (0, _scaleAndAdd2.default)(this, this, vector, scale);
      this.check();
      return this;
    }
  }, {
    key: 'negate',
    value: function negate() {
      (0, _negate2.default)(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'normalize',
    value: function normalize() {
      (0, _normalize2.default)(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'dot',
    value: function dot(vector) {
      return (0, _dot2.default)(this, vector);
    }
  }, {
    key: 'cross',
    value: function cross(vector) {
      (0, _cross2.default)(this, this, vector);
      this.check();
      return this;
    }
  }, {
    key: 'lerp',
    value: function lerp(vector, coeff) {
      (0, _lerp2.default)(this, this, vector, coeff);
      this.check();
      return this;
    }
  }, {
    key: 'horizontalAngle',
    value: function horizontalAngle() {
      return Math.atan2(this.y, this.x);
    }
  }, {
    key: 'verticalAngle',
    value: function verticalAngle() {
      return Math.atan2(this.x, this.y);
    }
  }, {
    key: 'operation',
    value: function operation(_operation) {
      for (var _len5 = arguments.length, args = Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
        args[_key5 - 1] = arguments[_key5];
      }

      _operation.apply(undefined, [this, this].concat(args));
      this.check();
      return this;
    }
  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 2;
    }
  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }]);

  return Vector2;
}(_vector2.default);

exports.default = Vector2;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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