'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.validateVector4 = validateVector4;

var _vector = require('./vector');

var _vector2 = _interopRequireDefault(_vector);

var _common = require('./common');

var _set = require('gl-vec4/set');

var _set2 = _interopRequireDefault(_set);

var _distance = require('gl-vec4/distance');

var _distance2 = _interopRequireDefault(_distance);

var _add = require('gl-vec4/add');

var _add2 = _interopRequireDefault(_add);

var _subtract = require('gl-vec4/subtract');

var _subtract2 = _interopRequireDefault(_subtract);

var _multiply = require('gl-vec4/multiply');

var _multiply2 = _interopRequireDefault(_multiply);

var _divide = require('gl-vec4/divide');

var _divide2 = _interopRequireDefault(_divide);

var _scale2 = require('gl-vec4/scale');

var _scale3 = _interopRequireDefault(_scale2);

var _scaleAndAdd = require('gl-vec4/scaleAndAdd');

var _scaleAndAdd2 = _interopRequireDefault(_scaleAndAdd);

var _negate = require('gl-vec4/negate');

var _negate2 = _interopRequireDefault(_negate);

var _inverse = require('gl-vec4/inverse');

var _inverse2 = _interopRequireDefault(_inverse);

var _normalize = require('gl-vec4/normalize');

var _normalize2 = _interopRequireDefault(_normalize);

var _dot = require('gl-vec4/dot');

var _dot2 = _interopRequireDefault(_dot);

var _lerp = require('gl-vec4/lerp');

var _lerp2 = _interopRequireDefault(_lerp);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// gl-matrix is too big. Cherry-pick individual imports from stack.gl version
/* eslint-disable camelcase */

// import vec4_cross from 'gl-vec4/cross';


function validateVector4(v) {
  return v.length === 4 && Number.isFinite(v[0]) && Number.isFinite(v[1]) && Number.isFinite(v[2]) && Number.isFinite(v[3]);
}

var Vector4 = function (_Vector) {
  _inherits(Vector4, _Vector);

  // Creates a new, empty vec4
  function Vector4() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var w = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

    _classCallCheck(this, Vector4);

    var _this = _possibleConstructorReturn(this, (Vector4.__proto__ || Object.getPrototypeOf(Vector4)).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y, z, w);
    }
    return _this;
  }

  _createClass(Vector4, [{
    key: 'set',
    value: function set(x, y, z, w) {
      (0, _set2.default)(this, x, y, z, w);
      this.check();
      return this;
    }

    // Getters/setters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'distance',

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    value: function distance(vector) {
      return (0, _distance2.default)(vector);
    }
  }, {
    key: 'add',
    value: function add() {
      for (var _len = arguments.length, vectors = Array(_len), _key = 0; _key < _len; _key++) {
        vectors[_key] = arguments[_key];
      }

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = vectors[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var vector = _step.value;

          (0, _add2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'subtract',
    value: function subtract() {
      for (var _len2 = arguments.length, vectors = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        vectors[_key2] = arguments[_key2];
      }

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = vectors[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var vector = _step2.value;

          (0, _subtract2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'multiply',
    value: function multiply() {
      for (var _len3 = arguments.length, vectors = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        vectors[_key3] = arguments[_key3];
      }

      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = vectors[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var vector = _step3.value;

          (0, _multiply2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'divide',
    value: function divide() {
      for (var _len4 = arguments.length, vectors = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        vectors[_key4] = arguments[_key4];
      }

      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = vectors[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var vector = _step4.value;

          (0, _divide2.default)(this, this, vector);
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'scale',
    value: function scale(_scale) {
      (0, _scale3.default)(this, this, _scale);
      this.check();
      return this;
    }
  }, {
    key: 'scaleAndAdd',
    value: function scaleAndAdd(vector, scale) {
      (0, _scaleAndAdd2.default)(this, this, vector, scale);
      this.check();
      return this;
    }
  }, {
    key: 'negate',
    value: function negate() {
      (0, _negate2.default)(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'inverse',
    value: function inverse() {
      (0, _inverse2.default)(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'normalize',
    value: function normalize() {
      (0, _normalize2.default)(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'dot',
    value: function dot(vector) {
      return (0, _dot2.default)(this, vector);
    }

    // cross(scale) {
    //   vec4_cross(this, this, scale);
    //   this.check();
    //   return this;
    // }

  }, {
    key: 'lerp',
    value: function lerp(vector, coeff) {
      (0, _lerp2.default)(this, this, vector, coeff);
      this.check();
      return this;
    }

    /*
    multiply(...vectors) {
      for (const vector of vectors) {
        vec4_multiply(this, vector);
      }
      this.check();
      return this;
    }
     divide(...vectors) {
      for (const vector of vectors) {
        vec4_divide(this, vector);
      }
      this.check();
      return this;
    }
     ceil() {
      vec4_ceil(this, this);
      this.check();
      return this;
    }
     floor() {
      vec4_floor(this, this);
      this.check();
      return this;
    }
     min() {
      vec4_min(this, this);
      this.check();
      return this;
    }
     max() {
      vec4_max(this, this);
      this.check();
      return this;
    }
     hermite(scale) {
      vec4_hermite(this, this, scale);
      this.check();
      return this;
    }
     bezier(scale) {
      vec4_bezier(this, this, scale);
      this.check();
      return this;
    }
     random(scale) {
      vec4_random(this, this, scale);
      this.check();
      return this;
    }
     rotateX(origin, angle) {
      vec4_rotateX(this, this, origin, angle);
      this.check();
      return this;
    }
     rotateY(origin, angle) {
      vec4_rotateY(this, this, origin, angle);
      this.check();
      return this;
    }
     rotateZ(origin, angle) {
      vec4_rotateZ(this, this, origin, angle);
      this.check();
      return this;
    }
    */

  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 4;
    }
  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'z',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'w',
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = (0, _common.checkNumber)(value);
    }
  }]);

  return Vector4;
}(_vector2.default);

exports.default = Vector4;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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