import Vector from './lib/vector';
import * as vec2 from 'gl-matrix/vec2';
export default class Vector2 extends Vector {
  constructor() {
    let x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    let y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    super();

    if (Array.isArray(x) && arguments.length === 1) {
      this.copy(x);
    } else {
      this.set(x, y);
    }
  }

  get ELEMENTS() {
    return 2;
  }

  cross(vector) {
    vec2.cross(this, this, vector);
    return this.check();
  }

  horizontalAngle() {
    return Math.atan2(this.y, this.x);
  }

  verticalAngle() {
    return Math.atan2(this.x, this.y);
  }

  operation(operation) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    operation(this, this, ...args);
    return this.check();
  }

}
//# sourceMappingURL=vector2.js.map