import Vector from './lib/vector';
import { checkNumber } from './lib/common';
import * as vec3 from 'gl-matrix/vec3';
const ORIGIN = [0, 0, 0];
export default class Vector3 extends Vector {
  constructor() {
    let x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    let y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    let z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    super();

    if (Array.isArray(x) && arguments.length === 1) {
      this.copy(x);
    } else {
      this.set(x, y, z);
    }
  }

  get ELEMENTS() {
    return 3;
  }

  get z() {
    return this[2];
  }

  set z(value) {
    return this[2] = checkNumber(value);
  }

  angle(vector) {
    return vec3.angle(this, vector);
  }

  cross(vector) {
    vec3.cross(this, this, vector);
    return this.check();
  }

  rotateX(_ref) {
    let radians = _ref.radians,
        _ref$origin = _ref.origin,
        origin = _ref$origin === void 0 ? ORIGIN : _ref$origin;
    vec3.rotateX(this, this, origin, radians);
    return this.check();
  }

  rotateY(_ref2) {
    let radians = _ref2.radians,
        _ref2$origin = _ref2.origin,
        origin = _ref2$origin === void 0 ? ORIGIN : _ref2$origin;
    vec3.rotateY(this, this, origin, radians);
    return this.check();
  }

  rotateZ(_ref3) {
    let radians = _ref3.radians,
        _ref3$origin = _ref3.origin,
        origin = _ref3$origin === void 0 ? ORIGIN : _ref3$origin;
    vec3.rotateZ(this, this, origin, radians);
    return this.check();
  }

  operation(operation) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    operation(this, this, ...args);
    return this.check();
  }

}
//# sourceMappingURL=vector3.js.map