"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _common = require("../lib/common");

var Polygon = function () {
  function Polygon(points) {
    (0, _classCallCheck2.default)(this, Polygon);
    this.points = points;
    this.isClosed = (0, _common.equals)(this.points[this.points.length - 1], this.points[0]);
    Object.freeze(this);
  }

  (0, _createClass2.default)(Polygon, [{
    key: "getSignedArea",
    value: function getSignedArea() {
      var area = 0;
      this.forEachSegment(function (p1, p2) {
        area += (p1[0] + p2[0]) * (p1[1] - p2[1]);
      });
      return area / 2;
    }
  }, {
    key: "getArea",
    value: function getArea() {
      return Math.abs(this.getSignedArea());
    }
  }, {
    key: "getWindingDirection",
    value: function getWindingDirection() {
      return Math.sign(this.getSignedArea());
    }
  }, {
    key: "forEachSegment",
    value: function forEachSegment(visitor) {
      var length = this.points.length;

      for (var i = 0; i < length - 1; i++) {
        visitor(this.points[i], this.points[i + 1], i, i + 1);
      }

      if (this.isPolygon && !this.isClosed()) {
        visitor(this.points[length - 1], this.points[0], length - 1, 0);
      }
    }
  }]);
  return Polygon;
}();

exports.default = Polygon;
//# sourceMappingURL=polygon.js.map