"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMatrix3 = validateMatrix3;
exports.default = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _mathArray = _interopRequireDefault(require("./lib/math-array"));

var _validators = require("./lib/validators");

var _common = require("./lib/common");

var _vector = _interopRequireDefault(require("./vector2"));

var _vector2 = _interopRequireDefault(require("./vector3"));

var mat3 = _interopRequireWildcard(require("gl-matrix/mat3"));

var vec2 = _interopRequireWildcard(require("gl-matrix/vec2"));

var vec3 = _interopRequireWildcard(require("gl-matrix/vec3"));

var IDENTITY = [1, 0, 0, 0, 1, 0, 0, 0, 1];

function validateMatrix3(m) {
  return m.length === 9 && Number.isFinite(m[0]) && Number.isFinite(m[1]) && Number.isFinite(m[2]) && Number.isFinite(m[3]) && Number.isFinite(m[4]) && Number.isFinite(m[5]) && Number.isFinite(m[6]) && Number.isFinite(m[7]) && Number.isFinite(m[8]);
}

var Matrix3 = function (_MathArray) {
  (0, _inherits2.default)(Matrix3, _MathArray);

  function Matrix3() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    (0, _classCallCheck2.default)(this, Matrix3);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(Matrix3).call(this));

    if (Array.isArray(args[0]) && arguments.length === 1) {
      _this.copy(args[0]);
    } else {
      _this.identity();
    }

    return _this;
  }

  (0, _createClass2.default)(Matrix3, [{
    key: "setRowMajor",
    value: function setRowMajor() {
      var m00 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var m01 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var m02 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var m10 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var m11 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 1;
      var m12 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
      var m20 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
      var m21 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
      var m22 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 1;
      this[0] = m00;
      this[1] = m10;
      this[2] = m20;
      this[3] = m01;
      this[4] = m11;
      this[5] = m21;
      this[6] = m02;
      this[7] = m12;
      this[8] = m22;
      return this.check();
    }
  }, {
    key: "setColumnMajor",
    value: function setColumnMajor() {
      var m00 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var m10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var m20 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var m01 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var m11 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 1;
      var m21 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
      var m02 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
      var m12 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
      var m22 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 1;
      this[0] = m00;
      this[1] = m10;
      this[2] = m20;
      this[3] = m01;
      this[4] = m11;
      this[5] = m21;
      this[6] = m02;
      this[7] = m12;
      this[8] = m22;
      return this.check();
    }
  }, {
    key: "copy",
    value: function copy(array) {
      return this.setColumnMajor.apply(this, (0, _toConsumableArray2.default)(array));
    }
  }, {
    key: "set",
    value: function set() {
      return this.setColumnMajor.apply(this, arguments);
    }
  }, {
    key: "getElement",
    value: function getElement(i, j) {
      var columnMajor = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      return columnMajor ? this[i * 3 + j] : this[j * 3 + i];
    }
  }, {
    key: "setElement",
    value: function setElement(i, j, value) {
      var columnMajor = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

      if (columnMajor) {
        this[i * 3 + j] = (0, _common.checkNumber)(value);
      } else {
        this[j * 3 + i] = (0, _common.checkNumber)(value);
      }

      return this;
    }
  }, {
    key: "determinant",
    value: function determinant() {
      return mat3.determinant(this);
    }
  }, {
    key: "identity",
    value: function identity() {
      for (var i = 0; i < IDENTITY.length; ++i) {
        this[i] = IDENTITY[i];
      }

      return this.check();
    }
  }, {
    key: "fromQuaternion",
    value: function fromQuaternion(q) {
      mat3.fromQuat(this, q);
      return this.check();
    }
  }, {
    key: "transpose",
    value: function transpose() {
      mat3.transpose(this, this);
      return this.check();
    }
  }, {
    key: "invert",
    value: function invert() {
      mat3.invert(this, this);
      return this.check();
    }
  }, {
    key: "multiplyLeft",
    value: function multiplyLeft(a) {
      mat3.multiply(this, a, this);
      return this.check();
    }
  }, {
    key: "multiplyRight",
    value: function multiplyRight(a) {
      mat3.multiply(this, this, a);
      return this.check();
    }
  }, {
    key: "rotate",
    value: function rotate(radians) {
      mat3.rotate(this, this, radians);
      return this.check();
    }
  }, {
    key: "scale",
    value: function scale(factor) {
      if (Array.isArray(factor)) {
        mat3.scale(this, this, factor);
      } else {
        mat3.scale(this, this, [factor, factor, factor]);
      }

      return this.check();
    }
  }, {
    key: "translate",
    value: function translate(vec) {
      mat3.translate(this, this, vec);
      return this.check();
    }
  }, {
    key: "transformVector2",
    value: function transformVector2(vector, out) {
      out = out || new _vector.default();
      vec2.transformMat3(out, vector, this);
      (0, _validators.validateVector)(out, 2);
      return out;
    }
  }, {
    key: "transformVector3",
    value: function transformVector3(vector, out) {
      out = out || new _vector2.default();
      vec3.transformMat3(out, vector, this);
      (0, _validators.validateVector)(out, 3);
      return out;
    }
  }, {
    key: "transformVector",
    value: function transformVector(vector, out) {
      switch (vector.length) {
        case 2:
          return this.transformVector2(vector, out);

        case 3:
          return this.transformVector3(vector, out);

        default:
          throw new Error('Illegal vector');
      }
    }
  }, {
    key: "ELEMENTS",
    get: function get() {
      return 9;
    }
  }]);
  return Matrix3;
}(_mathArray.default);

exports.default = Matrix3;
//# sourceMappingURL=matrix3.js.map