"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateQuaternion = validateQuaternion;
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _mathArray = _interopRequireDefault(require("./lib/math-array"));

var _common = require("./lib/common");

var quat = _interopRequireWildcard(require("gl-matrix/quat"));

var IDENTITY_QUATERNION = [0, 0, 0, 1];

function validateQuaternion(q) {
  return q.length === 4 && Number.isFinite(q[0]) && Number.isFinite(q[1]) && Number.isFinite(q[2]) && Number.isFinite(q[3]);
}

var Quaternion = function (_MathArray) {
  (0, _inherits2.default)(Quaternion, _MathArray);

  function Quaternion() {
    var _this;

    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var w = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
    (0, _classCallCheck2.default)(this, Quaternion);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(Quaternion).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y, z, w);
    }

    return _this;
  }

  (0, _createClass2.default)(Quaternion, [{
    key: "fromMatrix3",
    value: function fromMatrix3(m) {
      quat.fromMat3(this, m);
      return this.check();
    }
  }, {
    key: "fromValues",
    value: function fromValues(x, y, z, w) {
      return this.set(x, y, z, w);
    }
  }, {
    key: "identity",
    value: function identity() {
      quat.identity(this);
      return this.check();
    }
  }, {
    key: "length",
    value: function length() {
      return quat.length(this);
    }
  }, {
    key: "squaredLength",
    value: function squaredLength(a) {
      return quat.squaredLength(this);
    }
  }, {
    key: "dot",
    value: function dot(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.dot only takes one argument');
      }

      return quat.dot(this, a);
    }
  }, {
    key: "rotationTo",
    value: function rotationTo(vectorA, vectorB) {
      quat.rotationTo(this, vectorA, vectorB);
      return this.check();
    }
  }, {
    key: "add",
    value: function add(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.add only takes one argument');
      }

      quat.add(this, a);
      return this.check();
    }
  }, {
    key: "calculateW",
    value: function calculateW() {
      quat.calculateW(this, this);
      return this.check();
    }
  }, {
    key: "conjugate",
    value: function conjugate() {
      quat.conjugate(this, this);
      return this.check();
    }
  }, {
    key: "invert",
    value: function invert() {
      quat.invert(this, this);
      return this.check();
    }
  }, {
    key: "lerp",
    value: function lerp(a, b, t) {
      quat.lerp(this, a, b, t);
      return this.check();
    }
  }, {
    key: "multiply",
    value: function multiply(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.multiply only takes one argument');
      }

      quat.multiply(this, this, a);
      return this.check();
    }
  }, {
    key: "normalize",
    value: function normalize() {
      quat.normalize(this, this);
      return this.check();
    }
  }, {
    key: "rotateX",
    value: function rotateX(rad) {
      quat.rotateX(this, this, rad);
      return this.check();
    }
  }, {
    key: "rotateY",
    value: function rotateY(rad) {
      quat.rotateY(this, this, rad);
      return this.check();
    }
  }, {
    key: "rotateZ",
    value: function rotateZ(rad) {
      quat.rotateZ(this, this, rad);
      return this.check();
    }
  }, {
    key: "scale",
    value: function scale(b) {
      quat.scale(this, this, b);
      return this.check();
    }
  }, {
    key: "set",
    value: function set(i, j, k, l) {
      quat.set(this, i, j, k, l);
      return this.check();
    }
  }, {
    key: "setAxisAngle",
    value: function setAxisAngle(axis, rad) {
      quat.setAxisAngle(this, axis, rad);
      return this.check();
    }
  }, {
    key: "slerp",
    value: function slerp(_ref) {
      var _ref$start = _ref.start,
          start = _ref$start === void 0 ? IDENTITY_QUATERNION : _ref$start,
          target = _ref.target,
          ratio = _ref.ratio;
      quat.slerp(this, start, target, ratio);
      return this.check();
    }
  }, {
    key: "ELEMENTS",
    get: function get() {
      return 4;
    }
  }, {
    key: "x",
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: "y",
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: "z",
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }, {
    key: "w",
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = (0, _common.checkNumber)(value);
    }
  }]);
  return Quaternion;
}(_mathArray.default);

exports.default = Quaternion;
//# sourceMappingURL=quaternion.js.map