import Vector from './lib/vector';
import { checkNumber } from './lib/common';
export default class Vector4 extends Vector {
  constructor() {
    let x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    let y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    let z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    let w = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
    super();

    if (Array.isArray(x) && arguments.length === 1) {
      this.copy(x);
    } else {
      this.set(x, y, z, w);
    }
  }

  get ELEMENTS() {
    return 4;
  }

  get z() {
    return this[2];
  }

  set z(value) {
    return this[2] = checkNumber(value);
  }

  get w() {
    return this[3];
  }

  set w(value) {
    return this[3] = checkNumber(value);
  }

  applyMatrix4(m) {
    m.transformVector(this, this);
    return this;
  }

}
//# sourceMappingURL=vector4.js.map