var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { INPUT_EVENT_TYPES } from '../constants';
import { window, userAgent } from '../utils/globals';

var firefox = userAgent.indexOf('firefox') !== -1;

var WHEEL_EVENTS = INPUT_EVENT_TYPES.WHEEL_EVENTS;

var EVENT_TYPE = 'wheel';

// Constants for normalizing input delta
var WHEEL_DELTA_MAGIC_SCALER = 4.000244140625;
var WHEEL_DELTA_PER_LINE = 40;
// Slow down zoom if shift key is held for more precise zooming
var SHIFT_MULTIPLIER = 0.25;

var WheelInput = function () {
  function WheelInput(element, callback) {
    var _this = this;

    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    _classCallCheck(this, WheelInput);

    this.element = element;
    this.callback = callback;

    this.options = Object.assign({ enable: true }, options);

    this.events = WHEEL_EVENTS.concat(options.events || []);

    this.handleEvent = this.handleEvent.bind(this);
    this.events.forEach(function (event) {
      return element.addEventListener(event, _this.handleEvent);
    });
  }

  _createClass(WheelInput, [{
    key: 'destroy',
    value: function destroy() {
      var _this2 = this;

      this.events.forEach(function (event) {
        return _this2.element.removeEventListener(event, _this2.handleEvent);
      });
    }

    /**
     * Enable this input (begin processing events)
     * if the specified event type is among those handled by this input.
     */

  }, {
    key: 'enableEventType',
    value: function enableEventType(eventType, enabled) {
      if (eventType === EVENT_TYPE) {
        this.options.enable = enabled;
      }
    }

    /* eslint-disable complexity, max-statements */

  }, {
    key: 'handleEvent',
    value: function handleEvent(event) {
      if (!this.options.enable) {
        return;
      }
      if (this.options.legacyBlockScroll) {
        event.preventDefault();
      }

      var value = event.deltaY;
      if (window.WheelEvent) {
        // Firefox doubles the values on retina screens...
        if (firefox && event.deltaMode === window.WheelEvent.DOM_DELTA_PIXEL) {
          value /= window.devicePixelRatio;
        }
        if (event.deltaMode === window.WheelEvent.DOM_DELTA_LINE) {
          value *= WHEEL_DELTA_PER_LINE;
        }
      }

      var wheelPosition = {
        x: event.clientX,
        y: event.clientY
      };

      if (value !== 0 && value % WHEEL_DELTA_MAGIC_SCALER === 0) {
        // This one is definitely a mouse wheel event.
        // Normalize this value to match trackpad.
        value = Math.floor(value / WHEEL_DELTA_MAGIC_SCALER);
      }

      if (event.shiftKey && value) {
        value = value * SHIFT_MULTIPLIER;
      }

      this._onWheel(event, -value, wheelPosition);
    }
  }, {
    key: '_onWheel',
    value: function _onWheel(srcEvent, delta, position) {
      this.callback({
        type: EVENT_TYPE,
        center: position,
        delta: delta,
        srcEvent: srcEvent,
        pointerType: 'mouse',
        target: srcEvent.target
      });
    }
  }]);

  return WheelInput;
}();

export default WheelInput;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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