/**
 * This file contains overrides the default
 * hammer.js functions to add our own utility
 */

/* Hammer.js constants */
var INPUT_START = 1;
var INPUT_MOVE = 2;
var INPUT_END = 4;
var MOUSE_INPUT_MAP = {
  mousedown: INPUT_START,
  mousemove: INPUT_MOVE,
  mouseup: INPUT_END
};

/**
 * Helper function that returns true if any element in an array meets given criteria.
 * Because older browsers do not support `Array.prototype.some`
 * @params array {Array}
 * @params predict {Function}
 */
function some(array, predict) {
  for (var i = 0; i < array.length; i++) {
    if (predict(array[i])) {
      return true;
    }
  }
  return false;
}

/* eslint-disable no-invalid-this */
export function enhancePointerEventInput(PointerEventInput) {
  var oldHandler = PointerEventInput.prototype.handler;

  // overrides PointerEventInput.handler to accept right mouse button
  PointerEventInput.prototype.handler = function handler(ev) {
    var store = this.store;

    // Allow non-left mouse buttons through
    if (ev.button > 0) {
      if (!some(store, function (e) {
        return e.pointerId === ev.pointerId;
      })) {
        store.push(ev);
      }
    }

    oldHandler.call(this, ev);
  };
}

// overrides MouseInput.handler to accept right mouse button
export function enhanceMouseInput(MouseInput) {
  MouseInput.prototype.handler = function handler(ev) {
    var eventType = MOUSE_INPUT_MAP[ev.type];

    // on start we want to have the mouse button down
    if (eventType & INPUT_START && ev.button >= 0) {
      this.pressed = true;
    }

    if (eventType & INPUT_MOVE && ev.which === 0) {
      eventType = INPUT_END;
    }

    // mouse must be down
    if (!this.pressed) {
      return;
    }

    if (eventType & INPUT_END) {
      this.pressed = false;
    }

    this.callback(this.manager, eventType, {
      pointers: [ev],
      changedPointers: [ev],
      pointerType: 'mouse',
      srcEvent: ev
    });
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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