// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import isBrowser from './is-browser';
import { enhancePointerEventInput, enhanceMouseInput } from './hammer-overrides';

var hammerjs = void 0;
if (isBrowser) {
  hammerjs = require('hammerjs');
}

// Hammer.Manager mock for use in environments without `document` / `window`.
function HammerManagerMock(m) {
  var instance = {};
  var chainedNoop = function chainedNoop() {
    return instance;
  };
  instance.get = function () {
    return null;
  };
  instance.set = chainedNoop;
  instance.on = chainedNoop;
  instance.off = chainedNoop;
  instance.destroy = chainedNoop;
  instance.emit = chainedNoop;
  return instance;
}

if (hammerjs) {
  enhancePointerEventInput(hammerjs.PointerEventInput);
  enhanceMouseInput(hammerjs.MouseInput);
}

export var Manager = hammerjs ? hammerjs.Manager : HammerManagerMock;

export default hammerjs;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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