var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

// based on https://github.com/uber/luma.gl/blob/master/src/utils/is-electron.js
/* global window, process, navigator */
function isElectron() {
  // Renderer process
  if (typeof window !== 'undefined' && _typeof(window.process) === 'object' && window.process.type === 'renderer') {
    return true;
  }
  // Main process
  if (typeof process !== 'undefined' && _typeof(process.versions) === 'object' && Boolean(process.versions.electron)) {
    return true;
  }
  // Detect the user agent when the `nodeIntegration` option is set to true
  if ((typeof navigator === 'undefined' ? 'undefined' : _typeof(navigator)) === 'object' && typeof navigator.userAgent === 'string' && navigator.userAgent.indexOf('Electron') >= 0) {
    return true;
  }
  return false;
}

export default isElectron();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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