'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _hammer = require('./utils/hammer');

var _wheelInput = require('./inputs/wheel-input');

var _wheelInput2 = _interopRequireDefault(_wheelInput);

var _moveInput = require('./inputs/move-input');

var _moveInput2 = _interopRequireDefault(_moveInput);

var _keyInput = require('./inputs/key-input');

var _keyInput2 = _interopRequireDefault(_keyInput);

var _contextmenuInput = require('./inputs/contextmenu-input');

var _contextmenuInput2 = _interopRequireDefault(_contextmenuInput);

var _constants = require('./constants');

var _eventUtils = require('./utils/event-utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DEFAULT_OPTIONS = {
  // event handlers
  events: null,
  // custom recognizers
  recognizers: null,
  // Manager class
  Manager: _hammer.Manager,
  // recognize right button gestures
  rightButton: false,
  // allow browser default touch action
  // https://github.com/uber/react-map-gl/issues/506
  touchAction: 'none',
  // block scrolling - this is a legacy behavior and will be removed in the next version
  legacyBlockScroll: true
};

// Unified API for subscribing to events about both
// basic input events (e.g. 'mousemove', 'touchstart', 'wheel')
// and gestural input (e.g. 'click', 'tap', 'panstart').
// Delegates gesture related event registration and handling to Hammer.js.
// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var EventManager = function () {
  function EventManager() {
    var element = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck3.default)(this, EventManager);

    this.options = (0, _assign2.default)({}, DEFAULT_OPTIONS, options);
    this.eventHandlers = [];

    this._onBasicInput = this._onBasicInput.bind(this);
    this._onOtherEvent = this._onOtherEvent.bind(this);

    this.setElement(element);

    // Register all passed events.
    var events = options.events;

    if (events) {
      this.on(events);
    }
  }

  (0, _createClass3.default)(EventManager, [{
    key: 'setElement',
    value: function setElement(element) {
      var _this = this;

      if (this.element) {
        // unregister all events
        this.destroy();
      }
      this.element = element;
      if (!element) {
        return;
      }

      var options = this.options;

      var ManagerClass = options.Manager;

      this.manager = new ManagerClass(element, {
        touchAction: options.touchAction,
        recognizers: options.recognizers || _constants.RECOGNIZERS
      }).on('hammer.input', this._onBasicInput);

      if (!options.recognizers) {
        // Set default recognize withs
        // http://hammerjs.github.io/recognize-with/
        (0, _keys2.default)(_constants.RECOGNIZER_COMPATIBLE_MAP).forEach(function (name) {
          var recognizer = _this.manager.get(name);
          if (recognizer) {
            _constants.RECOGNIZER_COMPATIBLE_MAP[name].forEach(function (otherName) {
              recognizer.recognizeWith(otherName);
            });
          }
        });
      }

      // Handle events not handled by Hammer.js:
      // - mouse wheel
      // - pointer/touch/mouse move
      this.wheelInput = new _wheelInput2.default(element, this._onOtherEvent, {
        enable: false,
        legacyBlockScroll: options.legacyBlockScroll
      });
      this.moveInput = new _moveInput2.default(element, this._onOtherEvent, { enable: false });
      this.keyInput = new _keyInput2.default(element, this._onOtherEvent, { enable: false });
      this.contextmenuInput = new _contextmenuInput2.default(element, this._onOtherEvent, {
        rightButton: options.rightButton
      });

      // Register all existing events
      this.eventHandlers.forEach(function (_ref) {
        var recognizerName = _ref.recognizerName,
            eventAlias = _ref.eventAlias,
            wrappedHandler = _ref.wrappedHandler;

        // Enable recognizer for this event.
        _this._toggleRecognizer(recognizerName, true);
        _this.manager.on(eventAlias, wrappedHandler);
      });
    }

    // Tear down internal event management implementations.

  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.element) {
        // wheelInput etc. are created in setElement() and therefore
        // cannot exist if there is no element
        this.wheelInput.destroy();
        this.moveInput.destroy();
        this.keyInput.destroy();
        this.contextmenuInput.destroy();
        this.manager.destroy();

        this.wheelInput = null;
        this.moveInput = null;
        this.keyInput = null;
        this.contextmenuInput = null;
        this.manager = null;
        this.element = null;
      }
    }

    // Register an event handler function to be called on `event`.

  }, {
    key: 'on',
    value: function on(event, handler, srcElement) {
      if (typeof event === 'string') {
        this._addEventHandler(event, handler, srcElement);
      } else {
        srcElement = handler;
        // If `event` is a map, call `on()` for each entry.
        for (var eventName in event) {
          this._addEventHandler(eventName, event[eventName], srcElement);
        }
      }
    }

    /**
     * Deregister a previously-registered event handler.
     * @param {string|Object} event   An event name (String) or map of event names to handlers
     * @param {Function} [handler]    The function to be called on `event`.
     */

  }, {
    key: 'off',
    value: function off(event, handler) {
      if (typeof event === 'string') {
        this._removeEventHandler(event, handler);
      } else {
        // If `event` is a map, call `off()` for each entry.
        for (var eventName in event) {
          this._removeEventHandler(eventName, event[eventName]);
        }
      }
    }

    /*
     * Enable/disable recognizer for the given event
     */

  }, {
    key: '_toggleRecognizer',
    value: function _toggleRecognizer(name, enabled) {
      var manager = this.manager;

      if (!manager) {
        return;
      }
      var recognizer = manager.get(name);
      if (recognizer) {
        recognizer.set({ enable: enabled });

        var fallbackRecognizers = _constants.RECOGNIZER_FALLBACK_MAP[name];
        if (fallbackRecognizers && !this.options.recognizers) {
          // Set default require failures
          // http://hammerjs.github.io/require-failure/
          fallbackRecognizers.forEach(function (otherName) {
            var otherRecognizer = manager.get(otherName);
            if (enabled) {
              // Wait for this recognizer to fail
              otherRecognizer.requireFailure(name);
            } else {
              // Do not wait for this recognizer to fail
              otherRecognizer.dropRequireFailure(name);
            }
          });
        }
      }
      this.wheelInput.enableEventType(name, enabled);
      this.moveInput.enableEventType(name, enabled);
      this.keyInput.enableEventType(name, enabled);
    }

    /**
     * Process the event registration for a single event + handler.
     */

  }, {
    key: '_addEventHandler',
    value: function _addEventHandler(event, handler) {
      var srcElement = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      var manager = this.manager,
          eventHandlers = this.eventHandlers;

      var wrappedHandler = this._wrapEventHandler(event, handler, srcElement);
      // Alias to a recognized gesture as necessary.
      var eventAlias = _constants.GESTURE_EVENT_ALIASES[event] || event;
      // Get recognizer for this event
      var recognizerName = _constants.EVENT_RECOGNIZER_MAP[eventAlias] || eventAlias;
      // Enable recognizer for this event.
      this._toggleRecognizer(recognizerName, true);

      // Find ancestors
      var ancestorEventHandlers = eventHandlers.filter(function (entry) {
        return entry.eventAlias === eventAlias && entry.srcElement !== srcElement && (!entry.srcElement || entry.srcElement.contains(srcElement));
      });

      // Save wrapped handler
      eventHandlers.push({ event: event, eventAlias: eventAlias, recognizerName: recognizerName, srcElement: srcElement,
        handler: handler, wrappedHandler: wrappedHandler });

      // Sort handlers by DOM hierarchy
      // So the event will always fire first on child nodes
      ancestorEventHandlers.forEach(function (entry) {
        return manager.off(eventAlias, entry.wrappedHandler);
      });
      if (manager) {
        manager.on(eventAlias, wrappedHandler);
      }
      ancestorEventHandlers.forEach(function (entry) {
        return manager.on(eventAlias, entry.wrappedHandler);
      });
    }

    /**
     * Process the event deregistration for a single event + handler.
     */

  }, {
    key: '_removeEventHandler',
    value: function _removeEventHandler(event, handler) {
      var manager = this.manager,
          eventHandlers = this.eventHandlers;

      var eventHandlerRemoved = false;

      // Find saved handler if any.
      for (var i = eventHandlers.length; i--;) {
        var entry = eventHandlers[i];
        if (entry.event === event && entry.handler === handler) {
          // Deregister event handler.
          if (manager) {
            manager.off(entry.eventAlias, entry.wrappedHandler);
          }
          // Delete saved handler
          eventHandlers.splice(i, 1);
          eventHandlerRemoved = true;
        }
      }

      if (eventHandlerRemoved) {
        // Alias to a recognized gesture as necessary.
        var eventAlias = _constants.GESTURE_EVENT_ALIASES[event] || event;
        // Get recognizer for this event
        var recognizerName = _constants.EVENT_RECOGNIZER_MAP[eventAlias] || eventAlias;
        // Disable recognizer if no more handlers are attached to its events
        var isRecognizerUsed = eventHandlers.find(function (entry) {
          return entry.recognizerName === recognizerName;
        });
        if (!isRecognizerUsed) {
          this._toggleRecognizer(recognizerName, false);
        }
      }
    }

    /**
     * Returns an event handler that aliases events and add props before passing
     * to the real handler.
     */

  }, {
    key: '_wrapEventHandler',
    value: function _wrapEventHandler(type, handler, srcElement) {
      var _this2 = this;

      return function (event) {
        var mjolnirEvent = event.mjolnirEvent;


        if (!mjolnirEvent) {
          mjolnirEvent = _this2._normalizeEvent(event);
          event.mjolnirEvent = mjolnirEvent;
        }

        var isStopped = mjolnirEvent.handled && mjolnirEvent.handled !== srcElement;

        if (!isStopped) {
          var isFromDecendant = !srcElement || srcElement.contains(event.srcEvent.target);
          if (isFromDecendant) {
            handler((0, _assign2.default)({}, mjolnirEvent, {
              type: type,
              stopPropagation: function stopPropagation() {
                if (!mjolnirEvent.handled) {
                  mjolnirEvent.handled = srcElement;
                }
              }
            }));
          }
        }
      };
    }

    /**
     * Normalizes hammerjs and custom events to have predictable fields.
     */

  }, {
    key: '_normalizeEvent',
    value: function _normalizeEvent(event) {
      var element = this.element;


      return (0, _assign2.default)({}, event, (0, _eventUtils.whichButtons)(event), (0, _eventUtils.getOffsetPosition)(event, element), {
        handled: false,
        rootElement: element
      });
    }

    /**
     * Handle basic events using the 'hammer.input' Hammer.js API:
     * Before running Recognizers, Hammer emits a 'hammer.input' event
     * with the basic event info. This function emits all basic events
     * aliased to the "class" of event received.
     * See constants.BASIC_EVENT_CLASSES basic event class definitions.
     */

  }, {
    key: '_onBasicInput',
    value: function _onBasicInput(event) {
      var srcEvent = event.srcEvent;

      var alias = _constants.BASIC_EVENT_ALIASES[srcEvent.type];
      if (alias) {
        // fire all events aliased to srcEvent.type
        this.manager.emit(alias, event);
      }
    }

    /**
     * Handle events not supported by Hammer.js,
     * and pipe back out through same (Hammer) channel used by other events.
     */

  }, {
    key: '_onOtherEvent',
    value: function _onOtherEvent(event) {
      this.manager.emit(event.type, event);
    }
  }]);
  return EventManager;
}();

exports.default = EventManager;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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