'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _constants = require('../constants');

var _globals = require('../utils/globals');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var firefox = _globals.userAgent.indexOf('firefox') !== -1;

var WHEEL_EVENTS = _constants.INPUT_EVENT_TYPES.WHEEL_EVENTS;

var EVENT_TYPE = 'wheel';

// Constants for normalizing input delta
var WHEEL_DELTA_MAGIC_SCALER = 4.000244140625;
var WHEEL_DELTA_PER_LINE = 40;
// Slow down zoom if shift key is held for more precise zooming
var SHIFT_MULTIPLIER = 0.25;

var WheelInput = function () {
  function WheelInput(element, callback) {
    var _this = this;

    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    (0, _classCallCheck3.default)(this, WheelInput);

    this.element = element;
    this.callback = callback;

    this.options = (0, _assign2.default)({ enable: true }, options);

    this.events = WHEEL_EVENTS.concat(options.events || []);

    this.handleEvent = this.handleEvent.bind(this);
    this.events.forEach(function (event) {
      return element.addEventListener(event, _this.handleEvent);
    });
  }

  (0, _createClass3.default)(WheelInput, [{
    key: 'destroy',
    value: function destroy() {
      var _this2 = this;

      this.events.forEach(function (event) {
        return _this2.element.removeEventListener(event, _this2.handleEvent);
      });
    }

    /**
     * Enable this input (begin processing events)
     * if the specified event type is among those handled by this input.
     */

  }, {
    key: 'enableEventType',
    value: function enableEventType(eventType, enabled) {
      if (eventType === EVENT_TYPE) {
        this.options.enable = enabled;
      }
    }

    /* eslint-disable complexity, max-statements */

  }, {
    key: 'handleEvent',
    value: function handleEvent(event) {
      if (!this.options.enable) {
        return;
      }
      if (this.options.legacyBlockScroll) {
        event.preventDefault();
      }

      var value = event.deltaY;
      if (_globals.window.WheelEvent) {
        // Firefox doubles the values on retina screens...
        if (firefox && event.deltaMode === _globals.window.WheelEvent.DOM_DELTA_PIXEL) {
          value /= _globals.window.devicePixelRatio;
        }
        if (event.deltaMode === _globals.window.WheelEvent.DOM_DELTA_LINE) {
          value *= WHEEL_DELTA_PER_LINE;
        }
      }

      var wheelPosition = {
        x: event.clientX,
        y: event.clientY
      };

      if (value !== 0 && value % WHEEL_DELTA_MAGIC_SCALER === 0) {
        // This one is definitely a mouse wheel event.
        // Normalize this value to match trackpad.
        value = Math.floor(value / WHEEL_DELTA_MAGIC_SCALER);
      }

      if (event.shiftKey && value) {
        value = value * SHIFT_MULTIPLIER;
      }

      this._onWheel(event, -value, wheelPosition);
    }
  }, {
    key: '_onWheel',
    value: function _onWheel(srcEvent, delta, position) {
      this.callback({
        type: EVENT_TYPE,
        center: position,
        delta: delta,
        srcEvent: srcEvent,
        pointerType: 'mouse',
        target: srcEvent.target
      });
    }
  }]);
  return WheelInput;
}();

exports.default = WheelInput;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9pbnB1dHMvd2hlZWwtaW5wdXQuanMiXSwibmFtZXMiOlsiZmlyZWZveCIsImluZGV4T2YiLCJXSEVFTF9FVkVOVFMiLCJFVkVOVF9UWVBFIiwiV0hFRUxfREVMVEFfTUFHSUNfU0NBTEVSIiwiV0hFRUxfREVMVEFfUEVSX0xJTkUiLCJTSElGVF9NVUxUSVBMSUVSIiwiV2hlZWxJbnB1dCIsImVsZW1lbnQiLCJjYWxsYmFjayIsIm9wdGlvbnMiLCJlbmFibGUiLCJldmVudHMiLCJjb25jYXQiLCJoYW5kbGVFdmVudCIsImJpbmQiLCJmb3JFYWNoIiwiYWRkRXZlbnRMaXN0ZW5lciIsImV2ZW50IiwicmVtb3ZlRXZlbnRMaXN0ZW5lciIsImV2ZW50VHlwZSIsImVuYWJsZWQiLCJsZWdhY3lCbG9ja1Njcm9sbCIsInByZXZlbnREZWZhdWx0IiwidmFsdWUiLCJkZWx0YVkiLCJXaGVlbEV2ZW50IiwiZGVsdGFNb2RlIiwiRE9NX0RFTFRBX1BJWEVMIiwiZGV2aWNlUGl4ZWxSYXRpbyIsIkRPTV9ERUxUQV9MSU5FIiwid2hlZWxQb3NpdGlvbiIsIngiLCJjbGllbnRYIiwieSIsImNsaWVudFkiLCJNYXRoIiwiZmxvb3IiLCJzaGlmdEtleSIsIl9vbldoZWVsIiwic3JjRXZlbnQiLCJkZWx0YSIsInBvc2l0aW9uIiwidHlwZSIsImNlbnRlciIsInBvaW50ZXJUeXBlIiwidGFyZ2V0Il0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFvQkE7O0FBQ0E7Ozs7QUFyQkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBS0EsSUFBTUEsVUFBVSxtQkFBVUMsT0FBVixDQUFrQixTQUFsQixNQUFpQyxDQUFDLENBQWxEOztJQUVPQyxZLGdDQUFBQSxZOztBQUNQLElBQU1DLGFBQWEsT0FBbkI7O0FBRUE7QUFDQSxJQUFNQywyQkFBMkIsY0FBakM7QUFDQSxJQUFNQyx1QkFBdUIsRUFBN0I7QUFDQTtBQUNBLElBQU1DLG1CQUFtQixJQUF6Qjs7SUFFcUJDLFU7QUFFbkIsc0JBQVlDLE9BQVosRUFBcUJDLFFBQXJCLEVBQTZDO0FBQUE7O0FBQUEsUUFBZEMsT0FBYyx1RUFBSixFQUFJO0FBQUE7O0FBQzNDLFNBQUtGLE9BQUwsR0FBZUEsT0FBZjtBQUNBLFNBQUtDLFFBQUwsR0FBZ0JBLFFBQWhCOztBQUVBLFNBQUtDLE9BQUwsR0FBZSxzQkFBYyxFQUFDQyxRQUFRLElBQVQsRUFBZCxFQUE4QkQsT0FBOUIsQ0FBZjs7QUFFQSxTQUFLRSxNQUFMLEdBQWNWLGFBQWFXLE1BQWIsQ0FBb0JILFFBQVFFLE1BQVIsSUFBa0IsRUFBdEMsQ0FBZDs7QUFFQSxTQUFLRSxXQUFMLEdBQW1CLEtBQUtBLFdBQUwsQ0FBaUJDLElBQWpCLENBQXNCLElBQXRCLENBQW5CO0FBQ0EsU0FBS0gsTUFBTCxDQUFZSSxPQUFaLENBQW9CO0FBQUEsYUFBU1IsUUFBUVMsZ0JBQVIsQ0FBeUJDLEtBQXpCLEVBQWdDLE1BQUtKLFdBQXJDLENBQVQ7QUFBQSxLQUFwQjtBQUNEOzs7OzhCQUVTO0FBQUE7O0FBQ1IsV0FBS0YsTUFBTCxDQUFZSSxPQUFaLENBQW9CO0FBQUEsZUFBUyxPQUFLUixPQUFMLENBQWFXLG1CQUFiLENBQWlDRCxLQUFqQyxFQUF3QyxPQUFLSixXQUE3QyxDQUFUO0FBQUEsT0FBcEI7QUFDRDs7QUFFRDs7Ozs7OztvQ0FJZ0JNLFMsRUFBV0MsTyxFQUFTO0FBQ2xDLFVBQUlELGNBQWNqQixVQUFsQixFQUE4QjtBQUM1QixhQUFLTyxPQUFMLENBQWFDLE1BQWIsR0FBc0JVLE9BQXRCO0FBQ0Q7QUFDRjs7QUFFRDs7OztnQ0FDWUgsSyxFQUFPO0FBQ2pCLFVBQUksQ0FBQyxLQUFLUixPQUFMLENBQWFDLE1BQWxCLEVBQTBCO0FBQ3hCO0FBQ0Q7QUFDRCxVQUFJLEtBQUtELE9BQUwsQ0FBYVksaUJBQWpCLEVBQW9DO0FBQ2xDSixjQUFNSyxjQUFOO0FBQ0Q7O0FBRUQsVUFBSUMsUUFBUU4sTUFBTU8sTUFBbEI7QUFDQSxVQUFJLGdCQUFPQyxVQUFYLEVBQXVCO0FBQ3JCO0FBQ0EsWUFBSTFCLFdBQVdrQixNQUFNUyxTQUFOLEtBQW9CLGdCQUFPRCxVQUFQLENBQWtCRSxlQUFyRCxFQUFzRTtBQUNwRUosbUJBQVMsZ0JBQU9LLGdCQUFoQjtBQUNEO0FBQ0QsWUFBSVgsTUFBTVMsU0FBTixLQUFvQixnQkFBT0QsVUFBUCxDQUFrQkksY0FBMUMsRUFBMEQ7QUFDeEROLG1CQUFTbkIsb0JBQVQ7QUFDRDtBQUNGOztBQUVELFVBQU0wQixnQkFBZ0I7QUFDcEJDLFdBQUdkLE1BQU1lLE9BRFc7QUFFcEJDLFdBQUdoQixNQUFNaUI7QUFGVyxPQUF0Qjs7QUFLQSxVQUFJWCxVQUFVLENBQVYsSUFBZUEsUUFBUXBCLHdCQUFSLEtBQXFDLENBQXhELEVBQTJEO0FBQ3pEO0FBQ0E7QUFDQW9CLGdCQUFRWSxLQUFLQyxLQUFMLENBQVdiLFFBQVFwQix3QkFBbkIsQ0FBUjtBQUNEOztBQUVELFVBQUljLE1BQU1vQixRQUFOLElBQWtCZCxLQUF0QixFQUE2QjtBQUMzQkEsZ0JBQVFBLFFBQVFsQixnQkFBaEI7QUFDRDs7QUFFRCxXQUFLaUMsUUFBTCxDQUFjckIsS0FBZCxFQUFxQixDQUFDTSxLQUF0QixFQUE2Qk8sYUFBN0I7QUFDRDs7OzZCQUVRUyxRLEVBQVVDLEssRUFBT0MsUSxFQUFVO0FBQ2xDLFdBQUtqQyxRQUFMLENBQWM7QUFDWmtDLGNBQU14QyxVQURNO0FBRVp5QyxnQkFBUUYsUUFGSTtBQUdaRCxvQkFIWTtBQUlaRCwwQkFKWTtBQUtaSyxxQkFBYSxPQUxEO0FBTVpDLGdCQUFRTixTQUFTTTtBQU5MLE9BQWQ7QUFRRDs7Ozs7a0JBM0VrQnZDLFUiLCJmaWxlIjoid2hlZWwtaW5wdXQuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgKGMpIDIwMTcgVWJlciBUZWNobm9sb2dpZXMsIEluYy5cbi8vXG4vLyBQZXJtaXNzaW9uIGlzIGhlcmVieSBncmFudGVkLCBmcmVlIG9mIGNoYXJnZSwgdG8gYW55IHBlcnNvbiBvYnRhaW5pbmcgYSBjb3B5XG4vLyBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGRvY3VtZW50YXRpb24gZmlsZXMgKHRoZSBcIlNvZnR3YXJlXCIpLCB0byBkZWFsXG4vLyBpbiB0aGUgU29mdHdhcmUgd2l0aG91dCByZXN0cmljdGlvbiwgaW5jbHVkaW5nIHdpdGhvdXQgbGltaXRhdGlvbiB0aGUgcmlnaHRzXG4vLyB0byB1c2UsIGNvcHksIG1vZGlmeSwgbWVyZ2UsIHB1Ymxpc2gsIGRpc3RyaWJ1dGUsIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsXG4vLyBjb3BpZXMgb2YgdGhlIFNvZnR3YXJlLCBhbmQgdG8gcGVybWl0IHBlcnNvbnMgdG8gd2hvbSB0aGUgU29mdHdhcmUgaXNcbi8vIGZ1cm5pc2hlZCB0byBkbyBzbywgc3ViamVjdCB0byB0aGUgZm9sbG93aW5nIGNvbmRpdGlvbnM6XG4vL1xuLy8gVGhlIGFib3ZlIGNvcHlyaWdodCBub3RpY2UgYW5kIHRoaXMgcGVybWlzc2lvbiBub3RpY2Ugc2hhbGwgYmUgaW5jbHVkZWQgaW5cbi8vIGFsbCBjb3BpZXMgb3Igc3Vic3RhbnRpYWwgcG9ydGlvbnMgb2YgdGhlIFNvZnR3YXJlLlxuLy9cbi8vIFRIRSBTT0ZUV0FSRSBJUyBQUk9WSURFRCBcIkFTIElTXCIsIFdJVEhPVVQgV0FSUkFOVFkgT0YgQU5ZIEtJTkQsIEVYUFJFU1MgT1Jcbi8vIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuLy8gRklUTkVTUyBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UgQU5EIE5PTklORlJJTkdFTUVOVC4gSU4gTk8gRVZFTlQgU0hBTEwgVEhFXG4vLyBBVVRIT1JTIE9SIENPUFlSSUdIVCBIT0xERVJTIEJFIExJQUJMRSBGT1IgQU5ZIENMQUlNLCBEQU1BR0VTIE9SIE9USEVSXG4vLyBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuLy8gT1VUIE9GIE9SIElOIENPTk5FQ1RJT04gV0lUSCBUSEUgU09GVFdBUkUgT1IgVEhFIFVTRSBPUiBPVEhFUiBERUFMSU5HUyBJTlxuLy8gVEhFIFNPRlRXQVJFLlxuXG5pbXBvcnQge0lOUFVUX0VWRU5UX1RZUEVTfSBmcm9tICcuLi9jb25zdGFudHMnO1xuaW1wb3J0IHt3aW5kb3csIHVzZXJBZ2VudH0gZnJvbSAnLi4vdXRpbHMvZ2xvYmFscyc7XG5cbmNvbnN0IGZpcmVmb3ggPSB1c2VyQWdlbnQuaW5kZXhPZignZmlyZWZveCcpICE9PSAtMTtcblxuY29uc3Qge1dIRUVMX0VWRU5UU30gPSBJTlBVVF9FVkVOVF9UWVBFUztcbmNvbnN0IEVWRU5UX1RZUEUgPSAnd2hlZWwnO1xuXG4vLyBDb25zdGFudHMgZm9yIG5vcm1hbGl6aW5nIGlucHV0IGRlbHRhXG5jb25zdCBXSEVFTF9ERUxUQV9NQUdJQ19TQ0FMRVIgPSA0LjAwMDI0NDE0MDYyNTtcbmNvbnN0IFdIRUVMX0RFTFRBX1BFUl9MSU5FID0gNDA7XG4vLyBTbG93IGRvd24gem9vbSBpZiBzaGlmdCBrZXkgaXMgaGVsZCBmb3IgbW9yZSBwcmVjaXNlIHpvb21pbmdcbmNvbnN0IFNISUZUX01VTFRJUExJRVIgPSAwLjI1O1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBXaGVlbElucHV0IHtcblxuICBjb25zdHJ1Y3RvcihlbGVtZW50LCBjYWxsYmFjaywgb3B0aW9ucyA9IHt9KSB7XG4gICAgdGhpcy5lbGVtZW50ID0gZWxlbWVudDtcbiAgICB0aGlzLmNhbGxiYWNrID0gY2FsbGJhY2s7XG5cbiAgICB0aGlzLm9wdGlvbnMgPSBPYmplY3QuYXNzaWduKHtlbmFibGU6IHRydWV9LCBvcHRpb25zKTtcblxuICAgIHRoaXMuZXZlbnRzID0gV0hFRUxfRVZFTlRTLmNvbmNhdChvcHRpb25zLmV2ZW50cyB8fCBbXSk7XG5cbiAgICB0aGlzLmhhbmRsZUV2ZW50ID0gdGhpcy5oYW5kbGVFdmVudC5iaW5kKHRoaXMpO1xuICAgIHRoaXMuZXZlbnRzLmZvckVhY2goZXZlbnQgPT4gZWxlbWVudC5hZGRFdmVudExpc3RlbmVyKGV2ZW50LCB0aGlzLmhhbmRsZUV2ZW50KSk7XG4gIH1cblxuICBkZXN0cm95KCkge1xuICAgIHRoaXMuZXZlbnRzLmZvckVhY2goZXZlbnQgPT4gdGhpcy5lbGVtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoZXZlbnQsIHRoaXMuaGFuZGxlRXZlbnQpKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBFbmFibGUgdGhpcyBpbnB1dCAoYmVnaW4gcHJvY2Vzc2luZyBldmVudHMpXG4gICAqIGlmIHRoZSBzcGVjaWZpZWQgZXZlbnQgdHlwZSBpcyBhbW9uZyB0aG9zZSBoYW5kbGVkIGJ5IHRoaXMgaW5wdXQuXG4gICAqL1xuICBlbmFibGVFdmVudFR5cGUoZXZlbnRUeXBlLCBlbmFibGVkKSB7XG4gICAgaWYgKGV2ZW50VHlwZSA9PT0gRVZFTlRfVFlQRSkge1xuICAgICAgdGhpcy5vcHRpb25zLmVuYWJsZSA9IGVuYWJsZWQ7XG4gICAgfVxuICB9XG5cbiAgLyogZXNsaW50LWRpc2FibGUgY29tcGxleGl0eSwgbWF4LXN0YXRlbWVudHMgKi9cbiAgaGFuZGxlRXZlbnQoZXZlbnQpIHtcbiAgICBpZiAoIXRoaXMub3B0aW9ucy5lbmFibGUpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgaWYgKHRoaXMub3B0aW9ucy5sZWdhY3lCbG9ja1Njcm9sbCkge1xuICAgICAgZXZlbnQucHJldmVudERlZmF1bHQoKTtcbiAgICB9XG5cbiAgICBsZXQgdmFsdWUgPSBldmVudC5kZWx0YVk7XG4gICAgaWYgKHdpbmRvdy5XaGVlbEV2ZW50KSB7XG4gICAgICAvLyBGaXJlZm94IGRvdWJsZXMgdGhlIHZhbHVlcyBvbiByZXRpbmEgc2NyZWVucy4uLlxuICAgICAgaWYgKGZpcmVmb3ggJiYgZXZlbnQuZGVsdGFNb2RlID09PSB3aW5kb3cuV2hlZWxFdmVudC5ET01fREVMVEFfUElYRUwpIHtcbiAgICAgICAgdmFsdWUgLz0gd2luZG93LmRldmljZVBpeGVsUmF0aW87XG4gICAgICB9XG4gICAgICBpZiAoZXZlbnQuZGVsdGFNb2RlID09PSB3aW5kb3cuV2hlZWxFdmVudC5ET01fREVMVEFfTElORSkge1xuICAgICAgICB2YWx1ZSAqPSBXSEVFTF9ERUxUQV9QRVJfTElORTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBjb25zdCB3aGVlbFBvc2l0aW9uID0ge1xuICAgICAgeDogZXZlbnQuY2xpZW50WCxcbiAgICAgIHk6IGV2ZW50LmNsaWVudFlcbiAgICB9O1xuXG4gICAgaWYgKHZhbHVlICE9PSAwICYmIHZhbHVlICUgV0hFRUxfREVMVEFfTUFHSUNfU0NBTEVSID09PSAwKSB7XG4gICAgICAvLyBUaGlzIG9uZSBpcyBkZWZpbml0ZWx5IGEgbW91c2Ugd2hlZWwgZXZlbnQuXG4gICAgICAvLyBOb3JtYWxpemUgdGhpcyB2YWx1ZSB0byBtYXRjaCB0cmFja3BhZC5cbiAgICAgIHZhbHVlID0gTWF0aC5mbG9vcih2YWx1ZSAvIFdIRUVMX0RFTFRBX01BR0lDX1NDQUxFUik7XG4gICAgfVxuXG4gICAgaWYgKGV2ZW50LnNoaWZ0S2V5ICYmIHZhbHVlKSB7XG4gICAgICB2YWx1ZSA9IHZhbHVlICogU0hJRlRfTVVMVElQTElFUjtcbiAgICB9XG5cbiAgICB0aGlzLl9vbldoZWVsKGV2ZW50LCAtdmFsdWUsIHdoZWVsUG9zaXRpb24pO1xuICB9XG5cbiAgX29uV2hlZWwoc3JjRXZlbnQsIGRlbHRhLCBwb3NpdGlvbikge1xuICAgIHRoaXMuY2FsbGJhY2soe1xuICAgICAgdHlwZTogRVZFTlRfVFlQRSxcbiAgICAgIGNlbnRlcjogcG9zaXRpb24sXG4gICAgICBkZWx0YSxcbiAgICAgIHNyY0V2ZW50LFxuICAgICAgcG9pbnRlclR5cGU6ICdtb3VzZScsXG4gICAgICB0YXJnZXQ6IHNyY0V2ZW50LnRhcmdldFxuICAgIH0pO1xuICB9XG59XG4iXX0=