"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _isFinite = require("babel-runtime/core-js/number/is-finite");

var _isFinite2 = _interopRequireDefault(_isFinite);

exports.whichButtons = whichButtons;
exports.getOffsetPosition = getOffsetPosition;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Constants */
var DOWN_EVENT = 1;
var MOVE_EVENT = 2;
var UP_EVENT = 4;
var MOUSE_EVENTS = {
  pointerdown: DOWN_EVENT,
  pointermove: MOVE_EVENT,
  pointerup: UP_EVENT,
  mousedown: DOWN_EVENT,
  mousemove: MOVE_EVENT,
  mouseup: UP_EVENT
};

// MouseEvent.which https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/which
var MOUSE_EVENT_WHICH_LEFT = 1;
var MOUSE_EVENT_WHICH_MIDDLE = 2;
var MOUSE_EVENT_WHICH_RIGHT = 3;
// MouseEvent.button https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/button
var MOUSE_EVENT_BUTTON_LEFT = 0;
var MOUSE_EVENT_BUTTON_MIDDLE = 1;
var MOUSE_EVENT_BUTTON_RIGHT = 2;
// MouseEvent.buttons https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/buttons
var MOUSE_EVENT_BUTTONS_LEFT_MASK = 1;
var MOUSE_EVENT_BUTTONS_RIGHT_MASK = 2;
var MOUSE_EVENT_BUTTONS_MIDDLE_MASK = 4;

/**
 * Extract the involved mouse button
 */
function whichButtons(event) {
  var eventType = MOUSE_EVENTS[event.srcEvent.type];
  if (!eventType) {
    // Not a mouse evet
    return null;
  }

  var _event$srcEvent = event.srcEvent,
      buttons = _event$srcEvent.buttons,
      button = _event$srcEvent.button,
      which = _event$srcEvent.which;

  var leftButton = false;
  var middleButton = false;
  var rightButton = false;

  if (
  // button is up, need to find out which one was pressed before
  eventType === UP_EVENT ||
  // moving but does not support `buttons` API
  eventType === MOVE_EVENT && !(0, _isFinite2.default)(buttons)) {
    leftButton = which === MOUSE_EVENT_WHICH_LEFT;
    middleButton = which === MOUSE_EVENT_WHICH_MIDDLE;
    rightButton = which === MOUSE_EVENT_WHICH_RIGHT;
  } else if (eventType === MOVE_EVENT) {
    leftButton = Boolean(buttons & MOUSE_EVENT_BUTTONS_LEFT_MASK);
    middleButton = Boolean(buttons & MOUSE_EVENT_BUTTONS_MIDDLE_MASK);
    rightButton = Boolean(buttons & MOUSE_EVENT_BUTTONS_RIGHT_MASK);
  } else if (eventType === DOWN_EVENT) {
    leftButton = button === MOUSE_EVENT_BUTTON_LEFT;
    middleButton = button === MOUSE_EVENT_BUTTON_MIDDLE;
    rightButton = button === MOUSE_EVENT_BUTTON_RIGHT;
  }

  return { leftButton: leftButton, middleButton: middleButton, rightButton: rightButton };
}

/**
 * Calculate event position relative to the root element
 */
function getOffsetPosition(event, rootElement) {
  var srcEvent = event.srcEvent;

  // `center` is a hammer.js event property

  if (!event.center && !(0, _isFinite2.default)(srcEvent.clientX)) {
    // Not a gestural event
    return null;
  }

  var center = event.center || {
    x: srcEvent.clientX,
    y: srcEvent.clientY
  };

  var rect = rootElement.getBoundingClientRect();

  // Fix scale for map affected by a CSS transform.
  // See https://stackoverflow.com/a/26893663/3528533
  var scaleX = rect.width / rootElement.offsetWidth;
  var scaleY = rect.height / rootElement.offsetHeight;

  // Calculate center relative to the root element
  var offsetCenter = {
    x: (center.x - rect.left - rootElement.clientLeft) / scaleX,
    y: (center.y - rect.top - rootElement.clientTop) / scaleY
  };

  return { center: center, offsetCenter: offsetCenter };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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