'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Manager = undefined;

var _isBrowser = require('./is-browser');

var _isBrowser2 = _interopRequireDefault(_isBrowser);

var _hammerOverrides = require('./hammer-overrides');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var hammerjs = void 0;
if (_isBrowser2.default) {
  hammerjs = require('hammerjs');
}

// Hammer.Manager mock for use in environments without `document` / `window`.
function HammerManagerMock(m) {
  var instance = {};
  var chainedNoop = function chainedNoop() {
    return instance;
  };
  instance.get = function () {
    return null;
  };
  instance.set = chainedNoop;
  instance.on = chainedNoop;
  instance.off = chainedNoop;
  instance.destroy = chainedNoop;
  instance.emit = chainedNoop;
  return instance;
}

if (hammerjs) {
  (0, _hammerOverrides.enhancePointerEventInput)(hammerjs.PointerEventInput);
  (0, _hammerOverrides.enhanceMouseInput)(hammerjs.MouseInput);
}

var Manager = exports.Manager = hammerjs ? hammerjs.Manager : HammerManagerMock;

exports.default = hammerjs;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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