'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof2 = require('babel-runtime/helpers/typeof');

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// based on https://github.com/uber/luma.gl/blob/master/src/utils/is-electron.js
/* global window, process, navigator */
function isElectron() {
  // Renderer process
  if (typeof window !== 'undefined' && (0, _typeof3.default)(window.process) === 'object' && window.process.type === 'renderer') {
    return true;
  }
  // Main process
  if (typeof process !== 'undefined' && (0, _typeof3.default)(process.versions) === 'object' && Boolean(process.versions.electron)) {
    return true;
  }
  // Detect the user agent when the `nodeIntegration` option is set to true
  if ((typeof navigator === 'undefined' ? 'undefined' : (0, _typeof3.default)(navigator)) === 'object' && typeof navigator.userAgent === 'string' && navigator.userAgent.indexOf('Electron') >= 0) {
    return true;
  }
  return false;
}

exports.default = isElectron();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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