'use strict';var _createClass=function(){function defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,'value'in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}return function(Constructor,protoProps,staticProps){return protoProps&&defineProperties(Constructor.prototype,protoProps),staticProps&&defineProperties(Constructor,staticProps),Constructor}}();Object.defineProperty(exports,'__esModule',{value:!0}),exports.LOG_ENTRY=void 0;exports.logResultsAsMarkdownTable=logResultsAsMarkdownTable,exports.logResultsAsTree=logResultsAsTree,exports.logResultsAsTreeWithElapsed=logResultsAsTreeWithElapsed;var _formatters=require('../lib/utils/formatters'),_globals=require('../lib/utils/globals'),_autobind=require('../lib/utils/autobind'),_localStorage=require('../lib/utils/local-storage'),_localStorage2=_interopRequireDefault(_localStorage),_assert=require('assert'),_assert2=_interopRequireDefault(_assert);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError('Cannot call a class as a function')}var noop=function(){},TIME_THRESHOLD_MS=80,TIME_COOLDOWN_MS=5,MIN_ITERATIONS=1,LOG_ENTRY=exports.LOG_ENTRY={GROUP:'group',TEST:'test',COMPLETE:'complete'},CALIBRATION_TESTS=[{id:'warmup',initFunc:noop,testFunc:function testFunc(){return 100},opts:{}}],Bench=function(){function Bench(){var _ref=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},id=_ref.id,log=_ref.log,_ref$time=_ref.time,time=void 0===_ref$time?TIME_THRESHOLD_MS:_ref$time,_ref$delay=_ref.delay,delay=void 0===_ref$delay?TIME_COOLDOWN_MS:_ref$delay,_ref$minIterations=_ref.minIterations,minIterations=void 0===_ref$minIterations?MIN_ITERATIONS:_ref$minIterations;if(_classCallCheck(this,Bench),!log){var markdown=_globals.global.probe&&_globals.global.probe.markdown;log=markdown?logResultsAsMarkdownTable:logResultsAsTree}this.id=id,this.opts={log:log,time:time,delay:delay,minIterations:minIterations},this.tests={},this.results={},this.table={},(0,_autobind.autobind)(this),Object.seal(this)}var _Mathround=Math.round;return _createClass(Bench,[{key:'calibrate',value:function calibrate(){return this}},{key:'run',value:function run(){var _this=this,timer=new Date,tests=this.tests,onBenchmarkComplete=this.onBenchmarkComplete,promise=runAsyncTests({tests:tests,onBenchmarkComplete:onBenchmarkComplete});return promise.then(function(){var elapsed=(new Date-timer)/1e3;logEntry(_this,{entry:LOG_ENTRY.COMPLETE,time:elapsed,message:'Complete'}),_this.onSuiteComplete()}),promise}},{key:'group',value:function group(id){return(0,_assert2.default)(!this.tests[id],'tests need unique id strings'),this.tests[id]={id:id,group:!0,opts:this.opts},this}},{key:'add',value:function add(priority,id,func1,func2){'string'==typeof priority&&(func2=func1,func1=id,id=priority,priority=0),(0,_assert2.default)(id),(0,_assert2.default)('function'==typeof func1);var initFunc=null,testFunc=func1;return'function'==typeof func2&&(initFunc=func1,testFunc=func2),(0,_assert2.default)(!this.tests[id],'tests need unique id strings'),this.tests[id]={id:id,priority:priority,initFunc:initFunc,testFunc:testFunc,opts:this.opts},this}},{key:'onBenchmarkComplete',value:function onBenchmarkComplete(_ref2){var id=_ref2.id,time=_ref2.time,iterations=_ref2.iterations,itersPerSecond=_ref2.itersPerSecond,current=_Mathround(iterations/time);this.table[id]={percent:'',iterations:itersPerSecond+'/s',current:current,max:''}}},{key:'onSuiteComplete',value:function onSuiteComplete(){var localStorage=new _localStorage2.default({id:this.id}),saved=localStorage.getConfiguration(),current=this.updateTable(this.table,saved);localStorage.updateConfiguration(current),console.table(current)}},{key:'updateTable',value:function updateTable(current,saved){for(var id in this.table)if(saved[id]&&void 0!==saved[id].max){current[id].max=Math.max(current[id].current,saved[id].max);var delta=current[id].current/saved[id].max;current[id].percent=_Mathround(100*delta-100)+'%'}else current[id].max=current[id].current;return current}}]),Bench}();exports.default=Bench;function runCalibrationTests(_ref3){var tests=_ref3.tests,promise=Promise.resolve(!0),_iteratorNormalCompletion=!0,_didIteratorError=!1,_iteratorError=void 0;try{for(var _step,_loop=function(){var test=_step.value;promise=promise.then(function(){return runAsyncTest({test:test,silent:!0})})},_iterator=CALIBRATION_TESTS[Symbol.iterator]();!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=!0)_loop()}catch(err){_didIteratorError=!0,_iteratorError=err}finally{try{!_iteratorNormalCompletion&&_iterator.return&&_iterator.return()}finally{if(_didIteratorError)throw _iteratorError}}return promise}function runAsyncTests(_ref4){var tests=_ref4.tests,_ref4$onBenchmarkComp=_ref4.onBenchmarkComplete,onBenchmarkComplete=_ref4$onBenchmarkComp===void 0?noop:_ref4$onBenchmarkComp,promise=runCalibrationTests({tests:tests,onBenchmarkComplete:onBenchmarkComplete}),_loop2=function(id){var test=tests[id];promise=promise.then(function(){return runAsyncTest({test:test,onBenchmarkComplete:onBenchmarkComplete})})};for(var id in tests)_loop2(id);return promise}function runAsyncTest(_ref5){var test=_ref5.test,onBenchmarkComplete=_ref5.onBenchmarkComplete,_ref5$silent=_ref5.silent;return new Promise(function(resolve){setTimeout(function(){try{if(test.group)logEntry(test,{entry:LOG_ENTRY.GROUP,id:test.id,message:test.id});else{var _runBenchTest=runBenchTest(test),time=_runBenchTest.time,iterations=_runBenchTest.iterations,iterationsPerSecond=iterations/time,itersPerSecond=(0,_formatters.formatSI)(iterationsPerSecond);_ref5$silent!==void 0&&_ref5$silent||logEntry(test,{entry:LOG_ENTRY.TEST,id:test.id,priority:test.priority,itersPerSecond:itersPerSecond,time:time,message:test.id+' '+itersPerSecond+'/s'}),onBenchmarkComplete&&onBenchmarkComplete({id:test.id,time:time,iterations:iterations,iterationsPerSecond:iterationsPerSecond,itersPerSecond:itersPerSecond})}}finally{resolve(!0)}},test.opts.delay)})}function runBenchTest(test){for(var iterations=test.opts.minIterations/10,elapsedMillis=0;elapsedMillis<test.opts.time;){var multiplier=10;10<elapsedMillis&&(multiplier=1.25*(test.opts.time/elapsedMillis)),iterations*=multiplier;var timer=new Date;runBenchTestIterations(test,iterations),elapsedMillis=new Date-timer}var time=elapsedMillis/1e3;return{time:time,iterations:iterations}}function runBenchTestIterations(test,iterations){var testArgs=test.initFunc&&test.initFunc(),context=test.context,testFunc=test.testFunc;if(context&&testArgs)for(var i=0;i<iterations;i++)testFunc.call(context,testArgs);else for(var _i=0;_i<iterations;_i++)testFunc.call(context)}function logEntry(test,opts){var priority=10|(_globals.global.probe&&_globals.global.probe.priority);(0|opts.priority)<=priority&&test.opts.log(opts)}function logResultsAsMarkdownTable(_ref6){var entry=_ref6.entry,id=_ref6.id,itersPerSecond=_ref6.itersPerSecond,time=_ref6.time,COL1=50;switch(entry){case LOG_ENTRY.GROUP:console.log(''),console.log('| '+(0,_formatters.rightPad)(id,COL1)+' | iterations/s |'),console.log('| '+(0,_formatters.rightPad)('---',COL1)+' | ---          |');break;case LOG_ENTRY.TEST:console.log('| '+(0,_formatters.rightPad)(id,COL1)+' | '+(0,_formatters.rightPad)(itersPerSecond,12)+' |');break;case LOG_ENTRY.COMPLETE:console.log(''),console.log('Completed benchmark in '+time+'s');break;default:}}function logResultsAsTree(_ref7){var entry=_ref7.entry,id=_ref7.id,itersPerSecond=_ref7.itersPerSecond,time=_ref7.time;switch(entry){case LOG_ENTRY.GROUP:console.log(''),console.log(''+id);break;case LOG_ENTRY.TEST:console.log('\u251C\u2500 '+id+': '+itersPerSecond+' iterations/s');break;case LOG_ENTRY.COMPLETE:console.log(''),console.log('Completed benchmark in '+time+'s');break;default:}}function logResultsAsTreeWithElapsed(_ref8){var entry=_ref8.entry,id=_ref8.id,itersPerSecond=_ref8.itersPerSecond,time=_ref8.time;entry===LOG_ENTRY.TEST?console.log('\u251C\u2500 '+id+': '+itersPerSecond+' iterations/s ('+time.toFixed(2)+'s elapsed)'):logResultsAsTree({entry:entry,id:id,itersPerSecond:itersPerSecond,time:time})}
//# sourceMappingURL=bench.js.map