'use strict';Object.defineProperty(exports,'__esModule',{value:!0});var _typeof='function'==typeof Symbol&&'symbol'==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&'function'==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?'symbol':typeof obj},_createClass=function(){function defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,'value'in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}return function(Constructor,protoProps,staticProps){return protoProps&&defineProperties(Constructor.prototype,protoProps),staticProps&&defineProperties(Constructor,staticProps),Constructor}}(),_globals=require('./utils/globals'),_localStorage=require('./utils/local-storage'),_localStorage2=_interopRequireDefault(_localStorage),_timestamp=require('./utils/timestamp'),_formatters=require('./utils/formatters'),_color=require('./utils/color'),_autobind=require('./utils/autobind'),_assert=require('../lib/utils/assert'),_assert2=_interopRequireDefault(_assert);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++)arr2[i]=arr[i];return arr2}return Array.from(arr)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError('Cannot call a class as a function')}var originalConsole={debug:_globals.isBrowser?console.debug||console.log:console.log,log:console.log,info:console.info,warn:console.warn,error:console.error},DEFAULT_SETTINGS={enabled:!1,priority:0};function noop(){}var cache={};function getTableHeader(table){for(var key in table)for(var title in table[key])return title||'untitled';return'empty'}var Log=function(){function Log(){var _ref=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},id=_ref.id;_classCallCheck(this,Log),this.id=id,this.VERSION=_globals.VERSION,this._startTs=(0,_timestamp.getTimestamp)(),this._deltaTs=(0,_timestamp.getTimestamp)(),this.LOG_THROTTLE_TIMEOUT=0,this._storage=new _localStorage2.default('__probe-'+this.id+'__',DEFAULT_SETTINGS),this.userData={},this.timeStamp(this.id+' started'),(0,_autobind.autobind)(this),Object.seal(this)}return _createClass(Log,[{key:'isEnabled',value:function isEnabled(){return this._storage.config.enabled}},{key:'getPriority',value:function getPriority(){return this._storage.config.priority}},{key:'getLevel',value:function getLevel(){return this._storage.config.priority}},{key:'getTotal',value:function getTotal(){return+((0,_timestamp.getTimestamp)()-this._startTs).toPrecision(10)}},{key:'getDelta',value:function getDelta(){return+((0,_timestamp.getTimestamp)()-this._deltaTs).toPrecision(10)}},{key:'enable',value:function enable(){var enabled=!(0<arguments.length&&void 0!==arguments[0])||arguments[0];return this._storage.updateConfiguration({enabled:enabled}),this}},{key:'setLevel',value:function setLevel(level){return this._storage.updateConfiguration({priority:level}),this}},{key:'warn',value:function warn(message){for(var _len=arguments.length,args=Array(1<_len?_len-1:0),_key=1;_key<_len;_key++)args[_key-1]=arguments[_key];return this._getLogFunction({message:message,args:args,method:originalConsole.warn,once:!0})}},{key:'error',value:function error(message){for(var _len2=arguments.length,args=Array(1<_len2?_len2-1:0),_key2=1;_key2<_len2;_key2++)args[_key2-1]=arguments[_key2];return this._getLogFunction({message:message,args:args,method:originalConsole.error})}},{key:'deprecated',value:function deprecated(oldUsage,newUsage){return this.warn('`'+oldUsage+'` is deprecated and will be removed in a later version. Use `'+newUsage+'` instead')}},{key:'removed',value:function removed(oldUsage,newUsage){return this.error('`'+oldUsage+'` has been removed. Use `'+newUsage+'` instead')}},{key:'probe',value:function probe(priority,message){for(var _len3=arguments.length,args=Array(2<_len3?_len3-2:0),_key3=2;_key3<_len3;_key3++)args[_key3-2]=arguments[_key3];return this._getLogFunction({priority:priority,message:message,args:args,method:originalConsole.log,time:!0,once:!0})}},{key:'log',value:function log(priority,message){for(var _len4=arguments.length,args=Array(2<_len4?_len4-2:0),_key4=2;_key4<_len4;_key4++)args[_key4-2]=arguments[_key4];return this._getLogFunction({priority:priority,message:message,args:args,method:originalConsole.debug})}},{key:'info',value:function info(priority,message){for(var _len5=arguments.length,args=Array(2<_len5?_len5-2:0),_key5=2;_key5<_len5;_key5++)args[_key5-2]=arguments[_key5];return this._getLogFunction({priority:priority,message:message,args:args,method:console.info})}},{key:'once',value:function once(priority,message){for(var _len6=arguments.length,args=Array(2<_len6?_len6-2:0),_key6=2;_key6<_len6;_key6++)args[_key6-2]=arguments[_key6];return this._getLogFunction({priority:priority,message:message,args:args,method:originalConsole.debug||originalConsole.info,once:!0})}},{key:'table',value:function table(priority,_table,columns){if(_table){var tag=getTableHeader(_table);return this._getLogFunction({priority:priority,message:_table,args:columns&&[columns],tag:tag,method:console.table||noop})}return noop}},{key:'image',value:function image(_ref2){var priority=_ref2.priority,_image=_ref2.image,_ref2$message=_ref2.message,message=void 0===_ref2$message?'':_ref2$message,_ref2$scale=_ref2.scale,scale=void 0===_ref2$scale?1:_ref2$scale;return priority>this.getPriority()?noop:_globals.isBrowser?this._logImageInBrowser({image:_image,message:message,scale:scale}):this._logImageInNode({image:_image,message:message,scale:scale})}},{key:'_logImageInNode',value:function _logImageInNode(_ref3){var image=_ref3.image,_ref3$message=_ref3.message,message=void 0===_ref3$message?'':_ref3$message,_ref3$scale=_ref3.scale,scale=void 0===_ref3$scale?1:_ref3$scale,asciify=null;try{asciify=module.require('asciify-image')}catch(error){}return asciify?function(){return asciify(image,{fit:'box',width:Math.round(80*scale)+'%'}).then(function(data){return console.log(data)})}:noop}},{key:'_logImageInBrowser',value:function _logImageInBrowser(_ref4){var image=_ref4.image,_ref4$message=_ref4.message,message=void 0===_ref4$message?'':_ref4$message,_ref4$scale=_ref4.scale,scale=void 0===_ref4$scale?1:_ref4$scale;if('string'==typeof image){var img=new Image;return img.onload=function(){var _console,args=(0,_formatters.formatImage)(img,message,scale);(_console=console).log.apply(_console,_toConsumableArray(args))},img.src=image,noop}var element=image.nodeName||'';if('img'===element.toLowerCase()){var _console2;return(_console2=console).log.apply(_console2,_toConsumableArray((0,_formatters.formatImage)(image,message,scale))),noop}if('canvas'===element.toLowerCase()){var _img=new Image;return _img.onload=function(){var _console3;return(_console3=console).log.apply(_console3,_toConsumableArray((0,_formatters.formatImage)(_img,message,scale)))},_img.src=image.toDataURL(),noop}return noop}},{key:'time',value:function time(priority,message){return this._getLogFunction({priority:priority,message:message,method:console.time?console.time:console.info})}},{key:'timeEnd',value:function timeEnd(priority,message){return this._getLogFunction({priority:priority,message:message,method:console.timeEnd?console.timeEnd:console.info})}},{key:'timeStamp',value:function timeStamp(priority,message){return this._getLogFunction({priority:priority,message:message,method:console.timeStamp||noop})}},{key:'group',value:function group(priority,message){var opts=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{collapsed:!1};opts=this._normalizeArguments({priority:priority,message:message,opts:opts});var _opts=opts,collapsed=_opts.collapsed;return this._getLogFunction({priority:priority,message:message,opts:opts,method:(collapsed?console.groupCollapsed:console.group)||console.info})}},{key:'groupCollapsed',value:function groupCollapsed(priority,message){var opts=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};return this.group(priority,message,Object.assign({},opts,{collapsed:!0}))}},{key:'groupEnd',value:function groupEnd(priority){return this._getLogFunction({priority:priority,message:'',method:console.groupEnd||noop})}},{key:'withGroup',value:function withGroup(priority,message,func){var opts=this._normalizeArguments({priority:priority,message:message});this.group(opts);try{func()}finally{this.groupEnd(opts.message)}}},{key:'trace',value:function trace(){console.trace&&console.trace()}},{key:'_shouldLog',value:function _shouldLog(priority){return priority=this._normalizePriority(priority),0===priority||this.isEnabled()&&this.getPriority()>=priority}},{key:'_getElapsedTime',value:function _getElapsedTime(){var total=this.getTotal(),delta=this.getDelta();return this._deltaTs=(0,_timestamp.getTimestamp)(),{total:total,delta:delta}}},{key:'_getLogFunction',value:function _getLogFunction(opts){if(this._shouldLog(opts.priority)){var _opts2=opts,method=_opts2.method;opts=this._parseArguments(opts),(0,_assert2.default)(method);var _opts3=opts,message=_opts3.message,tag=opts.tag||opts.message;if(opts.once)if(!cache[tag])cache[tag]=(0,_timestamp.getTimestamp)();else return noop;return message=this._decorateMessage(message,opts),method.bind.apply(method,[console,message].concat(_toConsumableArray(opts.args)))}return noop}},{key:'_parseArguments',value:function _parseArguments(options){var normOpts=this._normalizeArguments(options),_getElapsedTime2=this._getElapsedTime(),delta=_getElapsedTime2.delta,total=_getElapsedTime2.total;return Object.assign(options,normOpts,{delta:delta,total:total})}},{key:'_normalizePriority',value:function _normalizePriority(priority){var resolvedPriority;switch('undefined'==typeof priority?'undefined':_typeof(priority)){case'number':resolvedPriority=priority;break;case'object':resolvedPriority=priority.priority||0;break;default:resolvedPriority=0;}return(0,_assert2.default)(Number.isFinite(resolvedPriority)&&0<=resolvedPriority),resolvedPriority}},{key:'_normalizeArguments',value:function _normalizeArguments(_ref5){var priority=_ref5.priority,message=_ref5.message,_ref5$args=_ref5.args,args=void 0===_ref5$args?[]:_ref5$args,opts=_ref5.opts,newOpts={priority:this._normalizePriority(priority),message:message,args:args};switch('undefined'==typeof priority?'undefined':_typeof(priority)){case'string':case'function':void 0!==message&&args.unshift(message),Object.assign(newOpts,{message:priority});break;case'object':Object.assign(newOpts,priority);break;default:}return'function'==typeof newOpts.message&&(newOpts.message=this._shouldLog(newOpts.priority)?newOpts.message():''),(0,_assert2.default)('string'==typeof newOpts.message||'object'===_typeof(newOpts.message)),Object.assign(newOpts,opts)}},{key:'_decorateMessage',value:function _decorateMessage(message,opts){if('string'==typeof message){var time='';if(opts.time){var _getElapsedTime3=this._getElapsedTime(),total=_getElapsedTime3.total;time=(0,_formatters.leftPad)((0,_formatters.formatTime)(total))}message=opts.time?this.id+': '+time+'  '+message:this.id+': '+message,message=(0,_color.addColor)(message,opts.color,opts.background)}return message}},{key:'priority',set:function set(newPriority){return this._storage.updateConfiguration({priority:newPriority}),this},get:function get(){return this._storage.config.priority}}]),Log}();exports.default=Log,Log.VERSION=_globals.VERSION;
//# sourceMappingURL=log.js.map