'use strict';Object.defineProperty(exports,'__esModule',{value:!0});var _createClass=function(){function defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,'value'in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}return function(Constructor,protoProps,staticProps){return protoProps&&defineProperties(Constructor.prototype,protoProps),staticProps&&defineProperties(Constructor,staticProps),Constructor}}(),_timestamp=require('./utils/timestamp'),_formatters=require('./utils/formatters');function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError('Cannot call a class as a function')}var Stats=function(){function Stats(_ref){var id=_ref.id;_classCallCheck(this,Stats),this.id=id,this.time=(0,_timestamp.getTimestamp)(),this.counters={},Object.seal(this)}var _Mathround=Math.round;return _createClass(Stats,[{key:'addCounter',value:function addCounter(name){return this._getCounter(name),this}},{key:'bump',value:function bump(name){var counter=this._getCounter(name);return counter.call++,counter.count++,this}},{key:'increment',value:function increment(name,count){var counter=this._getCounter(name);return counter.call++,counter.count+=count,this}},{key:'addTimer',value:function addTimer(name){var timer=this._getCounter(name);return timer.time=0,this}},{key:'addTime',value:function addTime(name,time){var timer=this._getCounter(name);return timer.time+=time,timer.count++,this}},{key:'timeStart',value:function timeStart(name){var timer=this._getCounter(name);timer._startTime=(0,_timestamp.getTimestamp)()}},{key:'timeEnd',value:function timeEnd(name){var timer=this._getCounter(name);this.addTime(name,(0,_timestamp.getTimestamp)()-timer._startTime)}},{key:'reset',value:function reset(){for(var key in this.time=(0,_timestamp.getTimestamp)(),this.counters){var counter=this.counters[key];counter.count=0,counter.time=0}return this}},{key:'hasTimeElapsed',value:function hasTimeElapsed(){0<arguments.length&&void 0!==arguments[0]?arguments[0]:1e3;return 1e3<(0,_timestamp.getTimestamp)()-this.time}},{key:'getStats',value:function getStats(){var deltaTime=((0,_timestamp.getTimestamp)()-this.time)/1e3,stats={};for(var key in this.counters){var counter=this.counters[key];stats[counter.title]={total:counter.count,fps:_Mathround(counter.count/deltaTime)},counter.time&&(stats[counter.title].totalTime=(0,_formatters.formatTime)(counter.time),stats[counter.title].avgTime=(0,_formatters.formatTime)(counter.time/counter.count))}return stats}},{key:'getStatsTable',value:function getStatsTable(){var stats=this.getStats();for(var key in stats)0===stats[key].total&&delete stats[key];return stats}},{key:'getStatNames',value:function getStatNames(){return Object.keys(this.counters)}},{key:'get',value:function get(name){var counter=this._getCounter(name);return counter.count}},{key:'getCount',value:function getCount(name){var counter=this._getCounter(name);return counter.count}},{key:'getFPS',value:function getFPS(name){var counter=this._getCounter(name),deltaTime=((0,_timestamp.getTimestamp)()-this.time)/1e3;return _Mathround(counter.count/deltaTime)}},{key:'getTimeString',value:function getTimeString(){return this.id+':'+(0,_formatters.formatTime)(this.time)+'('+this.count+')'}},{key:'oneSecondPassed',value:function oneSecondPassed(){var deltaTime=0<arguments.length&&void 0!==arguments[0]?arguments[0]:1e3;return this.hasTimeElapsed(deltaTime)}},{key:'_getCounter',value:function _getCounter(name){var counter=this.counters[name];return counter||(counter={title:name,unit:'',timer:!1,count:0,time:0,totalTime:0,averageTime:0},this.counters[name]=counter),counter}},{key:'_incrementTimer',value:function _incrementTimer(counter,time,count){counter.count+=count,counter.totalTime+=time,counter.averageTime=counter.totalTime/count}}]),Stats}();exports.default=Stats;
//# sourceMappingURL=stats.js.map