'use strict';Object.defineProperty(exports,'__esModule',{value:!0}),exports.formatTime=formatTime,exports.leftPad=leftPad,exports.rightPad=rightPad,exports.getSISuffix=getSISuffix,exports.formatSI=formatSI,exports.formatValue=formatValue,exports.formatImage=formatImage;function formatTime(ms){var formatted;return formatted=10>ms?ms.toFixed(2)+'ms':100>ms?ms.toFixed(1)+'ms':1e3>ms?ms.toFixed(0)+'ms':(ms/1e3).toFixed(2)+'s',formatted}function leftPad(string){var length=1<arguments.length&&arguments[1]!==void 0?arguments[1]:8,padLength=Math.max(length-string.length,0);return''+' '.repeat(padLength)+string}function rightPad(string){var length=1<arguments.length&&arguments[1]!==void 0?arguments[1]:8,padLength=Math.max(length-string.length,0);return''+string+' '.repeat(padLength)}function splitIntoBaseAndExponent(number){var base=number,exponent=0;if(0!==number){for(;10<=base||-10>=base;)base/=10,exponent++;for(;1>base&&-1<base;)base*=10,exponent--}return{base:base,exponent:exponent}}function getSISuffix(multipleOf3){var SI_SUFFIXES={0:'',1:'K',2:'M',3:'G',"-1":'m',"-2":'\xB5',"-3":'n'},key=multipleOf3+'';return key in SI_SUFFIXES?SI_SUFFIXES[key]:'e'+3*multipleOf3}function formatSI(number){var precision=1<arguments.length&&arguments[1]!==void 0?arguments[1]:3,_splitIntoBaseAndExpo=splitIntoBaseAndExponent(number),base=_splitIntoBaseAndExpo.base,exponent=_splitIntoBaseAndExpo.exponent,multipleOf3=Math.floor(exponent/3),digits=base*Math.pow(10,exponent-3*multipleOf3);return''+digits.toPrecision(precision)+getSISuffix(multipleOf3)}function formatValue(v){var _Mathabs=Math.abs,opts=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},_opts$isInteger=opts.isInteger,isInteger=void 0!==_opts$isInteger&&_opts$isInteger;if(Array.isArray(v)||ArrayBuffer.isView(v))return formatArrayValue(v,opts);if(!Number.isFinite(v))return v+'';if(_Mathabs(v)<1e-16)return isInteger?'0':'0.';if(isInteger)return v.toFixed(0);if(100<_Mathabs(v)&&1e4>_Mathabs(v))return v.toFixed(0);var string=v.toPrecision(2),decimal=string.indexOf('.0');return decimal===string.length-2?string.slice(0,-1):string}function formatArrayValue(v,opts){for(var _opts$maxElts=opts.maxElts,maxElts=_opts$maxElts===void 0?16:_opts$maxElts,_opts$size=opts.size,size=_opts$size===void 0?1:_opts$size,string='[',i=0;i<v.length&&i<maxElts;++i)0<i&&(string+=','+(0==i%size?' ':'')),string+=formatValue(v[i],opts);var terminator=v.length>maxElts?'...':']';return''+string+terminator}function formatImage(image,message,scale){var _Mathfloor=Math.floor,maxWidth=3<arguments.length&&void 0!==arguments[3]?arguments[3]:600,imageUrl=image.src.replace(/\(/g,'%28').replace(/\)/g,'%29');image.width>maxWidth&&(scale=Math.min(scale,maxWidth/image.width));var width=image.width*scale,height=image.height*scale,style=['font-size:1px;','padding:'+_Mathfloor(height/2)+'px '+_Mathfloor(width/2)+'px;','line-height:'+height+'px;','background:url('+imageUrl+');','background-size:'+width+'px '+height+'px;','color:transparent;'].join('');return[message+' %c+',style]}
//# sourceMappingURL=formatters.js.map