"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMobile = isMobile;
exports["default"] = getBrowser;

var _globals = require("./globals");

var _isBrowser = _interopRequireDefault(require("./is-browser"));

var _isElectron = _interopRequireDefault(require("./is-electron"));

function isMobile() {
  return typeof _globals.window.orientation !== 'undefined';
}

function getBrowser(mockUserAgent) {
  if (!mockUserAgent && !(0, _isBrowser["default"])()) {
    return 'Node';
  }

  if ((0, _isElectron["default"])(mockUserAgent)) {
    return 'Electron';
  }

  var navigator_ = typeof navigator !== 'undefined' ? navigator : {};
  var userAgent = mockUserAgent || navigator_.userAgent || '';

  if (userAgent.indexOf('Edge') > -1) {
    return 'Edge';
  }

  var isMSIE = userAgent.indexOf('MSIE ') !== -1;
  var isTrident = userAgent.indexOf('Trident/') !== -1;

  if (isMSIE || isTrident) {
    return 'IE';
  }

  if (_globals.window.chrome) {
    return 'Chrome';
  }

  if (_globals.window.safari) {
    return 'Safari';
  }

  if (_globals.window.mozInnerScreenX) {
    return 'Firefox';
  }

  return 'Unknown';
}
//# sourceMappingURL=get-browser.js.map