"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = getHiResTimestamp;

var _globals = require("./globals");

function getHiResTimestamp() {
  var timestamp;

  if (_globals.isBrowser && _globals.window.performance) {
    timestamp = _globals.window.performance.now();
  } else if (_globals.process.hrtime) {
    var timeParts = _globals.process.hrtime();

    timestamp = timeParts[0] * 1000 + timeParts[1] / 1e6;
  } else {
    timestamp = Date.now();
  }

  return timestamp;
}
//# sourceMappingURL=hi-res-timestamp.js.map