import { window, process, isBrowser } from './globals';
export default function getHiResTimestamp() {
  var timestamp;

  if (isBrowser && window.performance) {
    timestamp = window.performance.now();
  } else if (process.hrtime) {
    var timeParts = process.hrtime();
    timestamp = timeParts[0] * 1000 + timeParts[1] / 1e6;
  } else {
    timestamp = Date.now();
  }

  return timestamp;
}
//# sourceMappingURL=hi-res-timestamp.js.map