'use strict';
var isFn = require('is-fn');
var setImmediate = require('set-immediate-shim');

module.exports = function (promise) {
	if (!isFn(promise.then)) {
		throw new TypeError('Expected a promise');
	}

	return function (cb) {
		promise.then(function (data) {
			setImmediate(cb, null, data);
		}, function (err) {
			setImmediate(cb, err);
		});
	};
};
